% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alleleFreqs.R
\name{alleleFreqs}
\alias{alleleFreqs}
\title{Allele Frequencies}
\usage{
alleleFreqs(g, by.strata = FALSE)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{by.strata}{logical. If \code{TRUE} every element in the return list is 
a three dimensional array where the third dimension contains frequencies 
and proportions for each stratum.}
}
\value{
A list of allele frequencies for each locus. Each element is a
  matrix or array with frequencies by count (\code{freq}) and 
  proportion (\code{prop}) of each allele.
}
\description{
Calculate allele frequencies for each locus.
}
\note{
If \code{g} is a haploid object with sequences, make sure to run 
  \code{\link{labelHaplotypes}} if sequences aren't already grouped by 
  haplotype.
}
\examples{
data(msats.g)

f <- alleleFreqs(msats.g)
f$D11t # Frequencies and proportions for Locus D11t

f.pop <- alleleFreqs(msats.g, TRUE)
f.pop$EV94[, "freq", "Coastal"] # Frequencies for EV94 in the Coastal population

}
\seealso{
\link{alleleFreqFormat}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
