% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseFreqs.R
\name{baseFreqs}
\alias{baseFreqs}
\title{Base Frequencies}
\usage{
baseFreqs(x, bases = NULL, ignore = c("n", "x", "-", "."))
}
\arguments{
\item{x}{a \linkS4class{gtypes} object with aligned sequences or a list of 
aligned DNA sequences.}

\item{bases}{character vector of bases. Must contain valid IUPAC codes. 
If \code{NULL}, will return summary of frequencies of observed bases.}

\item{ignore}{a character vector of bases to ignore when 
calculating frequencies.}
}
\value{
For each gene, a list containing:
\tabular{ll}{
  \code{site.freqs} \tab a matrix of base frequencies at each site.\cr
  \code{base.freqs} \tab a vector of overall base proportion composition.\cr
}
}
\description{
Calculate nucleotide base frequencies along a sequence.
}
\examples{
data(dloop.g)
bf <- baseFreqs(dloop.g)

# Frequencies of first 10 sites
bf$site.freqs[, 1:10]

# Base composition
bf$base.freqs

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
