% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandHaplotypes.R
\name{expandHaplotypes}
\alias{expandHaplotypes}
\title{Expand haplotypes}
\usage{
expandHaplotypes(g)
}
\arguments{
\item{g}{a haploid \linkS4class{gtypes} object with sequences.}
}
\value{
a \code{gtypes} object with sequences expanded and renamed so there is
  one sequence per individual. Sequence names are set to individual sample IDs.
}
\description{
Expand haplotypes to a single sequence per individual.
}
\examples{
data(dloop.g)

# Haplotypes have already been labelled
dloop.g

# Haplotypes expanded to individual sequences (num.alleles == num.samples)
expanded.g <- expandHaplotypes(dloop.g)
expanded.g

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
