% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega.R
\name{mega}
\alias{mega}
\alias{read.mega}
\alias{mega,}
\alias{MEGA}
\alias{write.mega}
\title{Read and Write MEGA}
\usage{
read.mega(file)

write.mega(g, file = NULL, label = NULL, line.width = 60, locus = 1)
}
\arguments{
\item{file}{a MEGA-formatted file of sequences.}

\item{g}{a \linkS4class{gtypes} object.}

\item{label}{label for MEGA filename (.meg). If \code{NULL}, the 
gtypes description is used if present.}

\item{line.width}{width of sequence lines.}

\item{locus}{number or name of locus to write.}
}
\value{
for \code{read.mega}, a list of:
\describe{
  \item{title}{title of MEGA file}
  \item{dna.seq}{DNA sequences in \code{\link[ape]{DNAbin}} format}
}
}
\description{
Read and write MEGA formatted files.
}
\references{
Sudhir Kumar, Glen Stecher, and Koichiro Tamura (2015) 
  MEGA7: Molecular Evolutionary Genetics Analysis version 7.0. 
  Molecular Biology and Evolution (submitted).
  Available at: \url{http://www.megasoftware.net}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
