% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_2sided.R
\name{rnabox}
\alias{rnabox}
\title{Recursive Neyman Algorithm for Optimal Sample Allocation Under Box Constraints}
\usage{
rnabox(n, a, m = NULL, M = NULL)
}
\arguments{
\item{n}{(\code{number})\cr total sample size. A strictly positive scalar.
If \code{m} is not \code{NULL}, it is then is required that \code{n >= sum(m)}.
If \code{M} is not \code{NULL}, it is then is required that \code{n <= sum(m)}.}

\item{a}{(\code{numeric})\cr population constants \eqn{A_1,\ldots,A_H}. Strictly
positive numbers.}

\item{m}{(\code{numeric} or \code{NULL})\cr lower bounds \eqn{m_1,\ldots,m_H},
optionally imposed on sample sizes in strata. If no lower bounds should be
imposed, then \code{m} must be set to \code{NULL}.}

\item{M}{(\code{numeric} or \code{NULL})\cr upper bounds \eqn{M_1,\ldots,M_H},
optionally imposed on sample sizes in strata. If no upper bounds should be
imposed, then \code{M} must be set to \code{NULL}.}
}
\value{
Numeric vector with optimal sample allocations in strata.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

An internal function that implements the \code{RNABOX} algorithm that solves the
following optimal allocation problem, formulated below in the language of
mathematical optimization.

Minimize
\deqn{f(x_1,\ldots,x_H) = \sum_{h=1}^H \frac{A^2_h}{x_h}}
subject to
\deqn{\sum_{h=1}^H x_h = n}
\deqn{m_h \leq x_h \leq M_h, \quad h = 1,\ldots,H,}
where \eqn{n > 0,\, A_h > 0,\, m_h > 0,\, M_h > 0,\, h = 1, \ldots ,H}, such
that \eqn{\sum_{h=1}^H m_h \leq n \leq \sum_{h=1}^H M_h} are given numbers.
The minimization is on \eqn{\mathbb R_+^H}.
Inequality constraints are optional and can be skipped.

`rnabox() function should not be called directly by the user. Use \code{\link[=opt]{opt()}}
instead.
}
\examples{
N <- c(454, 10, 116, 2500, 2240, 260, 39, 3000, 2500, 400)
S <- c(0.9, 5000, 32, 0.1, 3, 5, 300, 13, 20, 7)
a <- N * S
m <- c(322, 3, 57, 207, 715, 121, 9, 1246, 1095, 294) # lower bounds
M <- N # upper bounds

# An example of a regular allocation.
n <- 6000
opt_regular <- rnabox(n, a, m, M)

# An example of a vertex allocation.
n <- 4076
opt_vertex <- rnabox(n, a, m, M)
}
\references{
To be added soon.
}
\seealso{
\code{\link[=opt]{opt()}}, \code{\link[=optcost]{optcost()}}, \code{\link[=sga]{sga()}}, \code{\link[=sgaplus]{sgaplus()}}, \code{\link[=coma]{coma()}}.
}
