% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_data.R
\name{animate_data}
\alias{animate_data}
\alias{animate}
\alias{animation}
\title{Animates the Plotting of a Data Streams}
\usage{
animate_data(dsd, horizon = 100, n = 1000, wait = 0.1, plot.args = NULL, ...)
}
\arguments{
\item{dsd}{a DSD object}

\item{horizon}{the number of points displayed at once/used for evaluation.}

\item{n}{the number of points to be plotted}

\item{wait}{the time interval between each frame}

\item{plot.args}{a list with plotting parameters for the clusters.}

\item{...}{extra arguments are added to \code{plot.args}.}
}
\description{
Generates an animation of a data stream.
}
\details{
Animations are recorded using the library animation and can be replayed
(which gives a smoother experience since the is no more computation done)
and saved in various formats (see Examples section below).

\strong{Note:} You need to install package \pkg{animation} and
its system requirements.
}
\examples{
if (interactive()) {

stream <- DSD_Benchmark(1)
animate_data(stream, horizon = 100, n = 5000, xlim = c(0,1), ylim = c(0,1))

### animations can be replayed with the animation package
library(animation)
animation::ani.options(interval = .1) ## change speed
ani.replay()

### animations can also be saved as HTML, animated gifs, etc.
saveHTML(ani.replay())
}
}
\seealso{
\code{\link[animation:ani.record]{animation::ani.replay()}} for replaying and saving animations.

Other DSD: 
\code{\link{DSD}()},
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Cubes}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_Mixture}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadDB}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_Target}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchData}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSF}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}

Other plot: 
\code{\link{animate_cluster}()},
\code{\link{plot.DSC}()},
\code{\link{plot.DSD}()}
}
\author{
Michael Hahsler
}
\concept{DSD}
\concept{plot}
