% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish_DSD_via_Socket.R
\name{publish_DSD_via_Socket}
\alias{publish_DSD_via_Socket}
\title{Publish a Data Stream using a Socket}
\usage{
publish_DSD_via_Socket(dsd, port, blocksize = 1024L, background = TRUE, ...)
}
\arguments{
\item{dsd}{A DSD object.}

\item{port}{port used to serve the DSD.}

\item{blocksize}{number of data points pushed on the buffer at once.}

\item{background}{logical; start a background process?}

\item{...}{further arguments are passed on to \code{\link[=socketConnection]{socketConnection()}}.}
}
\value{
a \link[processx:process]{processx::process} object created with \code{\link[callr:r_bg]{callr::r_bg()}} which runs the plumber server
in the background. The process can be stopped with \code{rp$kill()} or by killing the process
using the operating system with the appropriate PID. \code{rp$get_result()} can
be used to check for errors in the server process (e.g., when it terminates
unexpectedly).
}
\description{
Creates a socket server connection to send steam data.
}
\details{
Creates a server socket with \code{\link[=socketConnection]{socketConnection()}}
and then uses a \code{\link[stream:write_stream]{stream::write_stream()}} to write data to a socket connection.
This method does not provide a header for the data.
}
\examples{
# find a free port
port <- httpuv::randomPort()
port

# create a background DSD process sending data to the port
rp1 <- DSD_Gaussians(k = 3, d = 3) \%>\% publish_DSD_via_Socket(port = port)
rp1

# connect to the port (retry waits for the socket to establish)
con <- retry(socketConnection(port = port, open = 'r'))
dsd <- retry(DSD_ReadStream(con, col.names = c("x", "y", "z", ".class")))

get_points(dsd, n = 10)

plot(dsd)

# close connection
close_stream(dsd)

# end the DSD process. Note: that closing the connection above
# may already kill the process.
rp1$kill()
rp1
}
\seealso{
Other Socket: 
\code{\link{DSD_ReadSocket}()}

Other dsd: 
\code{\link{DSD_ReadSocket}()},
\code{\link{DSD_ReadWebService}()},
\code{\link{publish_DSD_via_WebService}()}
}
\concept{Socket}
\concept{dsd}
