/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.meta;

import moa.classifiers.Classifier;
import moa.classifiers.meta.OzaBag;
import moa.core.InstancesHeader;
import weka.core.Instance;

public class MLOzaBag
extends OzaBag {
    protected int m_L = -1;

    public void resetLearningImpl() {
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = baseLearner.copy();
        }
    }

    public void setModelContext(InstancesHeader raw_header) {
        this.modelContext = raw_header;
        this.m_L = raw_header.classIndex() + 1;
        this.resetLearningImpl();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i].setModelContext(raw_header);
            this.ensemble[i].resetLearning();
        }
    }

    public boolean isRandomizable() {
        return true;
    }

    public double[] getVotesForInstance(Instance x) {
        int L = x.classIndex() + 1;
        if (this.m_L != L) {
            this.m_L = L;
        }
        double[] y = new double[this.m_L];
        for (int i = 0; i < this.ensemble.length; ++i) {
            double[] w = this.ensemble[i].getVotesForInstance(x);
            for (int j = 0; j < w.length; ++j) {
                int n = j;
                y[n] = y[n] + w[j];
            }
        }
        return y;
    }
}

