/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch;

import moa.classifiers.lazy.neighboursearch.NormalizableDistance;
import weka.core.Instance;
import weka.core.Instances;

public class EuclideanDistance
extends NormalizableDistance
implements Cloneable {
    private static final long serialVersionUID = 1068606253458807903L;

    public EuclideanDistance() {
    }

    public EuclideanDistance(Instances data) {
        super(data);
    }

    public String globalInfo() {
        return "Implementing Euclidean distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\n";
    }

    public double distance(Instance first, Instance second) {
        return Math.sqrt(this.distance(first, second, Double.POSITIVE_INFINITY));
    }

    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        return result += diff * diff;
    }

    public void postProcessDistances(double[] distances) {
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = Math.sqrt(distances[i]);
        }
    }

    public double sqDifference(int index, double val1, double val2) {
        double val = this.difference(index, val1, val2);
        return val * val;
    }

    public double getMiddle(double[] ranges) {
        double middle = ranges[0] + ranges[2] * 0.5;
        return middle;
    }

    public int closestPoint(Instance instance, Instances allPoints, int[] pointList) throws Exception {
        double minDist = 2.147483647E9;
        int bestPoint = 0;
        for (int i = 0; i < pointList.length; ++i) {
            double dist = this.distance(instance, allPoints.instance(pointList[i]), Double.POSITIVE_INFINITY);
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestPoint = i;
        }
        return pointList[bestPoint];
    }

    public boolean valueIsSmallerEqual(Instance instance, int dim, double value) {
        return instance.value(dim) <= value;
    }
}

