/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriter;
import com.opencsv.ICSVParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.clusterers.AbstractClusterer;
import moa.core.ObjectRepository;
import moa.gui.visualization.RunVisualizer;
import moa.options.ClassOption;
import moa.streams.clustering.ClusteringStream;
import moa.streams.clustering.FileStream;
import moa.tasks.AuxiliarMainTask;
import moa.tasks.EvaluateClustering;
import moa.tasks.TaskMonitor;

public class EvaluateMultipleClusterings
extends AuxiliarMainTask {
    private static final long serialVersionUID = 4846907962483608940L;
    String defaultfile = "covtypeNorm.arff";
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Clusterer to train.", AbstractClusterer.class, "clustream.Clustream");
    public ClassOption streamOption = new ClassOption("stream", 's', "Base stream to learn from (must use FileStream).", ClusteringStream.class, "FileStream");
    public IntOption numStreamsOption = new IntOption("numStreams", 'n', "The number of streams to iterate through (must be named according to WriteMultipleStreamsToARFF format.", 100, 2, Integer.MAX_VALUE);
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv reslts to.", "dumpClustering.csv", "csv", true);
    public FlagOption mergeResultsOption = new FlagOption("mergeResults", 'm', "Produce a csv file that contains all of the individual results merged together.");
    public FlagOption generalEvalOption = new FlagOption("General", 'g', "GPrecision, GRecall, Redundancy, numCluster, numClasses");
    public FlagOption f1Option = new FlagOption("F1", 'f', "F1-P, F1-R, Purity.");
    public FlagOption entropyOption = new FlagOption("Entropy", 'e', "GT cross entropy, FC cross entropy, Homogeneity, Completeness, V-Measure, VarInformation.");
    public FlagOption cmmOption = new FlagOption("CMM", 'c', "CMM, CMM Basic, CMM Missed, CMM Misplaced, CMM Noise, CA Seperability, CA Noise, CA Model.");
    public FlagOption ssqOption = new FlagOption("SSQ", 'q', "SSQ.");
    public FlagOption separationOption = new FlagOption("Separation", 'p', "BSS, BSS-GT, BSS-Ratio.");
    public FlagOption silhouetteOption = new FlagOption("Silhouette", 'h', "SilhCoeff.");
    public FlagOption statisticalOption = new FlagOption("Statistical", 't', "van Dongen, Rand statistic.");
    protected EvaluateClustering task;

    @Override
    public String getPurposeString() {
        return "Evaluates a clusterer on multiple (related) streams.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return Object.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Object result = null;
        String mergedFile = this.dumpFileOption.getValueAsCLIString();
        String tempFile = mergedFile.substring(0, mergedFile.length() - 4).concat("*.csv");
        for (int i = 0; i < this.numStreamsOption.getValue(); ++i) {
            this.task = new EvaluateClustering();
            this.task.learnerOption.setValueViaCLIString(this.learnerOption.getValueAsCLIString());
            FileStream fStream = (FileStream)this.getPreparedClassOption(this.streamOption);
            String arffFile = fStream.arffFileOption.getValueAsCLIString();
            arffFile = arffFile.substring(0, arffFile.lastIndexOf(110) + 1).concat(i + ".arff");
            fStream.arffFileOption.setValueViaCLIString(arffFile);
            this.task.streamOption.setValueViaCLIString(fStream.getCLICreationString(fStream.getClass()));
            String outputFile = this.dumpFileOption.getValueAsCLIString();
            if (outputFile.endsWith(".csv")) {
                outputFile = outputFile.substring(0, outputFile.length() - 4);
            }
            outputFile = outputFile.concat("n" + i + ".csv");
            this.task.dumpFileOption.setValueViaCLIString(outputFile);
            this.task.instanceLimitOption.setValue(-1);
            boolean[] measureCollection = new boolean[]{this.generalEvalOption.isSet(), this.f1Option.isSet(), this.entropyOption.isSet(), this.cmmOption.isSet(), this.ssqOption.isSet(), this.separationOption.isSet(), this.silhouetteOption.isSet(), this.statisticalOption.isSet()};
            this.task.setMeasures(measureCollection);
            System.out.println("Evaluation #" + (i + 1) + " of " + this.numStreamsOption.getValue() + ": " + this.task.getCLICreationString(this.task.getClass()));
            result = this.task.doTask(monitor, repository);
            if (!this.mergeResultsOption.isSet()) continue;
            System.out.println("Merge " + mergedFile + " and " + outputFile);
            if (i == 0) {
                this.writeToMergeFile(mergedFile, outputFile);
                continue;
            }
            this.mergeFiles(mergedFile, outputFile, tempFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToMergeFile(String mergedFile, String outputFile) {
        CSVWriter writer = null;
        CSVParser parser = null;
        CSVReader reader = null;
        try {
            if (!mergedFile.endsWith(".csv")) {
                mergedFile = mergedFile + ".csv";
            }
            writer = new CSVWriter((Writer)new FileWriter(mergedFile), ';', '\"', '\\', "\n");
            parser = new CSVParserBuilder().withSeparator(';').withIgnoreQuotations(false).build();
            reader = new CSVReaderBuilder((Reader)new FileReader(outputFile)).withCSVParser((ICSVParser)parser).build();
            String[] nextLine = reader.readNext();
            while (nextLine != null) {
                writer.writeNext(nextLine);
                nextLine = reader.readNext();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(RunVisualizer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                writer.close();
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeFiles(String mergedFile, String outputFile, String tempFile) {
        CSVWriter writer = null;
        CSVParser parser1 = null;
        CSVReader reader1 = null;
        CSVParser parser2 = null;
        CSVReader reader2 = null;
        try {
            if (!mergedFile.endsWith(".csv")) {
                mergedFile = mergedFile + ".csv";
            }
            writer = new CSVWriter((Writer)new FileWriter(tempFile), ';', '\"', '\\', "\n");
            parser1 = new CSVParserBuilder().withSeparator(';').withIgnoreQuotations(false).build();
            reader1 = new CSVReaderBuilder((Reader)new FileReader(mergedFile)).withCSVParser((ICSVParser)parser1).build();
            parser2 = new CSVParserBuilder().withSeparator(';').withIgnoreQuotations(false).build();
            reader2 = new CSVReaderBuilder((Reader)new FileReader(outputFile)).withCSVParser((ICSVParser)parser2).build();
            int state = 0;
            String[] nextLine1 = reader1.readNext();
            int mergedWidth = nextLine1.length;
            String[] nextLine2 = reader2.readNext();
            int outputWidth = nextLine2.length;
            String[] nextLine = this.mergeArrays(nextLine1, nextLine2);
            writer.writeNext(nextLine);
            while (state == 0) {
                nextLine1 = reader1.readNext();
                if (nextLine1 == null) {
                    nextLine1 = new String[mergedWidth];
                    ++state;
                }
                if ((nextLine2 = reader2.readNext()) == null) {
                    nextLine2 = new String[outputWidth];
                    state += 2;
                }
                if (state == 3) break;
                nextLine = this.mergeArrays(nextLine1, nextLine2);
                writer.writeNext(nextLine);
            }
            while (state == 1) {
                nextLine2 = reader2.readNext();
                if (nextLine == null) break;
                nextLine1 = new String[mergedWidth];
                nextLine = this.mergeArrays(nextLine1, nextLine2);
                writer.writeNext(nextLine);
            }
            while (state == 2) {
                nextLine1 = reader1.readNext();
                if (nextLine == null) {
                    break;
                }
                nextLine2 = new String[outputWidth];
                nextLine = this.mergeArrays(nextLine1, nextLine2);
                writer.writeNext(nextLine);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(RunVisualizer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                writer.close();
                reader1.close();
                reader2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writeToMergeFile(mergedFile, tempFile);
    }

    private String[] mergeArrays(String[] nextLine1, String[] nextLine2) {
        int i;
        int length1 = nextLine1.length;
        int length2 = nextLine2.length;
        if (nextLine1[nextLine1.length - 1].equals("")) {
            --length1;
        }
        if (nextLine2[nextLine2.length - 1].equals("")) {
            --length2;
        }
        String[] nextLine = new String[length1 + length2];
        for (i = 0; i < length1; ++i) {
            nextLine[i] = nextLine1[i];
        }
        for (i = 0; i < length2; ++i) {
            nextLine[length1 + i] = nextLine2[i];
        }
        return nextLine;
    }
}

