% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_view_search.R
\name{strview_search}
\alias{strview_search}
\alias{strview_searchByGeo}
\alias{strview_search_nnb}
\alias{strview_search_osm}
\alias{strview_search_multi}
\title{strview_search}
\usage{
strview_searchByGeo(
  x,
  y,
  r,
  epsg,
  bbox,
  token = "",
  limit = 10,
  fields = c(),
  ...
)

strview_search_nnb(x, y, epsg, token = "", fields = c(), ...)

strview_search_osm(bbox, epsg, token, fields = c(), size, ...)

strview_search_multi(viewpoints, epsg, token, fields = c(), ...)
}
\arguments{
\item{x}{numeric, indicating Longtitude degree of the center point.}

\item{y}{numeric, indicating latitude degree of the center point.}

\item{r}{numeric, indicating search distance (meter or feet) for LiDAR data.}

\item{epsg}{numeric, the EPSG code specifying the coordinate reference system.}

\item{bbox}{vector, a bounding box defining the geographical area for downloading data.}

\item{token}{character, API token of Mapillary.}

\item{limit}{numeric, indicating the number of returns. The maximum is 2000.}

\item{fields}{vector, a vector of fields indicates the information of images
to be retrieved (See details). 'is_pano', 'thumb_256_url', 'height', 'width',
'computed_geometry', 'computed_altitude', and 'detections' are retrieved
as a default setting.}

\item{...}{indicating filters (see details)}

\item{size}{numeric, (approximate) number of locations sampled on OSM spatial lines
(this is for strview_search_osm only).}

\item{viewpoints}{sf or matrix, indicating multiple degress-based coordinates
for searching available street views (this is for strview_search_multi only).}
}
\value{
For strview_searchByGeo(), a StreetscapeDataFrame returned combining
a dataframe of the image information.

For strview_search_nnb(), a StreetscapeDataFrame with one-row dataframe
will be returned if there is any available images near to the given point

For strview_search_osm(), a StreetscapeDataFrame that combines the information
of street views from all sampled points along the OSM lines within
the specified bounding box.

For strview_search_multi(), a StreetscapeDataFrame that combines the information
of street views based on the coordinates of multiple spatial points
}
\description{
strview_searchByGeo: Search for and download the meta information
of street view images via Mapillary API (See detials) based on coordinates
of a spatial point with a given distance or a bounding box.

strview_search_nnb: Search for the nearest (within 10m buffer)
available street view images and download meta information
via Mapillary API (See detials) given coordinates of a spatial point.

strview_search_osm: Search for street view images by
sampling locations along the OSM road lines and download meta information
via Mapillary API (See detials) given a bounding box.

strview_search_multi: Search for and download the meta information
of street view images via Mapillary API (See detials) based on multiple coordinates
}
\details{
strview_search

To request an API token of Mapillary,
please create your access token at https://mapillary.com/developer.
For 'fields', one can review all available fields in this package
by calling streetscape::field_list().
}
\note{
If there is no street view images within the search area,
the function only returns an integer 0.
}
\examples{
\donttest{
bbox <- c(-83.751812,42.272984,-83.741255,42.279716)
if (isTRUE(file.exists("streetscape_token.sysdata"))) {
 data <- streetscape::strview_searchByGeo(bbox = bbox,
                                          epsg = 2253,
                                          token = "",
                                          is_pano = TRUE)
 data <- streetscape::strview_searchByGeo(x = -83.741289,
                                          y = 42.270146,
                                          r = 100,
                                          epsg = 2253,
                                          token = "",
                                          is_pano = TRUE)
}
}

\donttest{
if (isTRUE(file.exists("streetscape_token.sysdata"))) {
 data <- streetscape::strview_search_nnb(
         x = -83.743460634278,
         y = 42.277848830294,
         epsg = 2253,
         token = '')
}
}
\donttest{
bbox <- c(-83.752041,42.274896,-83.740711,42.281945)
if (isTRUE(file.exists("streetscape_token.sysdata"))) {
 data <- streetscape::strview_search_osm(
         bbox = bbox,
         epsg = 2253,
         token = '',
         size = 100)
}
}
\donttest{
x <- c(-83.752041, -83.740711)
y <- c(42.274896, 42.281945)
viewpoints <- cbind(x, y)
if (isTRUE(file.exists("streetscape_token.sysdata"))) {
 data <- streetscape::strview_search_multi(
         viewpoints = viewpoints,
         epsg = 2253,
         token = '')
}
}

}
\seealso{
\code{\link[=available_field]{available_field()}} \code{\link[=available_filter]{available_filter()}} \code{\link[=see_streetscape_class]{see_streetscape_class()}}
}
