pvalue.Fstats <- function(x, type = c("supF", "aveF", "expF"), k, lambda)
{
  switch(match.arg(type),
  supF = {
    beta <- get("sc.beta.sup")
  },
  aveF = {
    beta <- get("sc.beta.ave")
  },
  expF = {
    beta <- get("sc.beta.exp")
  })
  m <- ncol(beta)-1
  if(lambda<1) tau <- lambda
  else tau <- 1/(1+sqrt(lambda))
  beta <- beta[(((k-1)*25 +1):(k*25)),]
  dummy <- beta[,(1:m)]%*%x^(0:(m-1))
  dummy <- dummy*(dummy>0)
  pp <- 1 - pchisq(dummy, beta[,(m+1)])
  if(tau==0.5)
    p <- 1 - pchisq(x, k)
  else if(tau <= 0.01)
    p <- pp[25]
  else if(tau >= 0.49)
    p <- ((0.5-tau)*pp[1] + (tau-0.49)*(1-pchisq(x,k)))*100
  else
  {
    taua <- (0.51-tau)*50
    tau1 <- floor(taua)
    p <- (tau1 + 1 - taua)*pp[tau1] + (taua-tau1)*pp[tau1+1]
  }
  p
}

"sc.beta.sup" <-
structure(c(-0.0648467, -0.15305667, -0.23071675, -0.29247661,
-0.35706588, -0.40514715, -0.45248386, -0.50458517, -0.55009159,
-0.60241623, -0.64308746, -0.68833676, -0.73136161, -0.78078198,
-0.82894221, -0.88430133, -0.9499265, -0.98828874, -1.04892713,
-1.11527783, -1.14992644, -1.24010871, -1.38522113, -1.48296473,
-1.78738608, -0.03933112, -0.14650989, -0.28765583, -0.35528752,
-0.49538961, -0.58780544, -0.66900489, -0.77825803, -0.87260977,
-0.96782445, -1.07358977, -1.12531079, -1.16041007, -1.2975797,
-1.36743697, -1.43012785, -1.53311747, -1.65273586, -1.79350728,
-1.9117747, -2.02659329, -2.18499383, -2.3765858, -2.51267262,
-3.05559851, -0.1250856, -0.27323021, -0.43148524, -0.48172245,
-0.6898932, -0.7928579, -0.85066146, -1.06133796, -1.11977435,
-1.20203015, -1.28736105, -1.45874969, -1.60889159, -1.64346161,
-1.68334797, -1.81974576, -2.02648892, -2.04820499, -2.3230492,
-2.59516448, -2.79776102, -3.03865047, -3.31299004, -3.65667229,
-4.09174097, -0.40798205, -0.58214849, -0.67464799, -0.85920669,
-0.99797889, -1.10019761, -1.24048639, -1.44519417, -1.43104108,
-1.52887344, -1.66695722, -1.79016819, -1.91159633, -1.93474222,
-1.94039709, -2.14388035, -2.34856811, -2.52186324, -2.81381108,
-3.02543477, -3.3338615, -3.70012182, -4.08017759, -4.47426188,
-5.32601074, -0.11619422, -0.46546717, -0.74391826, -1.02744491,
-1.26392205, -1.42145334, -1.65407989, -1.81536469, -2.02334533,
-2.09938834, -2.20567987, -2.44943836, -2.63257362, -2.81161264,
-2.98179286, -3.13342287, -3.30649507, -3.4646422, -3.54117909,
-3.53272742, -3.80907119, -4.20676069, -4.84259892, -5.47685207,
-6.39138173, -0.0687869, -0.33471313, -0.58645046, -0.84305517,
-1.17255237, -1.46491217, -1.55238215, -1.79236992, -1.78127768,
-2.21251422, -2.47288843, -2.61217463, -2.93562547, -3.34428329,
-3.48448133, -3.64732289, -3.79479594, -4.04745714, -4.13484904,
-4.27469148, -4.61491387, -4.91271109, -5.37456783, -6.01333062,
-7.08021496, -0.53689878, -0.58562073, -0.95896123, -1.31359234,
-1.55985878, -1.74442449, -2.0175967, -2.20599731, -2.25783227,
-2.53419037, -2.83535247, -2.94857734, -3.23125462, -3.35534682,
-3.46151576, -3.87863069, -4.23908351, -4.4191379, -4.82113958,
-4.95712189, -5.33535348, -5.94327236, -6.2144914, -6.95870114,
-8.48837563, -0.06587378, -0.58124366, -0.53482076, -0.70899479,
-1.07383099, -1.05381577, -1.27585106, -1.68931537, -2.18809932,
-2.50101866, -2.85948167, -3.35512723, -3.65167655, -4.01035186,
-4.24709439, -4.50345226, -4.9099655, -5.36063931, -5.73370206,
-6.09245707, -6.46768896, -6.84622409, -7.23578885, -7.80794405,
-9.19862689, -0.8377844, -1.18727357, -1.67892814, -2.13655356,
-2.40733753, -2.37013442, -2.49480314, -2.82625963, -3.17119868,
-3.5636537, -3.88321378, -4.0313254, -4.38155427, -4.50039414,
-4.87091786, -5.1383982, -5.39812039, -5.43335672, -6.18441355,
-6.60044603, -7.11669991, -7.46755944, -8.07312922, -8.86841479,
-10.22371148, -0.12732608, -0.77782321, -1.24808905, -1.76904345,
-2.09486459, -2.30685545, -2.70509677, -2.92069286, -3.1997618,
-3.6337934, -4.01274834, -4.50166071, -4.97277337, -5.21536918,
-5.65195302, -6.06457328, -6.0595936, -6.46819929, -6.87347962,
-7.25454462, -7.76257167, -8.18205476, -8.84260296, -9.55384281,
-11.00985153, -0.28687631, -1.01453484, -1.7401651, -2.14079218,
-2.50789978, -2.62260858, -2.8870498, -3.25691388, -3.77111395,
-4.02040298, -4.21877289, -4.20809405, -4.62395981, -5.28744427,
-5.60464823, -6.19483467, -6.56252902, -6.7891765, -6.97852808,
-7.81007221, -8.50886767, -9.01689388, -9.55606731, -10.47717098,
-11.89998388, -0.20697609, -1.25560706, -1.38547294, -1.87046797,
-2.32172961, -2.77530991, -3.42319608, -3.9141916, -3.98123284,
-4.27776907, -4.10943673, -4.62176712, -5.31805601, -5.801638,
-6.31362677, -6.83561824, -7.27842657, -7.79706943, -8.24233569,
-8.7511904, -9.26781892, -9.85615645, -10.35040195, -11.37537184,
-12.87922864, -0.96032292, -1.78562028, -1.97966067, -2.42158333,
-2.48856717, -3.28051437, -3.78503843, -4.14403801, -4.43321221,
-4.69094902, -5.06109662, -5.7273341, -5.795782, -6.50909126,
-6.60160327, -6.91561016, -7.54515073, -7.93078073, -8.41010623,
-8.86495369, -9.52126643, -10.30207235, -11.06975833, -12.15664045,
-13.88493811, -0.5305789, -0.80812173, -1.59572361, -2.19031473,
-2.39824582, -2.75800734, -3.49182845, -4.05510978, -4.45062227,
-4.75937805, -5.16988136, -5.77217189, -5.9007907, -6.28750433,
-6.66785584, -7.29857891, -7.96433421, -8.54188927, -8.94534315,
-9.35262892, -9.73355542, -10.52623971, -11.51719761, -12.35480897,
-14.61237001, -0.6739616, -1.03059879, -1.04906844, -1.25236282,
-1.64262441, -1.54300336, -2.4826069, -3.10322952, -3.81410781,
-4.42629192, -5.3093647, -5.73487329, -6.59234495, -6.77170123,
-7.5786476, -8.08212767, -8.54406816, -9.05194333, -9.3590013,
-9.73494274, -10.57869777, -11.42062974, -12.44191891, -13.69538964,
-15.485313, -0.0913465, -1.04378984, -1.96856694, -2.55693634,
-3.48268362, -3.98503866, -4.68248535, -4.79433839, -5.22778799,
-5.61157139, -5.77881057, -6.24269823, -7.00486744, -7.5911674,
-8.17764741, -8.21284923, -8.56768956, -9.1302657, -9.38913624,
-10.30386897, -11.01233954, -11.70690938, -12.26629045, -13.95205351,
-16.33802631, -1.19451064, -0.61304263, -1.78139109, -1.74865854,
-2.95068847, -3.9464868, -4.11204387, -5.01078513, -5.30560447,
-5.99452544, -6.35254017, -6.84941244, -7.22864758, -8.40745421,
-8.73700419, -9.42296398, -9.91701341, -10.45110576, -10.81712311,
-11.30777705, -11.96527304, -12.76105449, -13.73171703, -15.05430428,
-17.20018832, -0.57901589, -0.61566409, -1.94156883, -2.62055985,
-2.7790414, -3.57177154, -4.42213185, -5.10532787, -5.46108672,
-6.46824055, -6.35209946, -7.1942972, -7.76122523, -8.09612319,
-8.86934521, -9.24340158, -9.82676851, -10.6299845, -11.27685859,
-12.03859451, -12.73477308, -13.40440195, -14.15023958, -15.6500136,
-18.0989596, -1.32304249, -2.79621128, -3.56766199, -4.05795479,
-4.89711879, -5.92841321, -6.39059643, -7.0876829, -7.53083,
-8.01208734, -8.70797744, -9.44730653, -9.83731797, -10.010367,
-10.64602144, -11.18554702, -11.63296397, -12.1370488, -12.5235392,
-13.0082886, -13.5821605, -14.17176731, -14.94024433, -16.01544412,
-18.18744736, -0.93767346, -1.39743879, -2.78023901, -3.13333051,
-3.6981945, -4.63133758, -5.05468994, -5.93983376, -6.51943117,
-7.34041405, -7.87705422, -8.34525685, -8.8688471, -9.5207757,
-10.19551877, -10.86984218, -11.59017802, -12.13536344, -12.88553549,
-13.70987004, -14.26661135, -15.21057964, -16.08902791, -17.11358176,
-18.99297261, -1.91882482, -2.50977144, -1.64637756, -2.92698693,
-4.07208251, -5.13694912, -5.4194589, -5.70365743, -6.25263884,
-6.36733605, -7.06329052, -7.98139299, -8.76118074, -9.60618958,
-10.49489334, -11.2774052, -11.93420729, -12.57665664, -13.32753376,
-14.07700093, -14.91429075, -15.75739961, -16.8692775, -18.19943522,
-20.3546376, -1.0168543, -2.60495567, -2.86000663, -2.68675011,
-1.94661764, -3.48454706, -3.992952, -4.97105555, -4.5575301,
-5.45965609, -6.56098097, -8.3868022, -8.62176424, -10.1431575,
-11.04032773, -11.45645206, -12.11371089, -12.76806289, -13.177768,
-13.99800348, -14.80089189, -15.89462589, -17.22077668, -18.72943574,
-21.25689814, 0.94096473, -1.22725053, -1.75872846, -3.9575768,
-4.94110206, -5.7742865, -6.08848061, -6.58259851, -5.48128544,
-6.79236566, -7.53943946, -8.34133308, -8.1735607, -9.41939055,
-10.44472371, -10.87498349, -12.41061954, -13.05498712, -13.07771005,
-13.99905583, -15.10380703, -16.40762679, -18.05996121, -19.76683028,
-22.31185721, 1.08326391, 0.76051631, 2.07027863, -2.1057565,
-3.78479942, -5.13505669, -6.06385571, -6.79994277, -8.01575875,
-9.0065242, -9.39541502, -10.37808952, -11.16653768, -11.82597991,
-12.53712013, -13.31498065, -13.92159257, -14.51359909, -15.40003703,
-16.13707217, -16.63866207, -17.60771953, -18.6663428, -19.83568951,
-22.51568418, -2.11162974, -3.35339899, -3.72841764, -4.91865235,
-5.10718347, -5.34523901, -6.49950328, -6.56823372, -7.53743525,
-8.23573648, -8.27526709, -9.42134551, -10.64615787, -11.30236859,
-12.11073251, -12.6848716, -12.9766545, -14.16209122, -15.60464973,
-16.44342921, -17.13809253, -17.81256047, -19.05804694, -20.65856043,
-23.41820502, -0.05998747, -0.58564982, -1.39278332, -3.37780497,
-5.80306991, -6.30431193, -6.6490522, -7.72028924, -9.77306301,
-9.46699714, -10.44746836, -11.53549458, -11.5145561, -12.21245714,
-13.33619262, -13.93937444, -14.13636162, -15.13548602, -15.12544755,
-16.01073023, -17.45954163, -18.52209521, -19.96891259, -21.77962654,
-24.37165652, 0.14408865, -1.68824341, -2.80529427, -3.84471906,
-5.27514707, -6.30987093, -6.75814771, -6.67078231, -7.90742503,
-9.48244344, -9.80080117, -10.70348941, -11.94969029, -12.95847838,
-13.52794048, -14.23377404, -15.1851375, -15.8924598, -16.23689422,
-17.15303179, -18.17974307, -19.3172696, -20.83059788, -22.53758651,
-25.1817373, 0.79939887, 0.03205666, -0.89955233, -1.4857033,
-0.82383039, 0.5324532, 0.08803781, -2.32772158, -3.26635598,
-4.51747286, -6.03001976, -8.83424437, -10.45716586, -12.24748808,
-13.51362312, -14.47395149, -15.43533936, -15.82692606, -16.48073364,
-17.34560575, -18.4974839, -20.28612607, -21.45173389, -23.0525819,
-25.86459932, -0.97451814, -3.31523561, -3.44181996, -4.06057325,
-5.50043111, -5.90874636, -7.37484097, -8.0686921, -9.19980094,
-9.97292626, -11.3341333, -11.13943081, -11.51670322, -12.8736633,
-13.55604421, -14.91348471, -15.87673684, -16.80606996, -17.25885348,
-17.9129516, -19.27876378, -20.33252371, -21.67046167, -23.45241774,
-26.34713744, -0.45185348, -1.34552529, -4.10601015, -4.06956204,
-4.37163956, -4.96136749, -6.09612958, -6.79175933, -7.92402706,
-8.25906871, -9.38202152, -10.4807904, -11.51038877, -12.33853757,
-13.30312119, -14.60679957, -15.90242413, -17.06116511, -18.47835054,
-19.48334693, -20.3503361, -21.68959354, -22.91384536, -24.54026411,
-27.29732409, -3.09939971, -3.32474971, -3.46755751, -3.41597684,
-5.52680707, -6.65007406, -6.9115191, -8.55718448, -9.46056864,
-10.0463213, -11.40239801, -12.74841191, -13.83627077, -13.7513071,
-14.62859882, -15.42622988, -16.4459132, -17.15730455, -18.08342986,
-19.34110938, -20.84497913, -22.05578685, -23.14341564, -25.17992235,
-27.92675759, 0.9228326, -1.52070251, -4.79973408, -6.35231225,
-7.66478177, -7.45406139, -7.96374777, -7.52809014, -9.48652501,
-10.49223067, -10.93823367, -13.34914328, -14.40618037, -15.55996409,
-16.73233927, -17.54459512, -18.37462368, -19.11400543, -19.85087871,
-20.80840349, -21.58905123, -22.53427553, -23.6610257, -25.55743038,
-28.6593938, -0.67127137, -2.35176782, -2.56288229, -5.0251296,
-6.11785288, -7.97165633, -8.82467279, -8.56206391, -9.42732063,
-11.28328634, -12.13419009, -11.99889194, -12.58860695, -14.51453528,
-16.01651486, -17.04491345, -18.106229, -19.28255657, -20.38447451,
-21.2043418, -22.28587689, -23.41422487, -24.64959031, -26.10948832,
-28.82959083, 1.39267822, 2.73909431, -0.30852069, -0.49191557,
-1.06900899, -4.80174038, -7.74429261, -8.57210051, -10.15214971,
-11.15102586, -13.64298575, -14.48247672, -15.35212309, -16.11005408,
-16.94107167, -17.64203321, -17.96105135, -18.79888981, -19.76444493,
-21.25567826, -22.65736046, -23.78512985, -24.86149506, -26.88880413,
-30.13194652, -3.4018918, -4.52188036, -5.97907586, -5.9471244,
-6.29309233, -6.71089295, -8.38691622, -10.43531078, -11.30985554,
-12.80509172, -12.96840994, -14.91752468, -15.7804277, -16.2310254,
-16.57411667, -17.80722296, -18.56432089, -20.09211544, -21.15486984,
-22.02891632, -23.25526587, -24.65449898, -25.87767407, -27.53979094,
-30.01082046, -2.18411218, -3.42768338, -2.88898683, -5.03434617,
-7.14143228, -6.44365876, -7.33644084, -7.81222962, -8.62497252,
-9.09990075, -10.5800447, -14.26595287, -15.34887785, -16.54588899,
-17.21897182, -17.95794773, -19.51533257, -21.06924324, -22.11906531,
-23.30316044, -24.1346444, -25.2320325, -26.80940751, -28.70564311,
-32.02058598, 4.96237545, -0.88879878, -2.35069382, -4.46357858,
-5.13472407, -6.3847125, -7.85452304, -10.21404555, -11.36819028,
-12.54093227, -13.80958526, -15.33641873, -16.15654992, -17.31366457,
-18.27791676, -18.79767265, -19.18523508, -19.99538342, -21.37968612,
-22.18429164, -23.38539326, -25.29878169, -26.80995112, -28.92403945,
-31.7785054, 1.33123401, -1.02249003, -2.6059089, -5.03386748,
-4.84022598, -5.71008884, -4.23324978, -5.43305024, -9.38670501,
-12.35863658, -14.76322339, -15.92483383, -16.79956316, -18.35682673,
-19.29588663, -20.45545504, -21.45765423, -22.56577441, -23.31772778,
-24.27986692, -25.38170576, -26.59632792, -28.01733427, -29.564567,
-32.7086858, 5.15430037, 3.20382719, 2.265794, 1.70478095, -0.81045339,
-1.0908993, -7.75566411, -8.63732929, -7.28411605, -9.1182173,
-10.74836959, -12.43301415, -12.68311992, -14.60913215, -15.59191441,
-14.73154944, -16.53048259, -19.4591197, -20.612641, -22.83687863,
-23.63057252, -24.48836498, -26.50792922, -30.20153782, -33.61395119,
-3.35130854, -3.36891886, -4.26561375, -6.54543163, -8.81898894,
-10.19461991, -10.90426574, -11.95264669, -12.34848756, -13.59064154,
-14.57419256, -14.96507795, -14.17737602, -17.57479064, -18.43607852,
-20.28106993, -21.12463625, -21.6498765, -23.45913736, -25.28117062,
-26.44477551, -27.54322022, -29.23967429, -31.24787883, -34.24072356,
0.99671156, 0.96757645, 0.95825013, 0.95715782, 0.95237505, 0.96055795,
0.95810999, 0.96149538, 0.96684273, 0.96518399, 0.97354902, 0.97829106,
0.9820687, 0.99475319, 1.00023473, 1.00162529, 1.00384268, 1.01604712,
1.02570939, 1.03526033, 1.06643436, 1.06929468, 1.06808543, 1.1283969,
1.17220925, 0.99525784, 0.9938654, 0.98139359, 0.9942739, 0.96923268,
0.97339124, 0.97444133, 0.96678414, 0.97626434, 0.97636983, 0.97407744,
0.99897105, 1.01629918, 1.015268, 1.03004743, 1.05139461, 1.05280599,
1.05932633, 1.04936541, 1.0588459, 1.07200268, 1.08674781, 1.11342895,
1.15305027, 1.17629253, 0.98151496, 0.98324873, 0.98336371, 1.00450689,
0.99692978, 1.00417536, 1.01852003, 1.00719185, 1.03046019, 1.03885443,
1.04597379, 1.03549948, 1.03374376, 1.06767681, 1.09676432, 1.10216977,
1.0962988, 1.13491785, 1.12030935, 1.09122076, 1.09109337, 1.09037434,
1.10476754, 1.13355758, 1.21034051, 0.90528031, 0.91505724, 0.9364688,
0.93433918, 0.9411933, 0.95132377, 0.96334287, 0.96603109, 1.00890357,
1.02148881, 1.02616925, 1.03765517, 1.04392701, 1.071198, 1.10122554,
1.09891616, 1.10457466, 1.10727065, 1.10513873, 1.12012324, 1.12405358,
1.12268437, 1.14201041, 1.17607899, 1.21390643, 1.02457601, 1.01129094,
1.00172704, 0.9890919, 0.98620432, 0.9972466, 0.99253425, 1.0044353,
1.00046922, 1.01518764, 1.02275886, 1.02127435, 1.01887636, 1.02006744,
1.0305527, 1.0446574, 1.05369295, 1.06781143, 1.10989892, 1.15870693,
1.17183781, 1.17153767, 1.14601974, 1.15819167, 1.17642784, 1.03775792,
1.03320405, 1.03391895, 1.03864019, 1.02620388, 1.01747206, 1.02887917,
1.02880434, 1.06533575, 1.04598986, 1.04669836, 1.05733536, 1.04956126,
1.03025578, 1.04393869, 1.05837582, 1.07938759, 1.08339951, 1.11380916,
1.13359417, 1.14810477, 1.18479646, 1.1930588, 1.22140239, 1.25536339,
0.95219603, 0.98400121, 0.97640322, 0.97126847, 0.97651275, 0.99363695,
0.99545856, 1.00681619, 1.03037828, 1.02237747, 1.01736263, 1.03701081,
1.04527054, 1.07043687, 1.08475765, 1.07699402, 1.07739268, 1.10217153,
1.10489462, 1.14759912, 1.15489501, 1.14993703, 1.2117616, 1.21291275,
1.16895303, 1.00259864, 0.98811229, 1.02737978, 1.03875734, 1.03945526,
1.0784185, 1.10005486, 1.09777938, 1.08874332, 1.08718514, 1.08365161,
1.06078274, 1.06322641, 1.06373417, 1.07465019, 1.09341658, 1.08551877,
1.07646817, 1.07605364, 1.07280436, 1.0801085, 1.09621271, 1.12575792,
1.15036691, 1.17118238, 0.93113614, 0.93903334, 0.93065103, 0.92934556,
0.94488795, 0.97862192, 0.99988795, 0.99845236, 0.99862288, 0.99017086,
0.9946165, 1.01955132, 1.01232498, 1.03871207, 1.03085863, 1.03917618,
1.05170079, 1.10431373, 1.06499129, 1.07700965, 1.0808924, 1.09541073,
1.1095527, 1.11196659, 1.13939491, 1.01972827, 0.9982764, 0.9999548,
0.98955787, 0.99858018, 1.01743721, 1.02589592, 1.04951504, 1.06492822,
1.05272485, 1.05200434, 1.03350523, 1.01177319, 1.03214392, 1.01761463,
1.01623184, 1.06276209, 1.060171, 1.06428574, 1.07640874, 1.07583608,
1.09754669, 1.10727034, 1.13929623, 1.1430948, 0.98957614, 0.96835936,
0.95855704, 0.97100936, 0.968586, 0.99972676, 1.00826291, 1.0112365,
1.00174976, 1.01270387, 1.02263415, 1.06043526, 1.0533287, 1.0334176,
1.04034926, 1.01589606, 1.01908267, 1.03551668, 1.06079144, 1.01892107,
0.9994589, 1.01879789, 1.06131659, 1.06036243, 1.11053955, 0.993185,
0.95738412, 0.98877323, 0.99752949, 1.00261042, 1.00830993, 0.99496327,
0.99569457, 1.0326676, 1.03969503, 1.08139639, 1.06960628, 1.05319163,
1.04781506, 1.03917077, 1.03283667, 1.0342274, 1.023434, 1.02377082,
1.01203272, 1.03507954, 1.04416615, 1.09166954, 1.0585826, 1.06208248,
0.96782155, 0.94350733, 0.96963899, 0.9754331, 1.00870226, 0.98402078,
0.99298565, 1.00465319, 1.01579244, 1.02854159, 1.03493729, 1.01128328,
1.04440256, 1.01770567, 1.05548531, 1.06849333, 1.06249592, 1.0699571,
1.08030302, 1.10123141, 1.09017381, 1.07135898, 1.07145152, 1.07848089,
1.09269398, 0.98368009, 1.01109688, 1.00005397, 0.99792404, 1.03020888,
1.03961272, 1.01938528, 1.01959643, 1.03128162, 1.04463912, 1.04163329,
1.02954537, 1.05276183, 1.06353614, 1.07798238, 1.06357005, 1.05648117,
1.04729101, 1.07352566, 1.08488023, 1.11384048, 1.10944281, 1.11004154,
1.15898291, 1.15307761, 0.9675877, 0.98646992, 1.01868047, 1.04215207,
1.05467658, 1.09638126, 1.08329937, 1.081832, 1.08601992, 1.08458304,
1.06292778, 1.06520085, 1.04157247, 1.06366213, 1.03613103, 1.04059581,
1.04916238, 1.05477016, 1.08401132, 1.10730545, 1.09893801, 1.09102591,
1.07604096, 1.06057172, 1.03827923, 1.00135334, 0.98376663, 0.97066665,
0.97587169, 0.96434741, 0.97076823, 0.96454779, 0.99366441, 1.01098551,
1.01795115, 1.04350812, 1.05369725, 1.04041905, 1.04728599, 1.03465732,
1.06781106, 1.08294771, 1.08679108, 1.12271764, 1.10369615, 1.12282902,
1.14842385, 1.19537226, 1.17989802, 1.14691263, 0.96213021, 1.02910449,
1.00688152, 1.0464476, 1.01743683, 1.00624209, 1.03555902, 1.01746947,
1.04014327, 1.02756756, 1.0444662, 1.04282184, 1.05195602, 1.00952605,
1.0360307, 1.0298249, 1.04509046, 1.04570811, 1.07909554, 1.0980248,
1.10697097, 1.11400431, 1.14524902, 1.14911289, 1.1544346, 0.98622919,
1.02219984, 1.00123632, 1.00211368, 1.03422849, 1.02910203, 1.02211869,
1.01642223, 1.03819744, 1.01047248, 1.05135326, 1.03651021, 1.03574401,
1.05605009, 1.03830396, 1.06235959, 1.06441205, 1.05028481, 1.06503994,
1.0618399, 1.07685809, 1.10629121, 1.1442555, 1.15140506, 1.17029897,
0.95832919, 0.933535, 0.93210709, 0.94709624, 0.93567098, 0.91165966,
0.91773957, 0.91252457, 0.9218757, 0.92170289, 0.90225855, 0.88036159,
0.88884871, 0.92151941, 0.90818127, 0.89770414, 0.90139634, 0.90008482,
0.91853667, 0.92199325, 0.92194461, 0.94080557, 0.96868608, 1.0159258,
1.04257134, 0.97989282, 1.00526196, 0.97254899, 0.9992625, 1.00898788,
0.99712304, 1.01308178, 0.99844861, 1.00599883, 0.98818312, 0.99043401,
0.99739582, 0.9968266, 1.00334801, 0.99669217, 0.99308869, 0.97738919,
0.97206863, 0.98125679, 0.95151093, 0.99125929, 0.96736269, 0.98651967,
1.00653595, 1.02028684, 0.94842852, 0.96036523, 1.03641684, 1.02109845,
1.01005923, 0.99259316, 1.01412676, 1.03833275, 1.04479951, 1.07123783,
1.07312362, 1.07450508, 1.0701454, 1.05749547, 1.04481273, 1.03815847,
1.03827458, 1.03475703, 1.04014114, 1.04739527, 1.05478624, 1.06251211,
1.05837778, 1.05806746, 1.02487475, 0.96688912, 0.93597836, 0.9601954,
1.0102506, 1.07707279, 1.04456257, 1.06079869, 1.06472509, 1.12659794,
1.12532202, 1.11340021, 1.06099678, 1.0947578, 1.05136043, 1.04140032,
1.0705856, 1.07310397, 1.0706844, 1.08979475, 1.10274996, 1.10858659,
1.10743573, 1.10225224, 1.09611546, 1.13102626, 1.07372683, 1.02744152,
1.05225294, 1.00304141, 0.99181473, 0.9966397, 1.02262192, 1.03086116,
1.11650316, 1.09244046, 1.10004847, 1.10349604, 1.14793429, 1.12552664,
1.11384156, 1.13660786, 1.07982337, 1.09274429, 1.15828445, 1.15348295,
1.1621882, 1.14845028, 1.12716807, 1.0931102, 1.08834724, 1.05535733,
1.08055869, 1.15420882, 1.05432766, 1.02970587, 1.01490791, 1.01432448,
1.01889057, 1.00144128, 0.9884367, 1.00254099, 0.9849643, 0.97871428,
0.97385725, 0.97153821, 0.96309439, 0.96883525, 0.97639956, 0.96160022,
0.94646595, 0.98793255, 0.96687106, 1.00976894, 1.07633872, 1.09637139,
0.93794913, 0.93395086, 0.96199485, 0.94112157, 0.97222478, 0.99615092,
0.98202759, 1.0164916, 1.02132776, 1.02538744, 1.06566549, 1.04595452,
1.02650382, 1.03758, 1.03321785, 1.0502919, 1.0846636, 1.04603251,
0.99794254, 0.99847821, 1.03848496, 1.08470064, 1.0641286, 1.08638148,
1.06165219, 1.02982801, 1.04961528, 1.06454206, 1.04012063, 0.98378317,
1.00124407, 1.01380307, 1.02020813, 0.95922771, 1.01904485, 1.00004575,
0.98170567, 1.01813519, 1.01828881, 0.99253144, 1.00632148, 1.0372487,
1.02542669, 1.09007722, 1.10591548, 1.07588936, 1.09174638, 1.09508217,
1.06854561, 1.05183879, 1.01068622, 0.98929663, 0.98710321, 0.98918892,
0.97141833, 0.97040265, 0.99510374, 1.03907408, 1.02529341, 0.98724672,
1.01516838, 1.01679016, 0.99541567, 0.98964061, 1.00202774, 1.01739432,
1.00810225, 1.00825698, 1.05540668, 1.07131004, 1.07062455, 1.06937314,
1.05641563, 1.05115003, 1.04145774, 1.05529572, 1.05739119, 1.06602683,
1.09069306, 1.14737169, 1.21407944, 1.2335615, 1.20863128, 1.21820913,
1.21063524, 1.18925759, 1.12225802, 1.09052552, 1.05516616, 1.02900233,
1.02306775, 1.01004287, 1.04043642, 1.05566763, 1.07072731, 1.07548152,
1.01471198, 1.04802042, 1.04579565, 1.00620908, 1.00251973, 0.96215578,
0.99687847, 1.00256689, 0.99230352, 1.01123305, 0.99460204, 1.00890208,
0.99060666, 1.00048743, 0.98179803, 1.03315987, 1.05219197, 1.04309359,
1.053441, 1.0193217, 1.01992618, 0.99185982, 1.0367618, 1.04274235,
1.01724776, 1.06093825, 1.04904433, 1.02967967, 1.05793273, 1.01930905,
1.03045829, 0.97016447, 0.99953822, 1.02498848, 1.04738273, 1.04529594,
1.0536344, 1.05651914, 1.07606786, 1.07325257, 1.06712586, 1.07061948,
1.08004765, 1.08076894, 1.06716915, 1.04707974, 1.02912412, 1.00851672,
1.01907055, 1.02885912, 1.00697161, 1.0390513, 1.04178393, 1.03127677,
0.94450854, 0.98336716, 1.01384784, 1.04100008, 1.0094129, 1.0147673,
1.0386017, 1.01869204, 1.03020995, 1.04674799, 1.03515373, 1.02136329,
1.01042408, 1.06808974, 1.06540949, 1.07090333, 1.06245678, 1.06704407,
1.07219353, 1.05514805, 1.01634816, 1.02356982, 1.07932881, 1.06481382,
1.03279542, 1.03819509, 1.01562128, 0.95981872, 0.94668742, 0.93519189,
0.98490061, 1.00178787, 1.0541654, 1.02695236, 1.03229473, 1.04524242,
0.98612341, 0.97546849, 0.9546071, 0.92318283, 0.91990624, 0.90977204,
0.90749857, 0.9168134, 0.9042071, 0.90653965, 0.94378133, 1.0293784,
0.99195482, 1.04026978, 0.99575825, 0.99428102, 1.02614781, 0.99281512,
0.99467136, 0.96826751, 0.98460369, 1.03538692, 1.04021534, 1.01030721,
1.01871061, 1.06627775, 1.07757568, 1.0441522, 1.0133829, 1.00778531,
0.99955707, 0.98157477, 0.96440457, 0.97925864, 0.97032645, 0.96065258,
0.95483837, 0.94969826, 0.97151376, 1.06370058, 1.12756675, 1.09131542,
1.11653083, 1.13066921, 1.06728655, 1.01914747, 1.02604818, 1.01737407,
1.01099325, 0.95574297, 0.95189612, 0.94566483, 0.95928391, 0.96591946,
0.97511416, 1.01770827, 1.04307385, 1.04704203, 0.99817277, 0.9816989,
0.99354694, 1.05134906, 1.0670398, 1.03332063, 0.92713346, 0.93703071,
0.93890567, 0.97727174, 1.00636112, 1.03283419, 1.02082077, 0.9808383,
0.9945486, 0.97458461, 1.01144058, 0.97258099, 0.97385944, 1.00675003,
1.02867372, 1.00387999, 1.01357688, 0.97796504, 0.977507, 0.9827151,
0.99321682, 0.94535835, 0.97442736, 0.95282744, 0.91685692, 0.97764025,
0.98643182, 1.033447, 1.01504602, 0.98884827, 1.05228443, 1.06273693,
1.09281793, 1.11031113, 1.13092416, 1.12097086, 1.02527598, 1.02626485,
1.02936518, 1.04844837, 1.06766552, 1.03629324, 1.00404695, 0.99724967,
0.99065045, 1.01810829, 1.04075799, 1.0198155, 1.04320299, 1.04570116,
1.13500821, 1.04122648, 1.03883689, 1.02482957, 1.05482149, 1.05946609,
1.05512345, 1.01870031, 1.01898786, 1.01635998, 1.00364988, 0.99259816,
0.98898087, 0.97321427, 0.96357086, 1.00241461, 1.04936796, 1.06233004,
1.0307873, 1.06323292, 1.05755696, 1.02954167, 1.05544122, 1.02417637,
0.95805763, 1.04574971, 1.03081935, 1.02960286, 1.00662318, 1.05826122,
1.07393922, 1.14228276, 1.1417163, 1.07417889, 1.01975609, 0.97448773,
0.97857736, 0.98478833, 0.96142387, 0.95928468, 0.93437183, 0.9244452,
0.88706333, 0.9266293, 0.91481091, 0.93972718, 0.92517634, 0.96703695,
0.9161296, 0.9385061, 1.11132411, 1.11505569, 1.12976198, 1.15960051,
1.1456843, 1.17497088, 1.05526701, 1.06811547, 1.13474373, 1.1230698,
1.11574095, 1.09709216, 1.12345786, 1.10825333, 1.10990426, 1.18937861,
1.16832551, 1.10764914, 1.11904904, 1.07512997, 1.11501763, 1.17656691,
1.18124701, 1.09323998, 1.0020602, 0.9405836, 0.97357345, 0.9846081,
0.95855119, 0.92581528, 0.921272, 0.93679164, 0.93808197, 0.96444992,
0.96161791, 0.96936248, 1.01149428, 1.07379663, 0.99973403, 1.01689985,
0.98492061, 1.00251086, 1.05087814, 1.00568101, 0.96363276, 0.98893741,
1.00339074, 0.97820963, 0.98529795, 0.97134889, 1.2573241, 1.43651315,
1.56531261, 1.68851898, 1.77889686, 1.89761322, 1.98370422, 2.07086519,
2.17244338, 2.23509053, 2.33722161, 2.42776524, 2.50833918, 2.6209551,
2.70286643, 2.77835798, 2.84325795, 2.96752918, 3.08442682, 3.19770394,
3.44739573, 3.54993605, 3.61667211, 4.07202473, 4.4726701, 2.44239332,
2.78837829, 2.93724618, 3.18187129, 3.19484388, 3.32763253, 3.44170617,
3.48652761, 3.61709836, 3.6779502, 3.71945379, 3.95114475, 4.14932643,
4.17103882, 4.3223804, 4.53836755, 4.61175851, 4.69340428, 4.68380985,
4.8073354, 4.97772701, 5.14231666, 5.40268693, 5.88573096, 6.11067794,
3.43036267, 3.83943122, 4.07662685, 4.44796533, 4.49665381, 4.69772537,
4.95584784, 4.90812703, 5.20741484, 5.3693925, 5.52416853, 5.4888527,
5.50958245, 5.89426861, 6.23634969, 6.34122715, 6.29077373, 6.75208304,
6.59886028, 6.32294425, 6.35576003, 6.37212114, 6.5282289, 6.84167661,
7.79013953, 3.93318971, 4.41094611, 4.85980413, 5.01958587, 5.22477986,
5.46557096, 5.6723934, 5.73132847, 6.29613628, 6.51227891, 6.63448592,
6.82686641, 6.95318158, 7.36997641, 7.82328663, 7.83079173, 7.89044965,
7.95561422, 7.90116455, 8.08624226, 8.08884313, 8.00223819, 8.18314656,
8.60611855, 8.90496643, 5.80252297, 6.12710758, 6.30619245, 6.35729244,
6.4591257, 6.71491425, 6.740473, 6.95402735, 6.98677984, 7.27464455,
7.47265174, 7.46129265, 7.46907351, 7.52690766, 7.67224919, 7.90265755,
8.05397638, 8.27206632, 8.90945304, 9.72776829, 9.91294592, 9.84654688,
9.30420469, 9.30236461, 9.41930982, 7.09045346, 7.62520471, 7.96566986,
8.22807265, 8.19864669, 8.192869, 8.53383279, 8.59456107, 9.2685801,
8.91322396, 8.92953537, 9.17320934, 9.00301305, 8.63825734, 8.87565157,
9.13002628, 9.47650111, 9.51466537, 10.08288929, 10.47680321,
10.64305003, 11.1806159, 11.24873153, 11.55114952, 11.84388128,
7.1028369, 8.16310859, 8.31297248, 8.39458871, 8.6116192, 8.97007085,
9.05632019, 9.31295267, 9.83449349, 9.74010484, 9.65255439, 10.0582618,
10.13194554, 10.59763704, 10.91888223, 10.68834341, 10.59992445,
11.01503763, 10.94912199, 11.72034341, 11.78096338, 11.48022849,
12.57656495, 12.41746897, 11.0568314, 9.00416324, 9.29588314,
10.38413127, 10.86726887, 10.98596388, 11.87560902, 12.3098159,
12.24252384, 12.00013658, 11.97891812, 11.88283066, 11.38799144,
11.38822596, 11.32180872, 11.50213594, 11.80959613, 11.57319597,
11.25922919, 11.18469963, 11.07807286, 11.14611701, 11.40693419,
11.92603449, 12.32590546, 12.18766263, 8.5883869, 9.24954183,
9.29685978, 9.33656379, 9.70552238, 10.57272004, 11.11202863,
11.11899557, 11.12620845, 10.91577546, 10.95270011, 11.46852117,
11.27876602, 11.86056231, 11.63335876, 11.78048327, 11.99793995,
13.09302596, 12.01561699, 12.12034223, 12.02669094, 12.30726854,
12.39994474, 12.21815495, 12.28861527, 11.23288885, 11.39255875,
11.66130981, 11.58597271, 11.87831304, 12.36966797, 12.51217351,
13.04128558, 13.38535841, 13.0950741, 13.0322117, 12.57591029,
12.03313903, 12.43310006, 12.01632623, 11.88077482, 12.97932137,
12.81597962, 12.80920657, 12.97479282, 12.81308974, 13.20385908,
13.19094338, 13.69566019, 13.27442097, 11.83783861, 11.90975793,
11.79102043, 12.15587054, 12.2538371, 13.05242107, 13.33554168,
13.40020219, 13.1144629, 13.37818178, 13.67803712, 14.67639243,
14.43892816, 13.74971322, 13.84817867, 13.11638006, 13.1067846,
13.48939975, 14.12219368, 12.80828328, 12.06993783, 12.34966736,
13.1328694, 12.77710316, 13.39248273, 13.02526679, 12.6143028,
13.70117093, 13.97922155, 14.15156668, 14.27368705, 13.84539441,
13.77323571, 14.75121929, 14.92183058, 16.20106765, 15.83163865,
15.14323043, 14.88197405, 14.50509125, 14.18372982, 14.07860787,
13.63889444, 13.53052355, 13.11206506, 13.44530299, 13.45292064,
14.47635207, 13.31219885, 12.83248868, 12.96494958, 12.91224967,
13.91086002, 14.20571032, 15.25854613, 14.52667154, 14.63233359,
14.90420398, 15.22639182, 15.56571593, 15.68524541, 14.90697688,
15.81532942, 14.89617531, 15.88779531, 16.18754384, 15.76113514,
15.86478742, 15.98357275, 16.3712948, 15.84531873, 15.05116768,
14.77495506, 14.4865294, 14.09406033, 14.62946881, 16.00894877,
15.88694739, 15.9368477, 16.90193781, 17.24362728, 16.59438834,
16.46717786, 16.72458913, 17.05600286, 16.95591334, 16.46927443,
17.16009456, 17.3761859, 17.64938382, 17.05375164, 16.58128765,
16.11546709, 16.69846699, 16.94832682, 17.67968688, 17.23924469,
16.80463243, 17.87674562, 16.55755233, 15.25728555, 16.45491413,
17.87873686, 18.83215491, 19.31397857, 20.79452208, 20.1242591,
19.95277639, 19.81833633, 19.5873885, 18.63729564, 18.66118103,
17.61777071, 18.31681133, 17.20167832, 17.15999253, 17.25797283,
17.22576198, 18.02889558, 18.63943558, 18.01695357, 17.44317122,
16.55885361, 15.52893606, 14.10625561, 17.44844463, 17.48342087,
17.18307302, 17.39099592, 16.83961037, 17.00297254, 16.65995197,
17.63287496, 18.04404405, 18.19984089, 19.01734887, 19.19847986,
18.47770031, 18.4445317, 17.88295181, 19.0430438, 19.44003984,
19.32503948, 20.40520153, 19.39385495, 19.6306348, 20.12473257,
21.43391832, 20.06497381, 17.84014338, 16.67034331, 19.84900333,
19.19472094, 20.80901562, 19.63995018, 18.96154153, 19.97354223,
19.14389422, 19.86179186, 19.27339377, 19.73926209, 19.60762015,
19.8183546, 17.93825819, 18.62634828, 18.16414262, 18.43859768,
18.25837821, 19.20599318, 19.644922, 19.68717938, 19.57373518,
20.089278, 19.6215689, 18.79900119, 18.77173073, 20.85053838,
20.04023678, 20.13829144, 21.37945116, 21.06068346, 20.57597229,
20.2400462, 20.90280333, 19.60643024, 21.18669406, 20.37872334,
20.15817732, 20.75737492, 19.85238989, 20.52349087, 20.37023029,
19.53064308, 19.7225017, 19.27746128, 19.45448463, 20.15939105,
21.17276423, 20.6386709, 19.96762244, 18.48023306, 17.84287279,
17.94912876, 18.54127463, 18.06100574, 16.9966338, 17.17688227,
16.79805798, 17.0357087, 16.92467236, 16.08050151, 15.10697972,
15.27001414, 16.36094134, 15.66802961, 15.17074312, 15.16459209,
14.94170023, 15.46218201, 15.45235636, 15.24901053, 15.66519855,
16.27646089, 17.37790692, 17.17560191, 20.31537415, 21.8728502,
20.71574061, 21.81622923, 22.17948485, 21.55110669, 22.10566166,
21.32350727, 21.4437838, 20.55047206, 20.49316663, 20.64475672,
20.46923537, 20.41596695, 19.90054772, 19.50959355, 18.67196064,
18.31406331, 18.25001052, 16.87702723, 17.99806101, 16.73489655,
17.0176133, 17.31938288, 16.98233441, 19.69796548, 20.79858948,
24.52136264, 23.70330544, 22.99022226, 22.07384199, 22.93456068,
23.84581621, 24.00468583, 25.09882342, 24.91325266, 24.4965961,
23.99932504, 23.20433673, 22.31128884, 21.72831161, 21.47099142,
21.09789423, 20.94560832, 20.85908102, 20.7263403, 20.63366713,
19.95358696, 19.32667266, 17.11170102, 21.98022025, 21.11569491,
22.45634101, 24.78566589, 28.08627208, 26.32270605, 26.87255509,
26.57416348, 29.37877651, 28.93237653, 27.95718271, 24.99109955,
26.22161836, 23.77527362, 22.94742809, 23.90537726, 23.73157476,
23.38510717, 24.05711488, 24.14490565, 24.029918, 23.42573753,
22.54046335, 21.56661458, 21.5551957, 27.6196046, 25.92215252,
27.17649901, 24.50457048, 23.92842835, 23.87169872, 24.91962948,
25.20980936, 29.48574396, 27.91271614, 27.88603637, 27.67781945,
29.72018995, 28.20998253, 27.22012433, 28.01731654, 24.98332759,
25.19280476, 27.94298491, 27.34964066, 27.09040491, 25.86970847,
24.09159783, 21.90394123, 20.36172534, 28.30769774, 30.3539556,
34.90167248, 28.84155289, 27.21974833, 26.1134807, 25.77710031,
25.75182208, 24.53316419, 23.5834862, 24.1201497, 23.00476986,
22.39967565, 21.99126271, 21.57474142, 20.9046617, 20.89528342,
20.94992826, 19.95839186, 19.07445895, 20.53590146, 19.26301167,
20.40514584, 22.56413126, 21.91256097, 23.1874666, 23.36705501,
24.83937269, 23.85012631, 25.33396746, 26.4977394, 25.48747225,
27.08610064, 26.83965099, 26.75434581, 28.54918733, 27.20979632,
25.73918928, 25.93585014, 25.3703246, 25.85223952, 27.24720391,
25.04274427, 22.25921046, 21.88312221, 23.18507078, 24.85988352,
23.44248595, 23.5273219, 20.98144312, 28.61811868, 30.38532975,
31.22928765, 29.47389384, 26.04907108, 26.78760532, 27.46293864,
27.18313342, 23.59814373, 26.43272948, 25.25913836, 23.98255449,
25.70945692, 25.46270057, 23.80580119, 24.16639428, 25.56131431,
24.51652034, 27.47962222, 27.72250043, 25.62288587, 25.77408883,
25.13280835, 23.03450007, 20.98754102, 29.4132895, 28.64307647,
28.60200288, 28.5553145, 27.31581548, 26.90660641, 27.92165873,
30.11445362, 28.96859473, 26.51269125, 27.68474829, 27.33180829,
25.71194011, 24.9425481, 25.25357115, 25.58876661, 24.69139239,
24.39537925, 26.40052685, 26.61769943, 26.07177997, 25.45104495,
24.04909301, 22.91751863, 21.06003005, 32.44262828, 33.53896381,
34.12554601, 35.37929165, 38.84664089, 43.34230761, 44.36915131,
41.77712842, 41.88401734, 40.93437115, 39.19255188, 34.41082052,
32.03370191, 29.37133975, 27.5035569, 26.76722426, 25.71096559,
26.95265845, 27.40397458, 27.65472138, 27.22321787, 23.42269307,
24.32037996, 23.41133954, 20.07803846, 30.17147365, 28.27740352,
30.48576952, 31.01252468, 30.03585883, 31.00502132, 29.5914922,
30.02967848, 28.77440772, 28.8741381, 27.27530692, 29.98111389,
30.81037166, 29.57903806, 29.74943841, 27.46045464, 26.96048751,
25.28187726, 27.19758151, 27.27002912, 25.31003597, 26.73307797,
25.51049744, 23.64576459, 23.30933223, 32.24298561, 33.55893116,
29.93683335, 31.94397783, 33.39057344, 34.38432014, 33.86332566,
34.10720497, 33.70380373, 34.67231546, 33.98238317, 33.1674725,
32.75282944, 32.82218166, 32.34345098, 30.97875574, 29.29035507,
27.79346636, 25.96976442, 25.90274685, 25.98118906, 24.22686892,
25.12327539, 24.45407358, 22.45845735, 28.18134982, 31.00119845,
33.16681411, 35.20436783, 32.79414011, 32.62129883, 33.9688576,
32.1815323, 32.35862413, 32.97207244, 31.67172039, 30.27777146,
29.19032293, 32.22681722, 31.70409664, 31.64229513, 30.73299914,
30.67325888, 30.494215, 28.98065367, 26.22758107, 25.91832218,
28.10877448, 26.25824622, 23.2424173, 36.33563342, 35.00865489,
30.96474837, 29.87536642, 28.92933845, 31.79056039, 32.62128335,
35.81015699, 33.36834684, 33.13463429, 33.75914644, 29.37050071,
28.29855728, 26.6970793, 24.55288366, 24.01960086, 23.14149189,
22.6915029, 22.81736136, 21.71806053, 21.53250374, 22.87046348,
26.48362131, 23.58169052, 24.15683659, 34.35222758, 34.49659693,
36.7621526, 34.047806, 33.86945457, 31.69911484, 32.21002835,
35.22055765, 35.17987817, 32.5679444, 32.61863328, 35.3602398,
35.75917151, 32.86082315, 30.41571859, 29.60724743, 28.62030614,
27.0429925, 25.62314147, 25.99263787, 24.99138617, 23.93896797,
23.05197415, 22.11034185, 21.72303575, 39.90446451, 45.68828229,
42.67755711, 44.62849429, 45.58526881, 40.08783397, 35.86004532,
35.96295502, 34.64116979, 33.8928035, 29.48121395, 28.96091018,
28.25161906, 28.58397967, 28.48883403, 28.6779086, 30.82973139,
31.66576275, 31.40922243, 28.04338494, 26.36161115, 26.39511257,
28.91348082, 28.5724726, 24.94855681, 31.05989534, 32.0987241,
31.96003363, 34.53299133, 36.25124788, 37.75210182, 36.28591385,
33.13256438, 33.50225784, 31.65142746, 33.6994541, 30.50220157,
30.16328051, 31.77616051, 32.92383975, 31.00427739, 31.19720032,
28.3937874, 27.79854046, 27.67808123, 27.51721336, 24.25229057,
25.1864937, 23.2051115, 20.03361673, 35.24512733, 36.26056059,
40.03169209, 38.19765183, 35.87719583, 40.15835641, 40.47798496,
42.06777372, 42.75113028, 43.82742713, 42.48676913, 34.87158717,
34.32553895, 33.81086542, 34.54260171, 35.27984344, 32.67133541,
29.96124787, 29.08920579, 28.07370235, 29.19048928, 29.87748229,
27.88621124, 28.11622613, 26.3369738, 49.55454, 42.12503438,
41.96813093, 40.36943102, 41.97208403, 41.78295272, 40.87328962,
37.53836098, 37.0580762, 36.3181685, 35.00099651, 33.49444177,
32.97912, 31.54195411, 30.54263397, 32.4639633, 34.96423991,
35.30122987, 32.81051601, 34.2480093, 33.31852137, 30.54026938,
31.16023116, 28.22207761, 22.96722251, 43.56838471, 42.69352553,
42.46199624, 40.13577025, 43.60195097, 44.31867174, 49.78316782,
49.31508406, 42.83811659, 37.80317367, 33.73800017, 33.3105174,
33.22630913, 31.0087731, 30.40865036, 28.43881209, 27.36609083,
24.70344261, 26.52354799, 25.40327003, 26.17521882, 24.73857869,
26.30494308, 22.70128478, 22.09463252, 51.04502521, 51.51111157,
52.75284351, 54.81194369, 52.72699034, 54.75851856, 43.23767907,
43.70178295, 49.02252976, 47.24876375, 45.87483121, 43.85072076,
45.48505425, 43.38004215, 42.99786887, 48.64036596, 46.29534543,
40.66886396, 40.73416978, 36.69682239, 38.72599395, 42.01843505,
41.09368797, 33.38471226, 26.05468053, 36.52606302, 39.86827031,
40.82288701, 38.41130665, 35.46730729, 34.64407264, 35.37145682,
35.02176249, 36.58297963, 35.76037366, 35.72233032, 38.09322964,
42.6585412, 35.92893612, 36.47374756, 33.43948378, 34.04884608,
36.6796924, 32.92837796, 29.29840746, 30.12086854, 30.44677077,
28.0043309, 27.28218372, 24.79985495), .Dim = c(1000, 3), .Dimnames = list(
    c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
    "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
    "22", "23", "24", "25", "26", "27", "28", "29", "30", "31",
    "32", "33", "34", "35", "36", "37", "38", "39", "40", "41",
    "42", "43", "44", "45", "46", "47", "48", "49", "50", "51",
    "52", "53", "54", "55", "56", "57", "58", "59", "60", "61",
    "62", "63", "64", "65", "66", "67", "68", "69", "70", "71",
    "72", "73", "74", "75", "76", "77", "78", "79", "80", "81",
    "82", "83", "84", "85", "86", "87", "88", "89", "90", "91",
    "92", "93", "94", "95", "96", "97", "98", "99", "100", "101",
    "102", "103", "104", "105", "106", "107", "108", "109", "110",
    "111", "112", "113", "114", "115", "116", "117", "118", "119",
    "120", "121", "122", "123", "124", "125", "126", "127", "128",
    "129", "130", "131", "132", "133", "134", "135", "136", "137",
    "138", "139", "140", "141", "142", "143", "144", "145", "146",
    "147", "148", "149", "150", "151", "152", "153", "154", "155",
    "156", "157", "158", "159", "160", "161", "162", "163", "164",
    "165", "166", "167", "168", "169", "170", "171", "172", "173",
    "174", "175", "176", "177", "178", "179", "180", "181", "182",
    "183", "184", "185", "186", "187", "188", "189", "190", "191",
    "192", "193", "194", "195", "196", "197", "198", "199", "200",
    "201", "202", "203", "204", "205", "206", "207", "208", "209",
    "210", "211", "212", "213", "214", "215", "216", "217", "218",
    "219", "220", "221", "222", "223", "224", "225", "226", "227",
    "228", "229", "230", "231", "232", "233", "234", "235", "236",
    "237", "238", "239", "240", "241", "242", "243", "244", "245",
    "246", "247", "248", "249", "250", "251", "252", "253", "254",
    "255", "256", "257", "258", "259", "260", "261", "262", "263",
    "264", "265", "266", "267", "268", "269", "270", "271", "272",
    "273", "274", "275", "276", "277", "278", "279", "280", "281",
    "282", "283", "284", "285", "286", "287", "288", "289", "290",
    "291", "292", "293", "294", "295", "296", "297", "298", "299",
    "300", "301", "302", "303", "304", "305", "306", "307", "308",
    "309", "310", "311", "312", "313", "314", "315", "316", "317",
    "318", "319", "320", "321", "322", "323", "324", "325", "326",
    "327", "328", "329", "330", "331", "332", "333", "334", "335",
    "336", "337", "338", "339", "340", "341", "342", "343", "344",
    "345", "346", "347", "348", "349", "350", "351", "352", "353",
    "354", "355", "356", "357", "358", "359", "360", "361", "362",
    "363", "364", "365", "366", "367", "368", "369", "370", "371",
    "372", "373", "374", "375", "376", "377", "378", "379", "380",
    "381", "382", "383", "384", "385", "386", "387", "388", "389",
    "390", "391", "392", "393", "394", "395", "396", "397", "398",
    "399", "400", "401", "402", "403", "404", "405", "406", "407",
    "408", "409", "410", "411", "412", "413", "414", "415", "416",
    "417", "418", "419", "420", "421", "422", "423", "424", "425",
    "426", "427", "428", "429", "430", "431", "432", "433", "434",
    "435", "436", "437", "438", "439", "440", "441", "442", "443",
    "444", "445", "446", "447", "448", "449", "450", "451", "452",
    "453", "454", "455", "456", "457", "458", "459", "460", "461",
    "462", "463", "464", "465", "466", "467", "468", "469", "470",
    "471", "472", "473", "474", "475", "476", "477", "478", "479",
    "480", "481", "482", "483", "484", "485", "486", "487", "488",
    "489", "490", "491", "492", "493", "494", "495", "496", "497",
    "498", "499", "500", "501", "502", "503", "504", "505", "506",
    "507", "508", "509", "510", "511", "512", "513", "514", "515",
    "516", "517", "518", "519", "520", "521", "522", "523", "524",
    "525", "526", "527", "528", "529", "530", "531", "532", "533",
    "534", "535", "536", "537", "538", "539", "540", "541", "542",
    "543", "544", "545", "546", "547", "548", "549", "550", "551",
    "552", "553", "554", "555", "556", "557", "558", "559", "560",
    "561", "562", "563", "564", "565", "566", "567", "568", "569",
    "570", "571", "572", "573", "574", "575", "576", "577", "578",
    "579", "580", "581", "582", "583", "584", "585", "586", "587",
    "588", "589", "590", "591", "592", "593", "594", "595", "596",
    "597", "598", "599", "600", "601", "602", "603", "604", "605",
    "606", "607", "608", "609", "610", "611", "612", "613", "614",
    "615", "616", "617", "618", "619", "620", "621", "622", "623",
    "624", "625", "626", "627", "628", "629", "630", "631", "632",
    "633", "634", "635", "636", "637", "638", "639", "640", "641",
    "642", "643", "644", "645", "646", "647", "648", "649", "650",
    "651", "652", "653", "654", "655", "656", "657", "658", "659",
    "660", "661", "662", "663", "664", "665", "666", "667", "668",
    "669", "670", "671", "672", "673", "674", "675", "676", "677",
    "678", "679", "680", "681", "682", "683", "684", "685", "686",
    "687", "688", "689", "690", "691", "692", "693", "694", "695",
    "696", "697", "698", "699", "700", "701", "702", "703", "704",
    "705", "706", "707", "708", "709", "710", "711", "712", "713",
    "714", "715", "716", "717", "718", "719", "720", "721", "722",
    "723", "724", "725", "726", "727", "728", "729", "730", "731",
    "732", "733", "734", "735", "736", "737", "738", "739", "740",
    "741", "742", "743", "744", "745", "746", "747", "748", "749",
    "750", "751", "752", "753", "754", "755", "756", "757", "758",
    "759", "760", "761", "762", "763", "764", "765", "766", "767",
    "768", "769", "770", "771", "772", "773", "774", "775", "776",
    "777", "778", "779", "780", "781", "782", "783", "784", "785",
    "786", "787", "788", "789", "790", "791", "792", "793", "794",
    "795", "796", "797", "798", "799", "800", "801", "802", "803",
    "804", "805", "806", "807", "808", "809", "810", "811", "812",
    "813", "814", "815", "816", "817", "818", "819", "820", "821",
    "822", "823", "824", "825", "826", "827", "828", "829", "830",
    "831", "832", "833", "834", "835", "836", "837", "838", "839",
    "840", "841", "842", "843", "844", "845", "846", "847", "848",
    "849", "850", "851", "852", "853", "854", "855", "856", "857",
    "858", "859", "860", "861", "862", "863", "864", "865", "866",
    "867", "868", "869", "870", "871", "872", "873", "874", "875",
    "876", "877", "878", "879", "880", "881", "882", "883", "884",
    "885", "886", "887", "888", "889", "890", "891", "892", "893",
    "894", "895", "896", "897", "898", "899", "900", "901", "902",
    "903", "904", "905", "906", "907", "908", "909", "910", "911",
    "912", "913", "914", "915", "916", "917", "918", "919", "920",
    "921", "922", "923", "924", "925", "926", "927", "928", "929",
    "930", "931", "932", "933", "934", "935", "936", "937", "938",
    "939", "940", "941", "942", "943", "944", "945", "946", "947",
    "948", "949", "950", "951", "952", "953", "954", "955", "956",
    "957", "958", "959", "960", "961", "962", "963", "964", "965",
    "966", "967", "968", "969", "970", "971", "972", "973", "974",
    "975", "976", "977", "978", "979", "980", "981", "982", "983",
    "984", "985", "986", "987", "988", "989", "990", "991", "992",
    "993", "994", "995", "996", "997", "998", "999", "1000"),
    c("V1", "V2", "V3")))
"sc.beta.ave" <-
structure(c(-0.0183718, -0.05119386, -0.07867301, -0.10590321,
-0.13361664, -0.1619462, -0.19108078, -0.21789738, -0.24679207,
-0.2677464, -0.29296559, -0.32519388, -0.3474802, -0.35602069,
-0.37388507, -0.40098411, -0.42827889, -0.46752042, -0.51401517,
-0.56814452, -0.61051723, -0.66465293, -0.74248417, -0.85453578,
-1.01814056, -0.03220343, -0.06990945, -0.12149347, -0.18758275,
-0.25864848, -0.31513679, -0.36420744, -0.40800873, -0.44875061,
-0.48669972, -0.53034987, -0.57432345, -0.61827483, -0.68883555,
-0.73570307, -0.79277911, -0.86917412, -0.93674836, -1.03250868,
-1.12149975, -1.21405656, -1.3085648, -1.42295544, -1.58384946,
-1.77752732, 0.01425507, -0.10010962, -0.20116025, -0.29619658,
-0.37224016, -0.4604127, -0.52153148, -0.59086632, -0.66409757,
-0.74458539, -0.83954205, -0.9222055, -1.00707535, -1.11370982,
-1.19410468, -1.26937633, -1.33940353, -1.41375998, -1.50857556,
-1.61308851, -1.73664791, -1.87576057, -2.0269559, -2.20488362,
-2.40811389, -0.0244873, -0.17926044, -0.27098814, -0.38435455,
-0.48490798, -0.5342865, -0.67676535, -0.72029048, -0.83647439,
-0.94790229, -1.04263327, -1.19048104, -1.28963132, -1.4132897,
-1.52061945, -1.68043909, -1.81397008, -1.93508573, -2.07124895,
-2.20454097, -2.37101474, -2.55658806, -2.75850942, -3.00839705,
-3.2751894, 0.02083331, -0.19544528, -0.31748098, -0.4511127,
-0.5081979, -0.64844386, -0.78388983, -0.89226357, -1.03893542,
-1.15158066, -1.25546478, -1.43689312, -1.59395377, -1.71960563,
-1.84957747, -1.98261491, -2.10355589, -2.22678443, -2.41215483,
-2.60115971, -2.7989943, -3.04308641, -3.26893943, -3.54662968,
-3.9065505, 0.10268529, -0.10711788, -0.25670243, -0.42860607,
-0.58140487, -0.74364084, -0.85372368, -1.04744667, -1.17563497,
-1.32630035, -1.51263821, -1.69665826, -1.85887381, -2.02647435,
-2.21213866, -2.42608039, -2.64361156, -2.86782588, -3.04482252,
-3.29682525, -3.53200103, -3.77856039, -4.09198662, -4.46127051,
-4.84663661, 0.01520367, -0.04740807, -0.28082728, -0.56482793,
-0.85263569, -1.11083694, -1.3380974, -1.50025031, -1.74667595,
-1.91731568, -2.05209462, -2.30504188, -2.41126392, -2.55580188,
-2.69059635, -2.86843709, -3.0493186, -3.23598337, -3.47421705,
-3.75143997, -3.85508404, -4.17922063, -4.45003013, -4.83240742,
-5.29820248, -0.39922247, -0.6478104, -0.90512466, -1.03504484,
-1.22893065, -1.43398855, -1.67092025, -1.84133808, -1.99791297,
-2.29080531, -2.56486258, -2.74749831, -2.95497357, -3.15215473,
-3.28785164, -3.47063547, -3.64325327, -3.8397279, -4.03144405,
-4.21368254, -4.53723736, -4.9049994, -5.26566882, -5.68488627,
-6.24404744, -0.4182973, -0.52239398, -0.78385774, -1.05679171,
-1.13431053, -1.46408321, -1.69201722, -1.76532435, -1.93332456,
-2.09358946, -2.36819331, -2.56829552, -2.80435905, -3.09964865,
-3.31413719, -3.55649689, -3.960653, -4.3441627, -4.69797263,
-4.89563533, -5.2956936, -5.63815024, -6.17452812, -6.72358743,
-7.39459484, -0.42673415, -0.52615735, -0.75032237, -1.066826,
-1.33665656, -1.42595202, -1.54428847, -1.774195, -2.01883134,
-2.18101615, -2.42472835, -2.76081331, -3.19665524, -3.48472406,
-3.76395652, -4.05576188, -4.42481092, -4.65414019, -4.94599421,
-5.37202976, -5.70452096, -6.12774625, -6.65186326, -7.20850445,
-7.88212847, -0.19535902, -0.7528311, -1.21180473, -1.46670398,
-1.74697202, -1.80567466, -2.10745844, -2.36834954, -2.6609816,
-2.93005645, -3.21495136, -3.54778906, -3.71696283, -3.74577468,
-3.98532412, -4.24047003, -4.55902586, -4.73778196, -5.11177593,
-5.56410423, -6.11302269, -6.59009692, -7.24961896, -7.77410956,
-8.44670592, 0.6236395, 0.39480701, 0.39878595, -0.16405274,
-0.50859206, -0.72398492, -1.08816368, -1.44422212, -1.76256188,
-2.04664975, -2.6404779, -3.16295762, -3.44533971, -3.8376283,
-4.12353121, -4.55070001, -5.03290868, -5.48212779, -5.94349081,
-6.35805907, -6.85206179, -7.30312143, -7.93893685, -8.59728756,
-9.40614589, -0.15166327, -0.29682393, -0.80545944, -1.24763888,
-1.56297598, -1.77818824, -2.22754573, -2.69342304, -3.13901783,
-3.39546712, -3.76755467, -4.10323327, -4.47055214, -4.87294776,
-5.22898241, -5.6020018, -5.99475933, -6.37916131, -6.62554324,
-7.13000793, -7.67620371, -8.31523358, -8.93129759, -9.63108026,
-10.4300129, -0.74614558, -1.12407592, -1.38902163, -1.7504017,
-2.13171585, -2.46863371, -2.710088, -3.18337613, -3.32187073,
-3.43283866, -3.53440241, -3.9790876, -4.34672029, -4.8863526,
-5.16415211, -5.65657182, -6.35356208, -6.89858142, -7.50776978,
-8.17296699, -8.74044583, -9.25435034, -9.89460165, -10.53730211,
-11.32182992, 0.08890107, -0.4128364, -0.68874279, -1.29444725,
-1.7632799, -2.17324543, -2.65262755, -2.9750558, -3.51330031,
-4.1336033, -4.52137134, -4.86044605, -5.21290478, -5.55254238,
-5.88753393, -6.29500456, -6.80959288, -7.18783321, -7.7202516,
-8.3608717, -8.88610457, -9.48155658, -10.36260328, -11.11496456,
-12.0084381, 0.46528978, 0.43008154, 0.07697252, -0.37950973,
-0.88386002, -1.33058369, -1.61922129, -1.8763267, -1.97338603,
-2.58224544, -2.84090858, -2.9879655, -3.23984964, -3.48443482,
-3.9875709, -4.28747788, -4.88069483, -5.34249111, -5.56129322,
-6.26979326, -7.32166933, -8.08670318, -8.65873574, -9.24533172,
-10.48180252, -0.12141974, -0.74566631, -0.95561978, -0.92481394,
-1.069791, -1.35655478, -1.64450229, -1.74659172, -1.65103495,
-1.76124366, -2.34478192, -3.49371502, -4.39138552, -5.26345745,
-5.78066359, -6.35484599, -6.76551924, -7.43941487, -7.79743512,
-8.59279577, -9.41138447, -10.15777121, -10.95254487, -11.8346665,
-12.92417615, -0.77986818, -0.79441135, -1.25033389, -1.72843077,
-2.28883097, -2.61827901, -3.03443573, -3.51763928, -3.86608691,
-4.41867669, -4.98809197, -5.65300187, -5.91902494, -6.24971747,
-6.74656405, -7.34463122, -8.18555334, -8.82018605, -9.12768124,
-9.38763893, -9.69595478, -10.16801544, -10.93868504, -12.17460856,
-13.31060245, -0.65042637, -1.81831855, -1.94278557, -2.51609942,
-3.1042003, -3.30855946, -3.69894784, -4.37111787, -4.85425504,
-5.17745594, -5.37490214, -5.56015152, -5.68880549, -6.31502145,
-7.04069583, -7.73303975, -8.06915474, -8.29524268, -8.49637905,
-8.8296156, -9.5438698, -9.95161969, -10.52922214, -12.13707536,
-13.01807866, -1.06857636, -1.49425447, -1.74337241, -2.75170577,
-3.50661636, -4.24140268, -4.57604636, -5.05290626, -5.30081522,
-5.54329536, -5.89372773, -6.54613046, -6.94804549, -7.42345994,
-8.10465313, -8.78978243, -9.19013766, -9.68791843, -9.9250815,
-10.67030768, -11.29104874, -11.96445351, -12.65347799, -13.25760827,
-14.4057113, 1.97297433, 1.41010264, 0.53285927, -0.94100834,
-1.69833324, -2.21379151, -2.86729931, -3.05582038, -3.29250335,
-3.45171045, -3.62151371, -3.00884181, -3.27591267, -4.80766243,
-5.34675615, -6.85262439, -7.41788601, -8.10515148, -8.85187742,
-9.53699416, -10.99298932, -12.02206946, -13.20057232, -14.24487554,
-15.78264258, -0.10333867, -1.31357641, -1.0077342, -1.58969045,
-1.29658678, -3.11539916, -3.90131783, -4.57991099, -5.24461699,
-5.67469173, -6.15591889, -6.75687829, -6.93873446, -7.46998579,
-8.10278611, -8.71442081, -9.29148376, -9.74666398, -10.40132261,
-11.37321458, -12.56948904, -13.89110375, -15.0508199, -16.24074969,
-17.48616754, -0.4994459, -1.36356658, -1.2838781, -3.03197986,
-3.76841383, -4.48252295, -4.70292726, -5.17544096, -5.23784265,
-6.0556837, -6.56260456, -7.16329232, -7.85401092, -8.54807303,
-9.05993683, -9.81650218, -10.59330662, -11.48476294, -12.32889396,
-12.95451688, -13.82161556, -14.79947177, -16.08208345, -17.61237247,
-19.12881744, -0.07382888, -1.26322734, -2.60490334, -3.48119599,
-3.5549811, -4.3438556, -5.11563904, -5.2286169, -5.83883708,
-6.1484189, -6.75892171, -7.40239404, -8.04113095, -8.88996224,
-9.60277155, -10.23553244, -11.15516423, -11.74054967, -12.64249117,
-13.30058852, -14.3697002, -15.40563376, -16.73637622, -17.85760602,
-19.36728421, -1.4674334, -2.40598835, -2.85067148, -2.54300447,
-3.94854646, -4.75529934, -5.06488584, -5.88418659, -6.65851188,
-7.23621089, -7.32961013, -8.31094419, -9.03422294, -9.47887387,
-10.26028624, -10.98194471, -11.36270788, -11.79284026, -12.25407809,
-13.12218859, -14.23263315, -15.42844969, -16.13660857, -17.51565822,
-19.32818091, -0.95376699, -0.30618874, -0.84058713, -1.57072315,
-1.9840063, -2.82265301, -4.00594213, -5.64523993, -5.94946748,
-6.71397908, -7.66978944, -8.65959083, -9.25031883, -9.63632239,
-9.62934669, -10.14565063, -10.98947597, -11.76168667, -12.89351651,
-13.8447715, -14.65311637, -15.44071172, -16.72436804, -18.75440528,
-19.84703601, -0.67130408, -1.48083119, -2.73111905, -3.36786588,
-4.26921053, -5.25167535, -6.06883493, -6.84942139, -7.76203152,
-8.44975761, -9.00958089, -9.07739717, -9.6320418, -10.48258559,
-10.87560163, -11.50329385, -12.1965555, -13.02270052, -13.69121688,
-14.11842914, -15.39872829, -16.63914317, -17.91300325, -19.45151952,
-21.24088536, 0.94895902, -0.81896279, -1.96547406, -2.36915604,
-2.98265134, -4.08937683, -5.03563527, -6.42753782, -7.49470921,
-8.2485605, -8.80918764, -9.56835317, -10.17180392, -11.14971916,
-11.93252903, -12.5201415, -13.11118312, -13.59308795, -14.75898528,
-15.52041701, -16.21681776, -16.76807582, -17.67625126, -19.79101551,
-21.9819197, -1.16142041, -1.02789522, -1.54522437, -2.19211308,
-2.30872497, -2.74306832, -3.44117926, -4.38688823, -6.58865502,
-8.12692041, -7.95450591, -8.04634485, -8.89555276, -9.81217532,
-10.51799215, -10.94709191, -11.03319096, -11.92600974, -13.1365749,
-14.04292857, -15.4671115, -16.787458, -18.27749503, -20.11200214,
-21.84222901, -0.4381964, -1.4702912, -2.27305857, -1.91772233,
-2.48464154, -2.80480672, -2.92862552, -2.41108337, -5.36686921,
-6.77588983, -7.97922171, -9.24465185, -10.23841361, -10.92081412,
-11.86741145, -12.73282629, -13.58354654, -14.53323186, -16.17641148,
-17.26816956, -17.58890868, -17.44617398, -19.98137929, -21.98791179,
-24.32078928, -1.67460717, -3.40760675, -4.13212423, -3.99589796,
-4.08097235, -4.42412521, -4.34823458, -4.20761822, -5.27080372,
-6.47964857, -7.80623863, -9.01086151, -9.65875, -10.68283422,
-11.76661588, -12.79602647, -13.76017013, -15.02526774, -15.41345181,
-16.74895734, -18.01717057, -19.32515349, -20.07862869, -22.24272363,
-24.64165723, -0.37989117, -1.95767177, -2.99420262, -4.13462541,
-4.82814179, -5.434665, -6.40989249, -6.95704655, -7.33083093,
-8.06084596, -8.94026927, -9.61306306, -9.61486195, -10.65798045,
-11.75349631, -13.00028046, -14.71322632, -16.11952232, -16.96184693,
-17.70644415, -19.02561913, -20.63279929, -22.0831338, -23.95861148,
-26.24712531, 0.578041, 0.05122115, -1.05825025, -1.81088585,
-3.30385885, -3.81223056, -4.30958028, -5.36837609, -6.25788263,
-7.12183877, -7.62064397, -8.58498372, -9.19507383, -10.95974053,
-11.30956997, -11.42447736, -11.95554829, -12.76888286, -13.10861832,
-14.66299742, -15.80153057, -17.58628066, -19.0648219, -21.24659237,
-23.68246701, 0.56182534, 2.30224634, 2.33329203, 0.93244712,
-2.81777123, -3.58613158, -5.60296411, -8.36302809, -8.86450406,
-9.00664855, -9.91638753, -11.16388994, -12.6059491, -13.85299615,
-14.62956158, -15.79520984, -16.94177944, -18.05325433, -19.11190056,
-20.48496845, -21.6850343, -23.05552418, -24.50892293, -26.20583521,
-28.29264587, 0.68221505, 0.17009469, -0.76158587, -3.26923227,
-2.67673906, -2.96167774, -3.62747681, -4.38307298, -4.86699878,
-4.78346397, -6.01519748, -7.72742427, -8.59952063, -10.29195157,
-10.69106889, -11.42980044, -14.39240474, -16.38267413, -18.14680347,
-19.29558298, -20.03489594, -21.13863286, -22.84612627, -24.51505512,
-26.94321346, -1.35472954, -3.06845258, -3.90084719, -4.34947221,
-4.19485297, -3.90397309, -4.25013662, -5.81908457, -8.25914549,
-9.26659831, -10.79545059, -12.04781726, -12.90038928, -14.04357897,
-15.09323979, -16.04969718, -17.4962444, -18.77514898, -20.42999621,
-21.86181448, -23.06208923, -24.48195761, -26.41630888, -28.49189181,
-30.64957123, -1.38051785, -0.46390982, -0.74683015, -0.36103151,
-0.45284135, -2.5026194, -3.38183348, -1.33227742, -1.97489927,
-4.2793963, -6.35268879, -8.15593274, -8.94711754, -10.13698874,
-11.52600095, -12.84707931, -14.28937769, -15.45108658, -17.14392342,
-18.27605937, -19.86169978, -21.56639473, -23.62525752, -25.10154041,
-27.45719434, -0.53233662, -1.65368201, -1.2859126, -3.44674105,
-4.99468762, -5.89903524, -7.27249154, -8.76646332, -10.04683572,
-11.22067037, -12.30200683, -12.9691713, -14.31444806, -15.69330647,
-16.85519953, -17.85756779, -19.24751909, -20.19338281, -21.34117371,
-22.7084572, -24.47467145, -26.10379055, -27.55180902, -29.32636872,
-31.72752332, -0.75173212, -2.51340314, -2.80419749, -2.78868035,
-3.43270126, -4.56022319, -5.25424207, -6.18981545, -6.94108034,
-7.9754227, -8.54858876, -9.71446422, -11.22633071, -12.69119529,
-13.54298483, -13.69399282, -14.6532246, -15.59381531, -16.84622271,
-17.84147948, -18.62106614, -20.94262558, -23.03711649, -25.17612643,
-28.30006912, 0.37993021, 1.38675186, 0.09757811, -1.11490757,
-1.75174293, -1.31404368, -2.30919855, -3.76045742, -6.20254253,
-7.12014555, -8.54601009, -10.07357853, -12.15274573, -13.72990082,
-15.4989684, -17.14333904, -18.41200621, -19.54005143, -21.33358514,
-22.43927623, -24.2060968, -25.50735052, -27.55116336, -29.2127067,
-31.57842409, 0.98624967, 1.05623887, 1.12745039, 1.23321648,
1.35573164, 1.49312113, 1.64595807, 1.79369437, 1.94101915, 2.058862,
2.25496797, 2.42619868, 2.55613596, 2.79138446, 2.99035388, 3.23551216,
3.51097689, 3.62959081, 3.82155126, 3.84300346, 4.13483986, 4.54369777,
4.94897981, 5.11509052, 5.39001882, 0.9514032, 0.99681586, 1.03730419,
1.04824072, 1.04797528, 1.06910128, 1.12469785, 1.21428279, 1.30904146,
1.37573668, 1.40136325, 1.5753102, 1.70414268, 1.80386565, 1.92570499,
2.0383393, 2.12475644, 2.2082331, 2.29218921, 2.36487555, 2.50138137,
2.64567828, 2.79853731, 2.93185241, 3.12279311, 1.01988254, 1.03922071,
1.06280563, 1.08362069, 1.11319301, 1.14180473, 1.18285406, 1.2180591,
1.26226915, 1.29586408, 1.32613699, 1.36598375, 1.40329341, 1.4451729,
1.48790085, 1.55886325, 1.63638681, 1.70264308, 1.77267016, 1.8441435,
1.91281934, 1.98230324, 2.06191316, 2.14247295, 2.24215215, 1.02800413,
1.04474773, 1.07428817, 1.10191642, 1.1264395, 1.18194003, 1.19865798,
1.25693314, 1.29437338, 1.32826683, 1.37045049, 1.4068502, 1.4507616,
1.4970525, 1.54846081, 1.58626933, 1.63061396, 1.68351074, 1.74580812,
1.81362169, 1.87773308, 1.94465883, 2.0222426, 2.10581631, 2.19698186,
1.0251781, 1.037071, 1.06774992, 1.09349173, 1.14221548, 1.16959323,
1.1983048, 1.2375777, 1.27002279, 1.31423491, 1.36378891, 1.40311779,
1.43530323, 1.48846855, 1.53310474, 1.59724962, 1.66049974, 1.72194503,
1.78544826, 1.84735243, 1.91670455, 1.98082309, 2.06853093, 2.15893133,
2.23743275, 1.06233323, 1.08569846, 1.11453233, 1.13991374, 1.17221921,
1.20918963, 1.2515532, 1.28104668, 1.32847634, 1.36073173, 1.39642256,
1.43908537, 1.48165344, 1.53748854, 1.57814798, 1.62418086, 1.66825057,
1.70991412, 1.78380188, 1.84042759, 1.91204036, 1.99711396, 2.07308763,
2.15283209, 2.26163182, 1.0212788, 1.06481218, 1.08452735, 1.09568929,
1.10438224, 1.1197379, 1.13527127, 1.17145958, 1.18765723, 1.21740031,
1.25979699, 1.28596906, 1.33985346, 1.39540306, 1.44733272, 1.50525209,
1.56365581, 1.62633971, 1.69402981, 1.74247531, 1.86136397, 1.92750376,
2.02239323, 2.11485118, 2.21309836, 0.96614268, 0.98829381, 1.00600781,
1.03978883, 1.07002212, 1.09930195, 1.12422199, 1.15985129, 1.20320583,
1.22047939, 1.23983004, 1.28319784, 1.31812527, 1.36269115, 1.41800597,
1.47886995, 1.54274521, 1.60188327, 1.68070546, 1.76777472, 1.83612375,
1.9067515, 1.9913289, 2.0823284, 2.16669305, 0.98199477, 1.02190768,
1.04090641, 1.06612179, 1.11379382, 1.12917071, 1.15810526, 1.21077909,
1.2549509, 1.29879793, 1.32795931, 1.37686566, 1.41167936, 1.4471635,
1.49894269, 1.56267649, 1.59085622, 1.61822423, 1.6656189, 1.76081648,
1.81416887, 1.89211154, 1.94475562, 2.01453093, 2.07256382, 0.97696733,
1.01469201, 1.04137592, 1.06035216, 1.08890237, 1.13690291, 1.18401286,
1.21937768, 1.25721765, 1.29626061, 1.33886236, 1.36952752, 1.38218364,
1.42443204, 1.46501992, 1.51664606, 1.55053638, 1.61302731, 1.6818277,
1.72713869, 1.80670522, 1.87590968, 1.94208602, 2.02442031, 2.11313374,
1.00559129, 1.01038095, 1.02016732, 1.05491036, 1.08478989, 1.14132695,
1.17186987, 1.20501771, 1.24282553, 1.274986, 1.3057434, 1.34177906,
1.38722752, 1.46849164, 1.51818333, 1.57846161, 1.63036351, 1.70097923,
1.76039503, 1.81295488, 1.85389337, 1.92606235, 1.98408398, 2.07779737,
2.17452086, 1.07319721, 1.10660837, 1.16233939, 1.17371553, 1.20634874,
1.24684749, 1.27744775, 1.31098081, 1.34778305, 1.38565639, 1.39613015,
1.41727511, 1.45388739, 1.49367624, 1.54221915, 1.5848988, 1.6184283,
1.66017629, 1.71291744, 1.7763558, 1.83641566, 1.91542788, 1.98368372,
2.06457462, 2.15113101, 1.03163511, 1.07264714, 1.0906501, 1.11502027,
1.1459202, 1.18376477, 1.20466518, 1.21966155, 1.2457368, 1.28686728,
1.32068892, 1.36526527, 1.39894438, 1.44074018, 1.48046384, 1.53114812,
1.57850827, 1.62875976, 1.72010075, 1.77447076, 1.83823988, 1.89643413,
1.97172851, 2.06158149, 2.15951031, 0.98466994, 1.0113286, 1.04186614,
1.07046599, 1.089463, 1.11843485, 1.15204135, 1.17449007, 1.23359369,
1.29289375, 1.3523251, 1.38944067, 1.42822538, 1.45290503, 1.49923165,
1.53480748, 1.54514446, 1.57677689, 1.59949571, 1.62052891, 1.67384722,
1.75173591, 1.81988219, 1.9155544, 2.02441584, 1.04605206, 1.06936598,
1.11694005, 1.13489992, 1.16209433, 1.19354721, 1.2202319, 1.25708802,
1.28140106, 1.28632712, 1.32077809, 1.37195534, 1.41807217, 1.47308118,
1.52208627, 1.57263764, 1.61301977, 1.67231913, 1.73633051, 1.78043054,
1.84691771, 1.92222536, 1.96752064, 2.05563286, 2.16528388, 1.05112529,
1.10351062, 1.13860184, 1.16796658, 1.19333026, 1.22542139, 1.27035729,
1.31420796, 1.37603638, 1.39868495, 1.45124132, 1.51692859, 1.56688525,
1.63680741, 1.67937664, 1.7519989, 1.80707543, 1.86691377, 1.96501259,
2.02530811, 2.06845898, 2.14897186, 2.25249876, 2.38101549, 2.46608487,
1.03076923, 1.04877034, 1.09036086, 1.14940866, 1.19881546, 1.24461144,
1.28780204, 1.34388438, 1.41926069, 1.4762776, 1.50709561, 1.50655735,
1.5154096, 1.53115958, 1.56502984, 1.60955103, 1.66979149, 1.70538542,
1.79327489, 1.83346776, 1.88158599, 1.951275, 2.02981087, 2.13059591,
2.2232823, 0.98133747, 1.02968238, 1.05806807, 1.08532626, 1.10718808,
1.14593448, 1.18145108, 1.21158057, 1.25863393, 1.28118544, 1.31087784,
1.3365042, 1.39355795, 1.45044333, 1.48871147, 1.53047716, 1.54743864,
1.58028163, 1.67019684, 1.77429283, 1.88300634, 1.99000979, 2.0878309,
2.14372256, 2.24707659, 0.98163369, 0.9739992, 1.02159918, 1.04093618,
1.06504599, 1.11892727, 1.15696029, 1.17201776, 1.20415757, 1.24852026,
1.30183529, 1.36263725, 1.43122589, 1.46826225, 1.49003175, 1.52590997,
1.59268669, 1.67513289, 1.77700613, 1.86822887, 1.94041693, 2.05629471,
2.1736047, 2.22527381, 2.36222434, 0.96487189, 0.99822735, 1.04022824,
1.03703821, 1.05074628, 1.06012732, 1.09944396, 1.1284979, 1.17721547,
1.22152635, 1.26550458, 1.29053943, 1.32686828, 1.36410937, 1.37876456,
1.41638114, 1.48133749, 1.54124032, 1.64288605, 1.69825485, 1.77399047,
1.87051655, 1.969995, 2.10824378, 2.22555523, 1.10127532, 1.13628944,
1.15979646, 1.15143936, 1.17062798, 1.20687848, 1.23280216, 1.28598163,
1.33872038, 1.38750054, 1.45131892, 1.55769824, 1.61411708, 1.61326875,
1.65917154, 1.64929486, 1.69936031, 1.74504657, 1.8056997, 1.86854163,
1.88133502, 1.94354599, 2.00426226, 2.09515063, 2.16886833, 1.02044473,
1.02333886, 1.09180521, 1.11587046, 1.18838088, 1.16008734, 1.18071027,
1.2086785, 1.23911849, 1.278932, 1.32046856, 1.36053523, 1.42618367,
1.47485784, 1.5119496, 1.56622462, 1.62065226, 1.68871961, 1.75647153,
1.80740771, 1.84602806, 1.87414317, 1.92905254, 2.02447803, 2.14047062,
0.99922532, 1.01329566, 1.07326068, 1.0484829, 1.06740971, 1.08694087,
1.1320549, 1.17072957, 1.2410876, 1.25708848, 1.29757491, 1.34258401,
1.36819577, 1.40682801, 1.45443162, 1.49524398, 1.5313246, 1.55320309,
1.60506783, 1.67852996, 1.74527091, 1.80891881, 1.85011921, 1.87211318,
1.93892537, 1.02271887, 1.03382223, 1.02874967, 1.04345033, 1.09869139,
1.11606845, 1.13513926, 1.19589374, 1.2298028, 1.27492803, 1.30936942,
1.35007846, 1.38319446, 1.41237037, 1.45031666, 1.50475169, 1.53534232,
1.59282089, 1.64075487, 1.71217075, 1.75684854, 1.82266468, 1.87057718,
1.95847387, 2.04371428, 0.97072863, 0.98424934, 1.01744165, 1.09146496,
1.08422762, 1.10330284, 1.15101041, 1.16718182, 1.18182539, 1.21258115,
1.28222425, 1.29755319, 1.32582403, 1.37954112, 1.40908698, 1.44979796,
1.52744411, 1.59552523, 1.68278661, 1.73971629, 1.7884613, 1.83484532,
1.94882338, 2.02887672, 2.10293558, 0.99010068, 1.06819438, 1.1048192,
1.13661824, 1.1809826, 1.2063722, 1.21332095, 1.20063832, 1.25417905,
1.27963732, 1.29922339, 1.31235441, 1.35106842, 1.41186703, 1.49587189,
1.56186682, 1.60910469, 1.65136564, 1.69057609, 1.7473359, 1.83137222,
1.9297338, 2.00489849, 2.03507571, 2.1918563, 1.00332759, 1.02362498,
1.02976753, 1.05902898, 1.07791814, 1.09239424, 1.11611455, 1.13383909,
1.15176049, 1.18073433, 1.22295863, 1.3043057, 1.35473123, 1.384469,
1.44879586, 1.50519723, 1.56047904, 1.60803407, 1.6908902, 1.78912285,
1.83650964, 1.89839544, 1.96406233, 2.03986034, 2.12898496, 1.06701762,
1.05850193, 1.07463827, 1.12140775, 1.15777548, 1.16824133, 1.18688826,
1.18273354, 1.19761666, 1.22268828, 1.26571746, 1.29782899, 1.33615335,
1.36276248, 1.39696466, 1.46338484, 1.52919928, 1.60137551, 1.64384531,
1.72358265, 1.81888298, 1.93911715, 2.05387787, 2.1009594, 2.16894374,
0.97791041, 1.03817226, 1.07502205, 1.10436964, 1.16921303, 1.21566869,
1.2546289, 1.27593616, 1.24969394, 1.23780491, 1.31961718, 1.3930088,
1.42526482, 1.45995387, 1.50172819, 1.57671506, 1.67687637, 1.72345397,
1.76501239, 1.82616993, 1.86907206, 1.93713869, 2.01397799, 2.08954003,
2.19671735, 1.02502674, 1.04430011, 1.07158893, 1.1395607, 1.17310862,
1.22323365, 1.27990071, 1.36285607, 1.32357437, 1.32821954, 1.3460982,
1.36132148, 1.3905568, 1.44738039, 1.48087846, 1.53704469, 1.59154973,
1.64060604, 1.65696447, 1.72132247, 1.85179547, 2.01690529, 2.01439329,
2.06361423, 2.11397301, 0.97764691, 0.97035959, 0.99715067, 1.05893122,
1.10996625, 1.16457994, 1.23251472, 1.30200503, 1.33644344, 1.35596092,
1.37465318, 1.40068669, 1.4452011, 1.48478437, 1.51120166, 1.55112409,
1.59787118, 1.62612497, 1.72464025, 1.77317788, 1.83663123, 1.89895157,
2.03730727, 2.08953253, 2.15192026, 1.00396176, 1.00771302, 1.02868897,
1.04563726, 1.07623317, 1.11346324, 1.13657194, 1.17947464, 1.23803453,
1.27233571, 1.30337311, 1.34872151, 1.42991595, 1.46906263, 1.49517797,
1.53051888, 1.53690456, 1.54552714, 1.61676685, 1.68773193, 1.7358719,
1.78432291, 1.85183001, 1.90780945, 1.94800549, 1.04529153, 1.08483932,
1.11061605, 1.14601833, 1.15628718, 1.20004638, 1.24637184, 1.27197905,
1.31185805, 1.34540667, 1.39625673, 1.43888693, 1.48734687, 1.49514711,
1.56113764, 1.65849042, 1.7360305, 1.78617953, 1.88403989, 1.93146345,
2.00729117, 2.07115685, 2.16058338, 2.22662655, 2.31691351, 1.05467198,
1.15131705, 1.20266057, 1.21927897, 1.16565298, 1.19465814, 1.1830873,
1.1331634, 1.18111669, 1.23782268, 1.27191278, 1.28899794, 1.29286566,
1.31080314, 1.35560637, 1.38751275, 1.41884249, 1.45006589, 1.50474967,
1.54010735, 1.59694222, 1.64685788, 1.7135159, 1.79250743, 1.87296393,
1.05194994, 1.09166188, 1.11826825, 1.09923551, 1.17772189, 1.2326729,
1.27892514, 1.32838899, 1.38760782, 1.4545414, 1.48431482, 1.50223196,
1.54552951, 1.56785481, 1.63361925, 1.69541856, 1.6576735, 1.65735546,
1.68195898, 1.74376744, 1.84448742, 1.93565541, 2.00785842, 2.10960064,
2.19433912, 0.99030163, 0.98831467, 1.01583015, 1.05853149, 1.12117056,
1.19372632, 1.2491644, 1.2654652, 1.24974154, 1.28219917, 1.29247743,
1.32021308, 1.36072271, 1.39991339, 1.43646648, 1.4903018, 1.51694891,
1.54984335, 1.57739807, 1.62179799, 1.70769939, 1.77821751, 1.81767698,
1.86837522, 1.94133097, 0.9987968, 1.07878364, 1.12523276, 1.18972091,
1.24748957, 1.25896122, 1.29771322, 1.41629807, 1.46713279, 1.46266446,
1.46739423, 1.48434084, 1.53128246, 1.57893522, 1.61260901, 1.65361925,
1.700149, 1.75118608, 1.79931776, 1.87857401, 1.93613245, 2.00556409,
2.07109766, 2.19522589, 2.31348632, 1.00814555, 1.03084904, 1.09779299,
1.09746795, 1.11056146, 1.14272994, 1.1623929, 1.17069642, 1.1961018,
1.21426864, 1.23714405, 1.29191503, 1.30514091, 1.3213024, 1.34696077,
1.38577276, 1.4047326, 1.45403575, 1.50734873, 1.55384489, 1.58802107,
1.63500845, 1.72296703, 1.82056274, 1.86453375, 0.99953735, 1.00591238,
1.05020437, 1.10359635, 1.14433481, 1.17355804, 1.2139382, 1.24847831,
1.29609779, 1.32863267, 1.38110878, 1.4234992, 1.44135083, 1.47449832,
1.51829845, 1.61679247, 1.67871774, 1.73995835, 1.80974016, 1.89122238,
1.99283676, 2.05003448, 2.12352955, 2.21541462, 2.28194892, 1.03609179,
1.11185378, 1.13396017, 1.15956656, 1.20170658, 1.26949663, 1.30323532,
1.33457949, 1.33150051, 1.36602147, 1.391122, 1.4195619, 1.41871014,
1.44379453, 1.45055979, 1.46969437, 1.50751639, 1.5657143, 1.57838863,
1.65455814, 1.69348854, 1.78114182, 1.83443578, 1.94664388, 2.04052128,
0.00540622, -0.01352573, -0.02774934, -0.04927701, -0.07343441,
-0.10195186, -0.13548426, -0.16473557, -0.18960486, -0.2012118,
-0.24521005, -0.28825633, -0.30209625, -0.34251938, -0.37685141,
-0.42813033, -0.49786905, -0.50981974, -0.55877563, -0.53706136,
-0.60773228, -0.72403383, -0.84287945, -0.86825039, -0.95098772,
0.00628734, 0.00514929, 0.00423562, 0.00575331, 0.00803372, 0.00867592,
0.00687567, 0.00204996, -0.00329275, -0.00536157, -0.00284433,
-0.01542791, -0.02450148, -0.03107986, -0.0383819, -0.04380117,
-0.04791593, -0.05079253, -0.05438482, -0.05634662, -0.06375229,
-0.07128089, -0.07998139, -0.08804021, -0.10031811, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, -0.00073801, 0.001889, 0.00397645, 0.00631328, 0.00868387,
0.01136081, 0.01478916, 0.01755301, 0.0194532, 0.01949951, 0.02412351,
0.02965918, 0.0297491, 0.03217571, 0.03417233, 0.03884319, 0.0465862,
0.04675369, 0.05417598, 0.05077601, 0.05895169, 0.07412163, 0.09009093,
0.09312986, 0.10541077, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.97463664,
0.98812242, 1.01197499, 1.06011812, 1.11824667, 1.18485003, 1.26021895,
1.33946687, 1.41971458, 1.49384726, 1.605463, 1.69572294, 1.77985998,
1.94323515, 2.07433765, 2.22607538, 2.39037059, 2.45781286, 2.55803741,
2.55903266, 2.73127436, 2.9610262, 3.16541195, 3.20551379, 3.24921192,
1.92151377, 1.96307128, 1.98616415, 1.95362725, 1.90059873, 1.89305029,
1.94475373, 2.04876539, 2.16486989, 2.24765179, 2.26938907, 2.49497492,
2.65714696, 2.7534641, 2.90893677, 3.04663595, 3.12426054, 3.21266306,
3.27348114, 3.32613419, 3.47050282, 3.62825212, 3.7797293, 3.85319929,
3.98601933, 3.05401647, 3.00266828, 2.97483237, 2.94443497, 2.95847089,
2.95816958, 3.01914274, 3.05701854, 3.11631679, 3.14091462, 3.14144197,
3.18045044, 3.20979247, 3.23239977, 3.28017807, 3.4144108, 3.5728253,
3.69647183, 3.81117799, 3.92040211, 4.00465323, 4.07600499, 4.16653533,
4.23264999, 4.32757572, 4.07244304, 3.98853277, 4.0149673, 4.01429619,
4.01346339, 4.17515171, 4.10677746, 4.2883923, 4.32431829, 4.34939808,
4.42476108, 4.42666778, 4.50355452, 4.56677365, 4.66638631, 4.6622376,
4.70837959, 4.79960209, 4.91317111, 5.04955575, 5.14096621, 5.22546299,
5.33477389, 5.42058343, 5.51980774, 5.13305729, 4.98626304, 5.01636162,
5.01314444, 5.19515594, 5.1973212, 5.20923716, 5.2968834, 5.31442821,
5.42212396, 5.56501259, 5.5836985, 5.5921941, 5.73386466, 5.82639282,
6.01278301, 6.20857656, 6.39282066, 6.52743079, 6.64988004, 6.80404286,
6.88777128, 7.09963878, 7.27398265, 7.30971725, 6.4553706, 6.39021589,
6.41234545, 6.39405029, 6.43220656, 6.49082631, 6.63493421, 6.62185275,
6.77661103, 6.81868665, 6.84983688, 6.92357226, 7.0197345, 7.1889269,
7.2489654, 7.31301399, 7.36124314, 7.39100489, 7.65639362, 7.74747106,
7.94386865, 8.20699916, 8.35278953, 8.46322975, 8.73079979, 7.16936642,
7.40254976, 7.30854007, 7.10793907, 6.88716743, 6.74147024, 6.6274593,
6.71772857, 6.58929087, 6.62778123, 6.78640417, 6.72413879, 6.99080465,
7.23081238, 7.45685776, 7.68271888, 7.91034464, 8.15978616, 8.39625689,
8.46069843, 9.17732284, 9.31805976, 9.70938177, 9.97553714, 10.19549317,
7.36308639, 7.29562412, 7.18043625, 7.32057971, 7.37047853, 7.40209013,
7.36924412, 7.48535954, 7.67295564, 7.52333645, 7.40823268, 7.57233093,
7.64538242, 7.80268567, 8.10359247, 8.40424354, 8.73679992, 9.01120228,
9.44549071, 9.95525836, 10.18196096, 10.37909127, 10.6921812,
10.99868842, 11.11840161, 8.41536544, 8.66034589, 8.57102608,
8.52746023, 8.87141035, 8.68249257, 8.71686766, 9.11212246, 9.33682998,
9.56649393, 9.55620647, 9.79386203, 9.87362481, 9.90043545, 10.14957023,
10.47679479, 10.33687387, 10.21127218, 10.29055335, 10.94395394,
11.02617946, 11.38581347, 11.33000389, 11.4122889, 11.27122598,
9.33690428, 9.60827282, 9.65299243, 9.52601634, 9.54192855, 9.92415187,
10.27269265, 10.39457986, 10.52762705, 10.75479155, 10.93826431,
10.91103475, 10.61182834, 10.74491553, 10.87469563, 11.10004119,
11.07442835, 11.46898489, 11.86485272, 11.89530343, 12.35643597,
12.62535212, 12.767621, 13.03403881, 13.25158695, 10.87038879,
10.37302517, 10.03075566, 10.15927363, 10.20279774, 10.7562263,
10.7956354, 10.90229685, 11.02705458, 11.11239068, 11.16987898,
11.23710382, 11.5643504, 12.41150376, 12.71447825, 13.11845679,
13.36978139, 13.9594279, 14.23885326, 14.36785692, 14.27618096,
14.59683401, 14.58548058, 15.08677627, 15.47653172, 13.46696427,
13.63758906, 14.29837849, 13.87540451, 13.92678409, 14.19287607,
14.19285263, 14.2386013, 14.36079309, 14.53529802, 14.07879262,
13.81866487, 13.97699217, 14.06476906, 14.35905377, 14.44353335,
14.36772826, 14.42392278, 14.59925758, 14.94725292, 15.17644294,
15.67021099, 15.85627296, 16.16938142, 16.40074311, 13.24032273,
13.62326086, 13.3609782, 13.23879029, 13.32467925, 13.59780088,
13.42237457, 13.15726135, 13.0542091, 13.33326049, 13.39902442,
13.6424466, 13.71634202, 13.86237247, 14.02472973, 14.31307228,
14.5374655, 14.80524171, 15.7377148, 15.94455535, 16.23354516,
16.35598098, 16.7194179, 17.18770184, 17.65972012, 13.03446479,
13.02866703, 13.18332311, 13.22121524, 13.10819662, 13.17729036,
13.40170002, 13.25546195, 13.93222399, 14.64350519, 15.36575032,
15.44183772, 15.61693107, 15.43256322, 15.80109236, 15.80536528,
15.26898366, 15.17604839, 14.89302915, 14.53071223, 14.71091158,
15.28179093, 15.59493229, 16.28860418, 17.0235377, 15.75883189,
15.60927567, 16.04305106, 15.71438764, 15.65797722, 15.72137838,
15.64327131, 15.87165019, 15.7001209, 15.16154224, 15.29219233,
15.71600338, 16.05402348, 16.53626421, 16.93486908, 17.28942552,
17.38054304, 17.89013723, 18.31885201, 18.34474038, 18.81049923,
19.34086381, 19.14034549, 19.70145426, 20.44799459, 17.25488211,
18.05053033, 18.26027314, 18.27404649, 18.18099203, 18.25127443,
18.67528843, 19.12033097, 20.00857771, 19.76886902, 20.34344564,
21.24523244, 21.78280095, 22.65271599, 22.83257296, 23.6906827,
23.98008544, 24.47432402, 25.81734211, 26.07471515, 25.72806144,
26.25556111, 27.33758012, 28.80098978, 28.92682924, 17.38536404,
17.07812936, 17.57356401, 18.58805077, 19.2736669, 19.76180159,
20.20215689, 21.04475621, 22.41269941, 23.26739057, 23.21475569,
22.07577551, 21.34494784, 20.75661649, 20.81951981, 21.00191306,
21.61064515, 21.54293558, 22.67282154, 22.56708577, 22.56698715,
23.00386795, 23.5382585, 24.36844647, 24.85270129, 16.8572776,
17.70136645, 17.7552908, 17.77045115, 17.60839004, 17.97774096,
18.20127152, 18.25977507, 18.75760151, 18.61341726, 18.57739926,
18.38441051, 19.13916085, 19.82655948, 20.01963099, 20.17003888,
19.64659922, 19.60563813, 20.9058706, 22.5043608, 24.13481943,
25.57669172, 26.56626751, 26.34258679, 27.0590524, 18.02644062,
16.73753537, 17.50783638, 17.29811107, 17.16939322, 17.98186994,
18.31351373, 17.93402304, 18.06336817, 18.58094026, 19.39573218,
20.36877257, 21.535208, 21.61430918, 21.30872332, 21.30627214,
22.23692063, 23.57079963, 25.2911339, 26.68414873, 27.34538265,
29.12832021, 30.771944, 30.16778942, 31.88331065, 18.26725099,
18.50070479, 19.08073059, 18.02811531, 17.55334104, 17.01281401,
17.45922072, 17.56387804, 18.2782184, 18.91313597, 19.43930795,
19.29498906, 19.62114687, 19.88912757, 19.50125692, 19.57318581,
20.46579412, 21.16558952, 22.94942945, 23.31453573, 24.20810423,
25.4633647, 26.75638178, 28.90438436, 30.09874911, 25.05480549,
25.2306409, 24.85781286, 23.22723986, 22.87754758, 23.12509219,
23.0198166, 23.94572376, 24.80867389, 25.66127729, 26.82817047,
29.65205707, 30.56098207, 29.02339546, 29.44674918, 27.75083171,
28.23427962, 28.50657665, 29.03653011, 29.67580329, 28.50197758,
28.78037821, 28.88416333, 29.74230206, 29.75304653, 22.35494476,
21.21671303, 23.01024104, 22.95028373, 24.81078511, 22.39340658,
22.06733808, 22.01091943, 22.01737083, 22.45876928, 22.8897322,
23.17204911, 24.42804563, 24.9631876, 25.14400734, 25.72526112,
26.34478706, 27.38155115, 28.21430865, 28.37225193, 28.03243044,
27.33642185, 27.38960135, 28.30254211, 29.59988693, 22.4356677,
21.90318409, 23.34285517, 21.05511228, 20.76282273, 20.50746941,
21.31708083, 21.7298793, 23.2751118, 22.83863121, 23.26143691,
23.69866541, 23.60680014, 23.8007548, 24.38446965, 24.57156522,
24.63008734, 24.25325489, 24.60546924, 25.66208928, 26.32904867,
26.81267116, 26.48270157, 25.46902265, 25.48896114, 24.43680134,
23.52458049, 22.07674673, 21.55644109, 22.79699871, 22.43173039,
22.12063636, 23.46547247, 23.67117704, 24.43688745, 24.65760295,
24.99271404, 25.15653114, 25.01373004, 25.21699769, 25.88811191,
25.7011714, 26.48792651, 26.73601663, 27.79007603, 27.79723761,
28.34490487, 28.16697139, 29.15013237, 29.68735594, 22.81467938,
22.22678235, 22.61351649, 24.75285236, 23.18114119, 22.85835485,
23.73278045, 23.32167885, 22.91510965, 23.10825675, 24.74394947,
24.15828568, 24.14836168, 25.03874167, 25.00211611, 25.29924252,
26.84723386, 28.11099139, 29.81926578, 30.37362247, 30.48691574,
30.45422383, 32.58057276, 33.20082807, 33.24531145, 24.78768335,
27.44718359, 27.86927671, 27.96995781, 28.70308432, 28.52407763,
27.52688448, 25.57476578, 26.65870689, 26.56405688, 26.12394224,
25.48544047, 25.90057251, 27.08716695, 29.26180114, 30.45811427,
30.84475685, 31.1719374, 31.06673018, 31.59885641, 32.97296517,
34.74054444, 35.41469519, 34.18651084, 37.15811931, 26.44683813,
26.17512096, 25.10339631, 25.25543006, 24.86895727, 24.28530031,
24.1061609, 23.80646679, 23.38083302, 23.47934425, 24.05882773,
26.17041119, 26.98019551, 26.93823076, 28.27685356, 29.17089274,
29.96763938, 30.42626268, 31.99647362, 34.20279743, 34.20801567,
34.64202021, 35.13747575, 35.6420294, 36.25924742, 30.80698696,
28.80386776, 28.11236876, 29.01029582, 29.411397, 28.60756837,
28.19409163, 26.70374189, 26.06134083, 26.01782748, 26.66670059,
26.80625628, 27.27674815, 27.05531346, 27.23360086, 28.49653476,
29.74502191, 31.27305544, 31.2975117, 32.76702958, 34.72596923,
37.52711111, 39.82824915, 39.04391698, 38.75876145, 27.21548272,
29.08548408, 29.63200928, 29.83670504, 31.59808605, 32.50150626,
32.93135408, 32.61042179, 29.67924317, 27.81759331, 30.34403294,
32.36845772, 32.45038417, 32.53473198, 33.03209354, 34.76010651,
37.55717707, 38.0129993, 38.00281224, 38.86536548, 38.68764801,
39.34087483, 40.08741842, 40.44965418, 41.81573878, 30.29798809,
29.85174531, 29.87059541, 32.24411317, 32.68128619, 33.85319783,
35.42484618, 38.40828239, 34.3077087, 33.05112827, 32.39371055,
31.58928871, 31.47978942, 32.49766129, 32.55751066, 33.37571566,
34.15886806, 34.68242889, 33.53377538, 34.37058355, 37.94539854,
43.00111181, 40.41541575, 39.89314701, 39.07725209, 28.62891058,
26.69299282, 26.80860374, 28.84005267, 30.32309917, 31.6593126,
33.83530688, 36.1125253, 36.12812288, 35.52823582, 34.78401086,
34.39000476, 35.12242874, 35.32816114, 35.0669948, 35.28098398,
35.77134091, 35.38895633, 38.03691022, 38.21142625, 38.91181547,
39.53777825, 43.05957665, 42.51813463, 42.05772005, 31.7069347,
30.25868243, 29.89926728, 29.31021055, 29.59795573, 30.18111524,
29.95231243, 30.77245445, 32.26059799, 32.62818056, 32.74119682,
33.51751088, 36.10521319, 36.31872531, 36.06259405, 35.95254528,
34.46108374, 33.34499609, 34.78207497, 36.29443198, 36.51641032,
36.47270415, 37.18188251, 37.10646033, 36.11460313, 35.08307012,
35.85506656, 35.59003538, 36.00902584, 34.85644558, 35.79082424,
36.81914491, 36.61057379, 37.03447703, 37.27213702, 38.44423117,
38.88626333, 39.8690165, 38.36964892, 40.18492565, 43.2682575,
45.28693221, 46.11688715, 48.99337703, 49.01277518, 50.37950622,
50.70882209, 52.17634081, 52.17806046, 52.72584328, 36.43149734,
41.42715748, 43.19553684, 42.36419775, 36.82445367, 37.04036689,
34.63333401, 30.20536445, 31.32099173, 33.08682086, 33.33377412,
32.66998704, 31.36962606, 30.73273874, 31.47451274, 31.39693733,
31.32076886, 31.27117381, 32.07095827, 31.91199775, 32.63974507,
32.96751075, 33.78219473, 34.77021363, 35.42136152, 37.36687278,
38.2386999, 38.23933631, 35.08815853, 38.40750725, 40.03823145,
40.98914801, 41.97436879, 43.56676979, 45.98321789, 45.79707609,
44.72336204, 45.37146687, 44.47630692, 46.36805176, 47.79016695,
43.53719967, 41.5560106, 40.66995634, 41.68354251, 44.45600709,
46.53366351, 47.34961972, 49.24161917, 49.77894595, 34.24007988,
32.4667408, 32.62047331, 33.69719778, 36.08774049, 38.97434698,
40.62280918, 39.66163393, 36.68469843, 36.85161594, 35.70143308,
35.45609346, 36.0619942, 36.33172811, 36.60161816, 37.57573496,
37.09461048, 37.00518484, 36.35277517, 36.52339032, 38.41532706,
39.53443346, 39.03067507, 38.78878304, 39.26029959, 35.61811345,
39.47099341, 40.89312713, 43.64307886, 45.68198293, 44.08064692,
44.63930964, 51.04610334, 52.28064694, 49.82237186, 47.93962943,
46.77697023, 47.7142368, 48.28686634, 48.14379737, 48.33860753,
48.62748619, 49.35479177, 49.446602, 51.24601202, 51.79312212,
52.65653089, 53.02273498, 56.12889209, 58.1457053, 37.87671254,
37.62014299, 40.51422388, 38.35706231, 37.31947917, 37.63781562,
37.01409799, 35.83702613, 35.52942267, 35.04807469, 34.83214592,
36.2346902, 35.39971684, 34.63672253, 34.45431376, 34.92527142,
34.26032639, 35.18157368, 36.05826289, 36.46217302, 36.00474123,
36.16133898, 38.05387107, 39.98324299, 39.25468738, 38.20929588,
36.71310418, 38.13578472, 40.22641658, 41.17029081, 41.18731651,
42.06647286, 42.48760375, 43.58944339, 43.83175078, 45.30981735,
45.79987488, 44.99455113, 44.83357448, 45.69299055, 49.3747262,
50.83181565, 52.27707999, 53.74892714, 55.92673285, 59.10678519,
59.02503659, 59.8029698, 61.25030096, 60.72334395, 41.78827518,
45.80074024, 45.38210374, 45.19219128, 46.22623181, 49.34860001,
49.69320477, 49.49202238, 46.94139342, 47.40931509, 46.98953209,
46.60212337, 44.51455686, 43.9480072, 42.46491535, 41.59432522,
41.83664551, 43.03326316, 41.75798611, 43.6939745, 43.4924556,
45.69025648, 45.7831088, 48.59823783, 49.98288587), .Dim = c(1000,
5), .Dimnames = list(c("1", "2", "3", "4", "5", "6", "7", "8",
"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30",
"31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41",
"42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52",
"53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63",
"64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74",
"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85",
"86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96",
"97", "98", "99", "100", "101", "102", "103", "104", "105", "106",
"107", "108", "109", "110", "111", "112", "113", "114", "115",
"116", "117", "118", "119", "120", "121", "122", "123", "124",
"125", "126", "127", "128", "129", "130", "131", "132", "133",
"134", "135", "136", "137", "138", "139", "140", "141", "142",
"143", "144", "145", "146", "147", "148", "149", "150", "151",
"152", "153", "154", "155", "156", "157", "158", "159", "160",
"161", "162", "163", "164", "165", "166", "167", "168", "169",
"170", "171", "172", "173", "174", "175", "176", "177", "178",
"179", "180", "181", "182", "183", "184", "185", "186", "187",
"188", "189", "190", "191", "192", "193", "194", "195", "196",
"197", "198", "199", "200", "201", "202", "203", "204", "205",
"206", "207", "208", "209", "210", "211", "212", "213", "214",
"215", "216", "217", "218", "219", "220", "221", "222", "223",
"224", "225", "226", "227", "228", "229", "230", "231", "232",
"233", "234", "235", "236", "237", "238", "239", "240", "241",
"242", "243", "244", "245", "246", "247", "248", "249", "250",
"251", "252", "253", "254", "255", "256", "257", "258", "259",
"260", "261", "262", "263", "264", "265", "266", "267", "268",
"269", "270", "271", "272", "273", "274", "275", "276", "277",
"278", "279", "280", "281", "282", "283", "284", "285", "286",
"287", "288", "289", "290", "291", "292", "293", "294", "295",
"296", "297", "298", "299", "300", "301", "302", "303", "304",
"305", "306", "307", "308", "309", "310", "311", "312", "313",
"314", "315", "316", "317", "318", "319", "320", "321", "322",
"323", "324", "325", "326", "327", "328", "329", "330", "331",
"332", "333", "334", "335", "336", "337", "338", "339", "340",
"341", "342", "343", "344", "345", "346", "347", "348", "349",
"350", "351", "352", "353", "354", "355", "356", "357", "358",
"359", "360", "361", "362", "363", "364", "365", "366", "367",
"368", "369", "370", "371", "372", "373", "374", "375", "376",
"377", "378", "379", "380", "381", "382", "383", "384", "385",
"386", "387", "388", "389", "390", "391", "392", "393", "394",
"395", "396", "397", "398", "399", "400", "401", "402", "403",
"404", "405", "406", "407", "408", "409", "410", "411", "412",
"413", "414", "415", "416", "417", "418", "419", "420", "421",
"422", "423", "424", "425", "426", "427", "428", "429", "430",
"431", "432", "433", "434", "435", "436", "437", "438", "439",
"440", "441", "442", "443", "444", "445", "446", "447", "448",
"449", "450", "451", "452", "453", "454", "455", "456", "457",
"458", "459", "460", "461", "462", "463", "464", "465", "466",
"467", "468", "469", "470", "471", "472", "473", "474", "475",
"476", "477", "478", "479", "480", "481", "482", "483", "484",
"485", "486", "487", "488", "489", "490", "491", "492", "493",
"494", "495", "496", "497", "498", "499", "500", "501", "502",
"503", "504", "505", "506", "507", "508", "509", "510", "511",
"512", "513", "514", "515", "516", "517", "518", "519", "520",
"521", "522", "523", "524", "525", "526", "527", "528", "529",
"530", "531", "532", "533", "534", "535", "536", "537", "538",
"539", "540", "541", "542", "543", "544", "545", "546", "547",
"548", "549", "550", "551", "552", "553", "554", "555", "556",
"557", "558", "559", "560", "561", "562", "563", "564", "565",
"566", "567", "568", "569", "570", "571", "572", "573", "574",
"575", "576", "577", "578", "579", "580", "581", "582", "583",
"584", "585", "586", "587", "588", "589", "590", "591", "592",
"593", "594", "595", "596", "597", "598", "599", "600", "601",
"602", "603", "604", "605", "606", "607", "608", "609", "610",
"611", "612", "613", "614", "615", "616", "617", "618", "619",
"620", "621", "622", "623", "624", "625", "626", "627", "628",
"629", "630", "631", "632", "633", "634", "635", "636", "637",
"638", "639", "640", "641", "642", "643", "644", "645", "646",
"647", "648", "649", "650", "651", "652", "653", "654", "655",
"656", "657", "658", "659", "660", "661", "662", "663", "664",
"665", "666", "667", "668", "669", "670", "671", "672", "673",
"674", "675", "676", "677", "678", "679", "680", "681", "682",
"683", "684", "685", "686", "687", "688", "689", "690", "691",
"692", "693", "694", "695", "696", "697", "698", "699", "700",
"701", "702", "703", "704", "705", "706", "707", "708", "709",
"710", "711", "712", "713", "714", "715", "716", "717", "718",
"719", "720", "721", "722", "723", "724", "725", "726", "727",
"728", "729", "730", "731", "732", "733", "734", "735", "736",
"737", "738", "739", "740", "741", "742", "743", "744", "745",
"746", "747", "748", "749", "750", "751", "752", "753", "754",
"755", "756", "757", "758", "759", "760", "761", "762", "763",
"764", "765", "766", "767", "768", "769", "770", "771", "772",
"773", "774", "775", "776", "777", "778", "779", "780", "781",
"782", "783", "784", "785", "786", "787", "788", "789", "790",
"791", "792", "793", "794", "795", "796", "797", "798", "799",
"800", "801", "802", "803", "804", "805", "806", "807", "808",
"809", "810", "811", "812", "813", "814", "815", "816", "817",
"818", "819", "820", "821", "822", "823", "824", "825", "826",
"827", "828", "829", "830", "831", "832", "833", "834", "835",
"836", "837", "838", "839", "840", "841", "842", "843", "844",
"845", "846", "847", "848", "849", "850", "851", "852", "853",
"854", "855", "856", "857", "858", "859", "860", "861", "862",
"863", "864", "865", "866", "867", "868", "869", "870", "871",
"872", "873", "874", "875", "876", "877", "878", "879", "880",
"881", "882", "883", "884", "885", "886", "887", "888", "889",
"890", "891", "892", "893", "894", "895", "896", "897", "898",
"899", "900", "901", "902", "903", "904", "905", "906", "907",
"908", "909", "910", "911", "912", "913", "914", "915", "916",
"917", "918", "919", "920", "921", "922", "923", "924", "925",
"926", "927", "928", "929", "930", "931", "932", "933", "934",
"935", "936", "937", "938", "939", "940", "941", "942", "943",
"944", "945", "946", "947", "948", "949", "950", "951", "952",
"953", "954", "955", "956", "957", "958", "959", "960", "961",
"962", "963", "964", "965", "966", "967", "968", "969", "970",
"971", "972", "973", "974", "975", "976", "977", "978", "979",
"980", "981", "982", "983", "984", "985", "986", "987", "988",
"989", "990", "991", "992", "993", "994", "995", "996", "997",
"998", "999", "1000"), c("V1", "V2", "V3", "V4", "V5")))
"sc.beta.exp" <-
structure(c(-0.00205601, -0.04350992, -0.07621043, -0.10080565,
-0.12674914, -0.1495959, -0.17220537, -0.19495705, -0.21671427,
-0.23645304, -0.25801745, -0.27780476, -0.29824081, -0.32191494,
-0.34160691, -0.36683016, -0.38942071, -0.41546194, -0.44639265,
-0.48592752, -0.52165072, -0.56783761, -0.6127344, -0.65960831,
-0.74262905, -0.06077391, -0.10671753, -0.16554774, -0.2236113,
-0.25935809, -0.30084745, -0.33774327, -0.37844045, -0.41403586,
-0.44923494, -0.4858058, -0.51645535, -0.54855859, -0.58788583,
-0.62622258, -0.6742432, -0.72300058, -0.76804658, -0.8147704,
-0.86677581, -0.91088039, -0.97261665, -1.06663861, -1.17118353,
-1.33653777, 0.10140182, 0.02156696, -0.14713065, -0.16816557,
-0.35357271, -0.46525484, -0.51648857, -0.56150778, -0.58459748,
-0.63733496, -0.62213641, -0.67000948, -0.67303189, -0.84746374,
-0.8983789, -0.97701572, -1.07305991, -1.16062736, -1.22965677,
-1.30293052, -1.42636318, -1.53850738, -1.6618048, -1.80546088,
-2.10073182, -0.03699697, -0.14300359, -0.26083639, -0.37595492,
-0.50113154, -0.61815519, -0.66404042, -0.71744956, -0.79442704,
-0.89332784, -0.95224366, -1.00144328, -1.08881223, -1.19650664,
-1.28468937, -1.33168425, -1.38426628, -1.46819315, -1.56963823,
-1.67983283, -1.78663882, -1.89072579, -2.05123327, -2.21325135,
-2.47788137, 0.19627955, 0.12202552, -0.11931679, -0.29963665,
-0.50516098, -0.60938254, -0.71330489, -0.88642541, -0.9941319,
-1.07114034, -1.19723266, -1.30113697, -1.4850092, -1.50718003,
-1.58405537, -1.72090558, -1.8315799, -1.94762736, -2.05575809,
-2.17708483, -2.33347811, -2.48511537, -2.65950215, -2.87779391,
-3.19245767, 0.01128291, -0.248228, -0.47909669, -0.61372571,
-0.72912799, -0.88645129, -1.06586504, -1.17638561, -1.35840307,
-1.44607488, -1.52157893, -1.66896844, -1.7748597, -1.90893508,
-2.03181375, -2.17853927, -2.32807778, -2.45289663, -2.61001382,
-2.7691005, -2.96418916, -3.14814902, -3.34470671, -3.61114444,
-3.93872952, 0.06860052, -0.06002752, -0.25274357, -0.45663817,
-0.63740649, -0.81796022, -0.98687709, -1.25953371, -1.34359895,
-1.44138557, -1.67015262, -1.79556856, -1.90099151, -2.04709751,
-2.17560206, -2.42852507, -2.58505717, -2.73487377, -2.97943889,
-3.16847451, -3.40212791, -3.59524832, -3.88096431, -4.21618075,
-4.6654744, -0.30873625, -0.37616355, -0.4320738, -0.44050328,
-0.63114752, -0.82153881, -0.8154064, -0.79562169, -1.03649754,
-1.14165336, -1.2796083, -1.55813138, -1.85564303, -2.02691776,
-2.21997098, -2.43772658, -2.67686406, -2.91474255, -3.23984272,
-3.51352605, -3.77075135, -4.01935266, -4.36843426, -4.68221352,
-5.2566123, -0.04323655, -0.27543147, -0.19895631, -0.53139081,
-0.63401205, -0.84730449, -1.1367216, -1.46163013, -1.71729249,
-1.98857591, -2.16092383, -2.38940263, -2.58363191, -2.73901739,
-2.97150283, -3.22379889, -3.38008096, -3.58424345, -3.84873769,
-4.12255856, -4.4996604, -4.76421575, -5.0747539, -5.4012802,
-6.07633496, -0.59026995, -0.78888686, -0.84169141, -1.12914513,
-1.08429498, -1.31435606, -1.65969814, -1.77772078, -2.0289663,
-2.31914081, -2.55772924, -2.78358214, -3.08245359, -3.33261351,
-3.54685337, -3.67675223, -3.82951847, -4.03467984, -4.29508169,
-4.58778186, -4.88391912, -5.14793945, -5.56144018, -6.05261985,
-6.73903932, -0.62365989, -0.8960406, -0.9973205, -0.93543882,
-1.29637208, -1.35312996, -1.28414089, -1.44058975, -1.96889323,
-2.50670568, -3.04918653, -3.0695041, -3.1255281, -3.43854805,
-3.75939697, -4.08057561, -4.44770759, -4.66068165, -4.9305473,
-5.01719254, -5.49626725, -5.86716231, -6.20765269, -6.74667468,
-7.48958545, -0.39819155, -0.48811015, -0.87102334, -0.99818845,
-1.41473828, -1.65150107, -1.90971392, -2.24058618, -2.83435553,
-2.90747319, -3.21918878, -3.4805597, -3.78522248, -4.01708232,
-4.31902952, -4.68759947, -4.96780537, -5.20162379, -5.45507483,
-5.79562957, -6.05926263, -6.47248298, -6.85596659, -7.40092146,
-8.19400757, -1.46326129, -1.45237427, -1.73114642, -2.06951705,
-2.17171595, -2.03826979, -2.23787623, -2.55099533, -2.87902336,
-2.90219738, -3.30786288, -3.77261976, -4.16193914, -4.40416303,
-4.60698882, -4.93519853, -5.23844331, -5.49275767, -5.83373602,
-6.18406416, -6.45823439, -6.93923686, -7.38723927, -8.07680541,
-8.89268249, -0.51375043, -0.53363278, -1.58054624, -1.28632696,
-1.46151833, -1.44156324, -1.66692703, -2.15354962, -2.75244278,
-2.86043285, -3.07592003, -3.29929553, -3.68344546, -3.95930435,
-4.26005028, -4.77997724, -5.40181266, -5.55515654, -6.11858768,
-6.59942857, -6.91257138, -7.40293259, -7.7889321, -8.51660901,
-9.65441609, 0.02976106, -0.49633841, -0.61458891, -1.82388242,
-2.03272019, -2.49471016, -2.83126547, -3.56689879, -3.82973264,
-4.12041969, -4.41921674, -4.89864804, -5.27342403, -5.51832859,
-5.78291064, -6.06878278, -6.37635838, -6.66123413, -7.04190606,
-7.34971911, -7.89580958, -8.37333924, -8.96852578, -9.58000343,
-10.51211077, -0.38974549, -0.71179002, -1.14613735, -1.46871545,
-2.27214792, -2.32067089, -2.51933064, -2.48202476, -2.61789952,
-2.86114137, -3.80517146, -4.44230553, -4.8157574, -5.21608918,
-5.76333251, -6.1635206, -6.56593879, -6.9223321, -7.39624708,
-7.88171088, -8.44204212, -9.0000243, -9.63071123, -10.21385701,
-11.25503879, -0.20237304, -0.70755051, -0.86782478, -1.35383915,
-1.36846845, -1.60655213, -1.98731252, -2.52870675, -3.09927772,
-3.706794, -4.29782472, -4.83269263, -5.3447874, -5.91150436,
-6.49839455, -6.95471541, -7.35339115, -7.58056409, -8.02121118,
-8.39603392, -8.58674749, -9.35171723, -10.07279131, -10.66569027,
-11.88612939, 0.84455899, -0.23006559, -1.47163663, -2.1488782,
-2.62266859, -3.16205255, -3.58198447, -4.05438843, -4.68020013,
-5.23004717, -5.21313811, -5.35560493, -5.95613999, -6.43622554,
-6.85856141, -7.35101775, -7.81520325, -8.15325008, -8.74048902,
-9.08725656, -9.59171607, -10.11883388, -10.62183678, -11.39821347,
-12.56752448, -1.67128017, -2.20680867, -3.13589216, -3.47551527,
-3.90749722, -3.99063168, -4.39048612, -4.46995214, -5.27643139,
-5.46835338, -5.66829218, -6.12282211, -6.5124157, -7.09318873,
-7.46518049, -7.99396435, -8.31653732, -8.77892414, -9.30708587,
-9.66382709, -9.98001718, -10.65531591, -11.2588997, -12.05159318,
-13.17064806, 0.56226508, -0.04777826, -1.56892986, -2.14818732,
-2.6098228, -3.26195964, -3.53470698, -4.16702766, -4.90974788,
-5.29282649, -5.74462669, -6.12849195, -6.42681387, -6.89313727,
-7.29141672, -7.84055488, -8.38222967, -8.9636891, -9.52777045,
-10.11382797, -10.71333868, -11.26869701, -11.91084459, -12.62109661,
-13.8395824, 1.13290846, 0.89703063, 0.56712965, -0.70243818,
-2.05507976, -2.95193311, -3.8659036, -4.21048661, -4.47109642,
-4.93789634, -5.17849161, -5.67989741, -6.76912383, -7.30407354,
-7.5914235, -7.95979471, -8.48568664, -8.90257536, -9.8423896,
-10.58083056, -11.08718256, -11.68566309, -12.38761123, -13.35406944,
-14.72888546, -1.05126457, -1.74073669, -2.40607929, -2.56149214,
-3.35614082, -3.75283911, -4.18312159, -4.38781768, -5.15570152,
-5.83029103, -6.34127938, -6.99045637, -7.37269132, -7.86415286,
-8.33527312, -8.79498425, -9.53086086, -9.9195605, -10.25938485,
-10.98259697, -11.66912201, -12.19766455, -12.83792066, -13.81148756,
-15.21308785, 2.54054652, 0.82701824, -0.99456938, -0.95119007,
-2.19989529, -2.82327935, -3.79848309, -4.14313374, -4.33506501,
-4.76435716, -5.55637797, -5.8795776, -5.45723092, -6.32542789,
-7.19605073, -7.7597719, -8.51764713, -9.62431215, -9.94327546,
-10.92145697, -11.57331323, -12.50466466, -13.48718891, -14.67051044,
-16.28370099, -1.10396119, -1.88956673, -2.55283259, -2.71557278,
-3.21146895, -3.89232089, -4.17796923, -4.65964991, -4.61568245,
-5.48716758, -6.77141913, -8.03711108, -8.40076215, -9.21042557,
-9.60243876, -10.12097174, -10.62214659, -10.9510378, -11.71479731,
-12.26968279, -12.9097425, -13.49462609, -14.16999418, -14.99410859,
-16.28832957, 0.05343857, -0.84884486, -1.70071485, -2.21648901,
-2.63736527, -3.90313394, -5.50950839, -6.03695584, -6.66627196,
-7.30256162, -7.92872057, -8.63306382, -9.26775364, -9.84305994,
-10.72921784, -11.24149674, -11.74065917, -12.17923782, -12.67617557,
-13.2176954, -13.73826644, -14.32931604, -15.05332438, -16.03855224,
-17.49597299, -1.1087556, -1.2247835, -2.09283214, -3.20960415,
-3.84004314, -4.48609036, -4.86314088, -5.67230258, -6.06166468,
-7.02106744, -7.26411554, -7.78553019, -8.19713096, -8.90916758,
-9.5769737, -10.43177291, -10.76373514, -11.4969438, -12.21495697,
-12.92143882, -13.66092414, -14.35922683, -15.35773855, -16.53124893,
-18.08951416, -1.94125821, -2.35120929, -1.3434366, -1.34248235,
-1.48665349, -1.71016716, -3.43695875, -4.416704, -5.62154265,
-6.68272723, -7.8318604, -8.2263082, -9.23151304, -9.75736812,
-10.23054843, -10.83842814, -11.09494365, -11.82668635, -12.72308123,
-13.54266661, -14.44177144, -15.36136789, -16.20823079, -17.2793449,
-18.98810218, -1.25858377, -2.46504052, -3.37753937, -4.24089191,
-5.45828378, -6.00792903, -6.60112516, -6.59389599, -7.34949748,
-7.92450035, -8.61339746, -9.40631958, -9.26452927, -9.86229634,
-11.01154607, -12.05821147, -12.68796751, -13.10887254, -13.95920456,
-14.58592923, -15.39340778, -16.22969745, -17.06470847, -18.09412396,
-19.70887735, -1.22450738, -2.56259961, -3.3165311, -4.30682435,
-5.79210526, -6.83941492, -7.15777613, -7.47129354, -8.11232911,
-8.35753837, -9.26760363, -10.07563333, -10.5736876, -10.98481247,
-11.52218607, -12.3283546, -12.76790072, -13.2808054, -13.47720721,
-14.37500335, -15.01509416, -16.22884254, -17.23375795, -18.3577004,
-20.14685069, -2.37587367, -3.95422324, -4.55104658, -5.4948409,
-6.38755891, -7.5533759, -7.98685388, -8.47340194, -8.87315504,
-9.87605563, -10.81396541, -11.16613697, -11.25150578, -11.35566102,
-12.18169769, -13.3398519, -13.88993215, -14.18742969, -14.9397487,
-15.60063505, -16.284291, -17.25134594, -18.16493106, -19.16452862,
-20.92388843, 3.2093659, 2.52195246, 2.00463535, -0.24192758,
-1.76914651, -3.18216141, -4.59048513, -5.93734844, -6.85663078,
-7.79086438, -8.35148549, -9.25153092, -8.96253871, -10.05534172,
-10.51475651, -11.98556145, -13.05552876, -14.11937571, -15.37354761,
-16.05409404, -16.95378341, -17.72328828, -18.64613501, -19.85846191,
-21.74244021, -1.29370623, -2.8083955, -5.0785649, -6.64350776,
-7.22575761, -7.75967244, -8.48182523, -8.39032299, -9.23056457,
-9.64042158, -9.37578058, -10.47742386, -11.41238214, -12.10271201,
-12.8103244, -13.23755334, -13.99011611, -14.70868859, -15.08347849,
-15.8969863, -16.62083418, -17.42784145, -18.48013583, -19.95828542,
-22.00016019, 3.49918412, 5.33981703, 3.7933203, 1.41458189,
-1.34569908, -2.93190469, -2.73825634, -5.07314716, -6.83401153,
-8.54429668, -10.23899023, -11.45315819, -12.47943683, -13.21499738,
-13.90835818, -14.64745028, -15.09732116, -15.53818684, -15.90760567,
-16.10028176, -16.95131117, -17.99404303, -19.18522954, -20.67874485,
-22.89088741, -1.87904205, -3.70587789, -4.25746866, -6.19062822,
-7.71598697, -8.66496173, -8.70364868, -9.00287451, -9.24991252,
-9.35502622, -10.020964, -10.24389309, -10.95490336, -12.3976629,
-12.89738572, -14.44427022, -15.66013378, -16.00471836, -16.75949595,
-17.81437945, -18.63545853, -19.57746736, -20.60558568, -21.8316931,
-23.5376052, -1.38741624, -2.37305402, -4.60582479, -3.79436405,
-4.65717737, -5.48990453, -6.11551975, -7.09724531, -8.4126708,
-8.8676451, -9.77720339, -11.15599848, -11.99682738, -13.03109875,
-14.13981077, -15.29127726, -16.07601427, -16.50168827, -17.22186887,
-17.84240941, -18.74279061, -19.9052739, -20.85777024, -22.09373421,
-23.97211012, 4.04157768, 0.04182197, 0.61384346, -0.72639998,
-2.22719318, -3.36486521, -4.34975602, -5.35606244, -6.06677032,
-7.7780948, -8.05448839, -8.23545215, -9.39726312, -10.59968515,
-11.91120641, -13.19096336, -14.41262704, -16.04750912, -17.14497915,
-18.09036888, -19.40587352, -20.29073981, -21.41614499, -22.82899068,
-24.66955951, -1.95276701, 0.64442615, 0.28727257, 0.02767817,
-3.73322123, -4.37373035, -6.00184118, -6.85014217, -8.23537131,
-8.95329112, -10.18488869, -10.96892597, -11.23269253, -11.67289685,
-12.86617676, -14.3449423, -15.48767618, -16.0304591, -17.46123357,
-18.21522262, -19.31829837, -20.12427047, -21.2697612, -23.05961241,
-25.62150554, -0.78810468, -2.19389888, -3.25108912, -4.36592616,
-6.04444193, -5.60451921, -7.13409115, -7.39586482, -10.08138793,
-11.1697892, -11.28037035, -12.46833927, -13.43383146, -14.64869429,
-15.20887219, -14.97789724, -15.71231685, -16.58010722, -17.49225486,
-18.78235158, -19.72688755, -21.33516895, -22.49287153, -24.30142779,
-26.49912014, 6.01842898, 6.03408774, 3.79440345, 6.09813898,
1.72335035, 0.72215896, 0.40812267, -1.659369, -4.81397025, -6.33160588,
-7.86987794, -9.83736506, -11.39174407, -13.13255791, -13.54467212,
-13.51363664, -14.15611162, -16.05292604, -17.55611297, -18.67236028,
-20.33389032, -21.6236963, -23.0325988, -24.68929107, -27.15682836,
0.59306793, -1.35356971, 1.91157779, 1.13097797, 1.73061324,
-2.3550778, -3.54386908, -5.06961735, -7.49111671, -9.166869,
-11.10456894, -12.77939871, -14.44406034, -14.89361661, -16.0784077,
-16.88902965, -17.95000808, -18.6417535, -19.10342899, -20.18316788,
-21.48381198, -22.59147178, -23.95778681, -25.52070886, -27.28806432,
2.3685995, 2.23155409, 2.15120757, 2.28694107, 2.35549245, 2.5308809,
2.71412534, 2.81063137, 3.00270378, 3.09852305, 3.25266033, 3.23720522,
3.32580101, 3.46657528, 3.54525887, 3.65755822, 3.68066109, 3.75135495,
3.93282105, 4.07048699, 4.11796059, 4.36989822, 4.65524656, 4.9591404,
5.22577119, 1.98152903, 1.97805138, 1.9079082, 1.91786877, 2.01759791,
2.06236954, 2.10784479, 2.1335919, 2.18029294, 2.19481085, 2.21818181,
2.30834848, 2.32423034, 2.28360713, 2.35341462, 2.39941816, 2.49861052,
2.66074495, 2.76223592, 2.77962271, 2.90865108, 3.00978939, 3.04779425,
3.16255411, 3.32233051, 2.25063857, 2.25834873, 2.12452615, 2.28772955,
2.02987029, 1.96913272, 2.05061048, 2.07967193, 2.25831752, 2.23316708,
2.42962126, 2.56368173, 2.7434621, 2.67967151, 2.78463614, 2.86915625,
2.88259957, 2.91102163, 2.99863582, 3.05968797, 3.07035384, 3.07670091,
3.29287857, 3.45193296, 3.54158462, 2.00377403, 1.99658819, 1.98665033,
1.99057536, 1.97869533, 1.97374217, 2.00752248, 2.02914326, 2.04084343,
2.04285074, 2.07820701, 2.11979859, 2.12475044, 2.13176738, 2.15918369,
2.19857191, 2.23467117, 2.2560667, 2.28185503, 2.28783134, 2.32321391,
2.34734158, 2.34228015, 2.36243339, 2.40678827, 2.1176782, 2.13615392,
2.0942903, 2.08716769, 2.05180478, 2.06844307, 2.07857906, 2.0545935,
2.07177445, 2.10269083, 2.10035792, 2.10698924, 2.07965232, 2.14122815,
2.16852377, 2.1674025, 2.18190524, 2.19579911, 2.22906255, 2.24534506,
2.25239401, 2.26822494, 2.28709717, 2.31261394, 2.34198985, 2.00995524,
1.97466944, 1.95116371, 1.97023376, 1.9882574, 1.99720073, 1.98767486,
2.00234029, 1.98636902, 2.01346061, 2.05112722, 2.0650834, 2.08537995,
2.09017446, 2.10373778, 2.11395692, 2.11297005, 2.12836984, 2.14018771,
2.15862121, 2.15821575, 2.16166632, 2.17345789, 2.15597732, 2.20118411,
2.04729531, 2.07030249, 2.07100812, 2.06577614, 2.06840127, 2.06173364,
2.07433702, 2.0460834, 2.08638875, 2.09942267, 2.08218153, 2.10707856,
2.12257044, 2.154892, 2.16989473, 2.16183776, 2.17978229, 2.19317991,
2.18340861, 2.19135427, 2.20254996, 2.21041323, 2.20247114, 2.22981864,
2.22621448, 1.94105851, 1.98470511, 2.02026268, 2.05849848, 2.06475878,
2.07466205, 2.13506091, 2.19684131, 2.18840002, 2.22549363, 2.2544315,
2.25016766, 2.23078869, 2.244535, 2.24623636, 2.23912727, 2.2332603,
2.22180407, 2.19782351, 2.19122552, 2.1979986, 2.2026715, 2.18556565,
2.21156322, 2.20427576, 2.01248457, 2.01498672, 2.07992587, 2.06649334,
2.10316678, 2.11983424, 2.11384414, 2.0999882, 2.10130175, 2.10248754,
2.11842908, 2.11943919, 2.12314517, 2.15262515, 2.14852965, 2.16262866,
2.18590052, 2.19826545, 2.20038122, 2.19520581, 2.16704028, 2.18576059,
2.19569977, 2.22224708, 2.16651948, 1.9163797, 1.91806316, 1.95904411,
1.95663159, 2.01705226, 2.02054195, 2.0011583, 2.03437224, 2.03622184,
2.03133644, 2.0292398, 2.03069759, 2.00138005, 1.999575, 2.02277824,
2.06875822, 2.10647889, 2.11158946, 2.11716815, 2.11669157, 2.14763479,
2.17621108, 2.16408565, 2.16169698, 2.17119194, 1.91857722, 1.9188262,
1.96916523, 2.03557084, 2.02602333, 2.07845905, 2.15744117, 2.17912481,
2.14413407, 2.08634945, 2.0351163, 2.10267432, 2.15056204, 2.15087381,
2.13945316, 2.13235535, 2.11800541, 2.14833682, 2.17478384, 2.22896256,
2.17882135, 2.17804796, 2.22742572, 2.20600859, 2.24609155, 1.96444,
1.99739099, 1.98004703, 2.01059648, 1.98134442, 1.9983325, 2.00765773,
2.00281312, 1.96384446, 2.01590373, 2.01470566, 2.02166225, 2.01091331,
2.02796294, 2.02510818, 2.03175207, 2.03926451, 2.07125608, 2.08738675,
2.08067196, 2.09836325, 2.08406268, 2.11228288, 2.10175578, 2.09960665,
1.79825368, 1.84424961, 1.8422962, 1.84501386, 1.89645772, 1.97089824,
2.00596021, 2.00739487, 2.01137258, 2.0573106, 2.04313934, 2.01249898,
1.99667797, 2.02848458, 2.04886857, 2.0328347, 2.02572171, 2.04442714,
2.04486143, 2.05378723, 2.10233331, 2.10286924, 2.11969794, 2.07068329,
2.06793445, 1.94773025, 1.99938651, 1.91805045, 2.02544526, 2.05149718,
2.10387707, 2.1194688, 2.10549876, 2.088232, 2.12552473, 2.14898223,
2.17079982, 2.17279059, 2.19155536, 2.19568417, 2.16844382, 2.12213957,
2.16577246, 2.13570785, 2.13727791, 2.19030651, 2.20077524, 2.24858647,
2.21293961, 2.15534971, 2.06599657, 2.06433063, 2.09393365, 1.99575745,
2.03275658, 2.02200093, 2.03820085, 1.98039773, 1.99744873, 2.00817107,
2.02797769, 2.00062084, 2.00187491, 2.02937674, 2.04829677, 2.0749142,
2.08798948, 2.10863845, 2.12580935, 2.14941716, 2.11917359, 2.1226655,
2.12849815, 2.11984379, 2.06546327, 1.96526199, 1.97894451, 1.97550962,
1.98814753, 1.94380738, 1.99756755, 2.03857606, 2.11212325, 2.16430789,
2.19113467, 2.13015896, 2.11974503, 2.12757095, 2.1308519, 2.09775573,
2.11103541, 2.11271397, 2.10938011, 2.09807714, 2.10552783, 2.07457352,
2.0503974, 2.00745645, 2.01445197, 2.00229298, 2.02427972, 2.03639245,
2.07021441, 2.07044711, 2.12891608, 2.15626618, 2.16842679, 2.15459067,
2.14098124, 2.12843814, 2.10707196, 2.10108846, 2.09007526, 2.07745257,
2.03338542, 2.03467636, 2.03742285, 2.07988244, 2.08790349, 2.13429524,
2.21920365, 2.16973959, 2.11097453, 2.13119681, 2.12758603, 2.0781601,
2.02978409, 1.96552161, 1.95204043, 1.96003388, 1.95768975, 1.97145463,
1.96160208, 1.93546182, 1.92319594, 2.00391039, 2.04312661, 2.00251702,
1.99624602, 1.97713051, 1.94983783, 1.93219069, 1.93614845, 1.89852462,
1.94618647, 1.93655539, 1.95125352, 1.99840771, 2.02804381, 1.98403337,
1.87448051, 1.86562259, 1.79616732, 1.82555601, 1.8242802, 1.87550773,
1.89667717, 1.95580767, 1.91976818, 1.95046227, 1.99003583, 1.99427449,
1.98743936, 1.9490081, 1.94297149, 1.91277804, 1.9427016, 1.92603583,
1.92370322, 1.97163637, 2.02726919, 1.97009689, 1.97674109, 1.95979152,
2.01410922, 2.07065668, 2.06215084, 1.98638394, 1.99447058, 2.00570049,
2.00528429, 2.02925574, 2.01330081, 1.99148652, 2.00879825, 2.01530925,
2.03336992, 2.06280088, 2.07446468, 2.06693072, 2.06464863, 2.03866489,
2.02143495, 2.0092433, 1.98599353, 1.96636384, 1.98470249, 2.00191189,
2.02532088, 2.02969919, 2.12375423, 2.15559139, 2.18130746, 2.13282315,
2.07879084, 2.06498021, 2.03948882, 2.06978477, 2.10670212, 2.10205094,
2.13933228, 2.14531999, 2.06071397, 2.06235004, 2.09525059, 2.12617385,
2.12474478, 2.13592724, 2.05131185, 2.02932282, 2.05422365, 2.07924548,
2.09741548, 2.08384252, 2.06269021, 1.98074586, 1.97578151, 1.98071137,
2.02403966, 2.00528662, 2.03028783, 2.04334718, 2.07899644, 2.06033204,
2.03412302, 2.03239169, 2.0109776, 2.02562896, 2.03564611, 2.04505425,
2.0668199, 2.04857197, 2.0631066, 2.08031601, 2.03939978, 2.00525827,
2.02894826, 2.07000497, 2.07185287, 2.11120107, 2.22228852, 2.15001973,
2.06302897, 2.1256218, 2.09179939, 2.09524607, 2.07805397, 2.11394936,
2.16405513, 2.17589366, 2.14955266, 2.19784012, 2.30981921, 2.28903345,
2.27329143, 2.28152685, 2.26663683, 2.19525793, 2.26234192, 2.21672359,
2.22386049, 2.19092079, 2.18431483, 2.13284084, 2.04470389, 1.89403285,
1.88348303, 1.89442381, 1.9459326, 1.95985837, 1.94709743, 1.97869564,
1.99796009, 2.06486447, 2.02849894, 1.94227211, 1.86633001, 1.90898192,
1.88619163, 1.90220315, 1.91467045, 1.92484327, 1.95541117, 1.91975938,
1.90635323, 1.84280673, 1.85191241, 1.83482548, 1.83487417, 1.83405924,
2.02784402, 2.01673209, 2.01987294, 2.03988661, 2.06173506, 2.0349244,
1.95198374, 1.96830374, 1.97588769, 1.95874526, 1.94012219, 1.92156355,
1.90905333, 1.91417868, 1.84643324, 1.86040243, 1.86396516, 1.88294675,
1.89310385, 1.89801289, 1.8938226, 1.90418974, 1.92366559, 1.9318815,
1.96978519, 1.97252341, 2.03110054, 2.02270669, 2.01118807, 2.01200817,
2.01451128, 2.0276892, 2.01838954, 2.03649853, 2.00509632, 2.05368283,
2.07831064, 2.09348626, 2.08614852, 2.08429022, 2.04840129, 2.08504099,
2.06248625, 2.04955494, 2.05052563, 2.04206533, 2.0520899, 2.03512599,
1.97732861, 1.92390177, 1.92007209, 1.94616805, 2.08681499, 2.13911898,
2.18023372, 2.22004975, 2.15530386, 2.14613934, 2.12546555, 2.09417525,
2.05113227, 2.08519709, 2.04964494, 2.07075967, 2.0754769, 2.1002889,
2.13660637, 2.12114707, 2.08784791, 2.06271584, 2.03811877, 2.04402346,
2.04037553, 2.07733474, 1.95900991, 1.967581, 1.92992361, 1.92728198,
1.92490761, 1.88701816, 1.90079392, 1.90322687, 1.97020584, 1.96243186,
1.97272279, 1.9823579, 1.96393352, 2.06468909, 2.07635163, 2.01408897,
1.95069212, 1.93941632, 1.99205906, 1.96160573, 1.98487012, 1.95603989,
1.90701582, 1.94070749, 1.90833913, 1.91662776, 1.95289895, 1.9198128,
1.92479934, 1.89673752, 1.83684425, 1.79811073, 1.84111557, 1.87252978,
1.87805505, 1.92102544, 1.8898569, 1.87952395, 1.87666275, 1.92142475,
1.91520422, 1.91212737, 1.95835091, 1.98652816, 2.09088036, 2.06711698,
2.09354672, 2.01813821, 2.05814201, 2.09318385, 1.99635585, 1.87907307,
1.82936738, 1.84797052, 1.83232265, 1.82912134, 1.7813495, 1.821151,
1.84766287, 1.87600505, 1.83481906, 1.79318706, 1.82208912, 1.88788691,
1.94500487, 1.90217666, 1.82163074, 1.85875722, 1.92802388, 1.91741144,
1.93446718, 1.97001129, 1.91995317, 1.91436968, 1.94168772, 1.90498884,
2.19126614, 2.22323373, 2.27100434, 2.21393571, 2.18121939, 2.15847989,
2.13452305, 2.10835569, 2.1035233, 2.08209749, 2.1019283, 2.1073962,
2.1869679, 2.1641296, 2.18502558, 2.10348342, 2.06049218, 2.02621266,
1.95245547, 1.98591827, 1.94945167, 1.9729954, 1.97398189, 1.97647364,
1.91929241, 1.94583536, 1.91343826, 1.82566738, 1.76207713, 1.78440439,
1.81619133, 1.82356971, 1.90249126, 1.8796667, 1.90538224, 1.98542281,
1.94776922, 1.92256979, 1.91870716, 1.90217651, 1.94779513, 1.94811117,
1.92514431, 2.00113703, 1.97333657, 2.0163128, 2.039161, 2.04045064,
2.01406726, 1.98850822, 2.18238296, 2.33353916, 2.32359995, 2.2749351,
2.20876868, 2.18504678, 2.26149999, 2.17579044, 2.1164222, 2.04729799,
1.96558566, 1.92858127, 1.88797296, 1.8698226, 1.85771666, 1.82575394,
1.87710219, 1.8956856, 1.98748182, 2.07886832, 2.093149, 2.10982134,
2.11958795, 2.10281587, 2.08039665, 1.95637122, 1.90702557, 1.92384291,
1.84512839, 1.79647353, 1.80334805, 1.86762114, 1.92175111, 1.95980244,
2.01247125, 2.01932429, 2.09012034, 2.08669235, 2.02540541, 2.05197978,
1.98364086, 1.90769049, 1.97192964, 1.97792112, 1.94519664, 1.95995856,
1.92788693, 1.93441921, 1.86700483, 1.80405787, 1.96057226, 1.97649544,
1.89650961, 2.01479215, 2.03764762, 2.04597911, 2.06861081, 2.07120542,
2.04378553, 2.07647472, 2.06469001, 2.01674968, 2.00503687, 1.97704574,
1.92559284, 1.88492752, 1.89150601, 1.95322767, 1.97079344, 2.01260695,
1.98191357, 1.91382985, 1.86674203, 1.83954008, 1.80295368, 2.20548722,
2.08373196, 2.16081883, 2.1526122, 2.1331629, 2.13438108, 2.14274784,
2.14488561, 2.16618468, 2.13409385, 2.18941072, 2.24717594, 2.2272674,
2.21523922, 2.17606562, 2.14523204, 2.11094264, 2.00762014, 1.97948472,
1.96182722, 1.88602828, 1.89945866, 1.94042039, 1.87606166, 1.79537809,
1.91342851, 2.09570797, 2.13619818, 2.1784422, 2.03687209, 2.06443573,
2.02357164, 2.05173221, 2.0276273, 2.04219492, 2.0305909, 2.04780194,
2.09640691, 2.13130985, 2.09827117, 2.05168284, 2.03757533, 2.06754063,
2.00512551, 2.03302941, 2.03215289, 2.10317545, 2.13066721, 2.10363648,
2.01090827, 1.96640331, 1.96466281, 1.96597088, 1.97226988, 1.952115,
2.06260093, 2.03060633, 2.08234938, 1.95731095, 1.94094549, 2.0019214,
1.97608595, 1.94254205, 1.93619566, 1.95853451, 2.07287375, 2.08837541,
2.09359646, 2.13451161, 2.13392649, 2.12610472, 2.06208516, 2.1163128,
2.06681278, 1.90590346, 2.25492313, 2.31885226, 2.29179041, 2.44399801,
2.32255178, 2.33632581, 2.38354198, 2.34945643, 2.26600141, 2.25515667,
2.2407142, 2.19650732, 2.16452496, 2.11233803, 2.15441665, 2.24372318,
2.28100396, 2.20501871, 2.17521401, 2.15743224, 2.11382431, 2.11185721,
2.09433544, 2.08619265, 1.97789861, 2.03418677, 1.99509998, 2.19859125,
2.21793341, 2.30821056, 2.19339511, 2.21032276, 2.19819669, 2.1318768,
2.08908101, 2.03341913, 1.98581284, 1.92489177, 1.9889494, 1.94954854,
1.95548859, 1.93164548, 1.93184767, 1.99063741, 1.98959811, 1.93189958,
1.94679885, 1.96508451, 1.94966907, 1.83861222, -0.23305461,
-0.15096467, -0.10611353, -0.17194493, -0.20531519, -0.29542135,
-0.37895759, -0.41493314, -0.49135475, -0.5095567, -0.56938051,
-0.52216505, -0.54486767, -0.60625356, -0.62758508, -0.65767829,
-0.64174941, -0.65483135, -0.72326259, -0.79387494, -0.79887231,
-0.90718758, -1.00816574, -1.08864366, -1.15699988, 0.00108896,
0.00442752, 0.01690173, 0.01257038, -0.0034261, -0.00864169,
-0.01261847, -0.01512258, -0.01848366, -0.01710873, -0.01794353,
-0.02706244, -0.02509902, -0.01381872, -0.02314283, -0.02910836,
-0.04321778, -0.06635619, -0.07759735, -0.07729976, -0.09016694,
-0.10094037, -0.10520091, -0.11924718, -0.13956625, -0.03168921,
-0.0303442, -0.01477643, -0.03438261, -0.00221643, 0.00352381,
-0.00512832, -0.00500535, -0.02445665, -0.01702445, -0.03514134,
-0.05016622, -0.06650315, -0.06323507, -0.07299205, -0.08196876,
-0.08260348, -0.08409545, -0.09063501, -0.09353066, -0.09352956,
-0.09216854, -0.1128016, -0.12621529, -0.13310524, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.04504892,
0.0282474, 0.02067033, 0.03387317, 0.04206304, 0.05939184, 0.07335757,
0.07929199, 0.09146795, 0.09041431, 0.09986163, 0.08667827, 0.08889176,
0.10029263, 0.1025437, 0.10540837, 0.10016818, 0.10063927, 0.11173848,
0.1273749, 0.12846472, 0.14661825, 0.16025556, 0.16643497, 0.17149396,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 1.09849179, 1.05290825, 1.02677361,
1.0688566, 1.09079971, 1.14814083, 1.21062389, 1.24904833, 1.32250558,
1.36611837, 1.42757248, 1.44010452, 1.4817093, 1.53957935, 1.57918355,
1.63091391, 1.65377665, 1.68830619, 1.76579085, 1.81223838, 1.83687871,
1.93366874, 2.05886213, 2.21155252, 2.33347186, 1.94947276, 1.95332184,
1.89207378, 1.88380187, 1.96568682, 2.00298604, 2.04756667, 2.06894324,
2.11632756, 2.1361556, 2.16192557, 2.25512671, 2.28024062, 2.25377365,
2.31472401, 2.35072215, 2.43242693, 2.57852729, 2.67939863, 2.69578879,
2.83477898, 2.93416093, 2.94185532, 3.02993242, 3.13017487, 3.40673105,
3.41978704, 3.17681851, 3.40972366, 2.99889826, 2.87309699, 2.9816951,
3.04086173, 3.30261085, 3.28755349, 3.62259608, 3.80997, 4.11155122,
3.90546381, 4.05969039, 4.16097953, 4.14773065, 4.16250418, 4.29570022,
4.39358371, 4.36087078, 4.34192277, 4.64135609, 4.85800733, 4.86004072,
4.02209982, 3.99995578, 3.95207686, 3.931041, 3.86384417, 3.81505646,
3.91445029, 3.97647915, 3.99709983, 3.96531105, 4.05045738, 4.16297397,
4.14889029, 4.12597022, 4.16295039, 4.2794916, 4.37807099, 4.41017364,
4.4481595, 4.42921674, 4.49032892, 4.53594446, 4.45436188, 4.45394717,
4.46145701, 5.55345771, 5.65142744, 5.42351628, 5.3350631, 5.14266118,
5.17607173, 5.19048009, 5.04176441, 5.06890858, 5.15526968, 5.09922832,
5.09569334, 4.90895647, 5.14305079, 5.22047324, 5.16193676, 5.17225576,
5.17227554, 5.25644348, 5.27215725, 5.22791702, 5.22511943, 5.22053041,
5.21927843, 5.17934776, 6.11253022, 5.9013048, 5.73342704, 5.77723285,
5.83473457, 5.81912597, 5.7154308, 5.75466583, 5.62372257, 5.71496591,
5.86006551, 5.85499078, 5.90362858, 5.8816789, 5.89045401, 5.87321914,
5.80615545, 5.82436481, 5.80874484, 5.81601157, 5.71945809, 5.6568381,
5.62807216, 5.42860535, 5.47455019, 7.32044207, 7.43964795, 7.40948903,
7.33243725, 7.29685896, 7.21927801, 7.21949708, 6.95737761, 7.14619825,
7.20420818, 7.01418465, 7.09326806, 7.14509655, 7.23583722, 7.26675695,
7.0906221, 7.11335001, 7.12126224, 6.94589392, 6.90090471, 6.83100282,
6.8014525, 6.6149837, 6.57777796, 6.33744959, 7.58558894, 7.88260547,
8.13592809, 8.4474976, 8.43493215, 8.43288751, 8.83861031, 9.26570441,
9.13002288, 9.31181518, 9.43736616, 9.26853422, 8.9962984, 9.01562589,
8.94158737, 8.81057459, 8.65451255, 8.46556736, 8.14346749, 7.95867739,
7.86574804, 7.78182739, 7.49670216, 7.49727826, 7.13197529, 9.15231011,
9.14911395, 9.71492628, 9.50289336, 9.74452254, 9.77892436, 9.614284,
9.37231814, 9.26957429, 9.1347259, 9.17728332, 9.08987259, 9.03287776,
9.16504301, 9.02100857, 8.97815298, 9.07198442, 9.06067942, 8.93549467,
8.76316693, 8.36109318, 8.35199208, 8.27407472, 8.30862285, 7.58255943,
9.13759734, 9.17211552, 9.52459312, 9.4163824, 9.95373894, 9.91318324,
9.62324917, 9.83874792, 9.74723831, 9.56683933, 9.45546065, 9.37670649,
9.0306574, 8.90224955, 8.95169831, 9.23340784, 9.44447347, 9.39679396,
9.3177912, 9.16551866, 9.21982263, 9.29984689, 8.99186486, 8.69587246,
8.36835868, 10.07497237, 10.0467029, 10.45644253, 11.10706791,
10.89544026, 11.3383397, 12.06025845, 12.20864907, 11.64830461,
10.90192363, 10.19290619, 10.7528423, 11.14025623, 10.97856592,
10.71561697, 10.49425156, 10.17193509, 10.30022638, 10.37062653,
10.81004069, 10.14554086, 9.94116167, 10.14983611, 9.69646677,
9.59773214, 11.53879914, 11.92276025, 11.68989516, 11.97801352,
11.58399326, 11.65220487, 11.63739024, 11.44776001, 10.77530849,
11.2036368, 11.03420836, 10.97949408, 10.74048354, 10.78162966,
10.59440717, 10.4287136, 10.35184906, 10.49479632, 10.52332734,
10.29145789, 10.33588441, 9.99287115, 10.03136263, 9.64879834,
9.17540191, 10.41684137, 10.99627097, 10.94946411, 10.86712854,
11.33782181, 12.19301524, 12.44290967, 12.32404115, 12.21525101,
12.6942321, 12.35386194, 11.83258893, 11.47517661, 11.6453919,
11.74304504, 11.44780129, 11.24303922, 11.28869335, 11.12177845,
11.0127526, 11.30901959, 11.02285983, 10.93118131, 10.08068307,
9.59833171, 13.27196461, 13.93520385, 12.60250809, 13.93586138,
14.1984088, 14.84315578, 14.95648757, 14.56987653, 14.04746683,
14.41641144, 14.5743948, 14.7145144, 14.5228628, 14.58667619,
14.48666336, 13.9176524, 13.07427044, 13.45347527, 12.81646448,
12.53400805, 12.88579717, 12.70765504, 12.99384328, 12.22882972,
10.96237775, 15.68923616, 15.50536283, 15.91962029, 14.2414129,
14.57903247, 14.26872531, 14.28928745, 13.28726144, 13.37505205,
13.35487918, 13.40608732, 12.88349512, 12.6936633, 12.87114928,
12.93671118, 13.06890945, 13.05474466, 13.12802116, 13.09697678,
13.19483161, 12.56119109, 12.32911489, 12.03550775, 11.62458359,
10.55645975, 15.57140748, 15.7232532, 15.57923085, 15.65237089,
14.73756599, 15.40071295, 15.79747847, 16.71357386, 17.28071878,
17.48562078, 16.1902909, 15.66843316, 15.55655921, 15.38479121,
14.69471849, 14.61281391, 14.40562323, 14.18991387, 13.80092022,
13.59115037, 12.93224874, 12.3455457, 11.51104575, 11.28260494,
10.51466866, 17.23630313, 17.23519069, 17.71726539, 17.54292865,
18.34415945, 18.63460302, 18.62861382, 18.19736301, 17.74023231,
17.22814616, 16.63536449, 16.26280448, 15.82988108, 15.34048362,
14.48338354, 14.23182539, 14.04594655, 14.4328954, 14.28970519,
14.61372092, 15.54088652, 14.48955561, 13.39310413, 13.33256681,
12.52746798, 19.69296256, 18.61179137, 17.15483811, 16.67283111,
16.56862497, 16.26806208, 16.24061434, 15.91017304, 15.25047508,
14.77945683, 15.8353284, 16.30653639, 15.47313935, 15.13206056,
14.69047106, 14.09261883, 13.62388699, 13.50372176, 12.7082535,
13.09271663, 12.68817255, 12.56591716, 12.85783878, 12.74619676,
11.51481175, 16.36432152, 16.14606463, 14.88091376, 15.14488752,
14.98714545, 15.69134777, 15.76390752, 16.54192576, 15.61146984,
15.95673519, 16.40769678, 16.22236577, 15.95292502, 15.15563059,
14.90368818, 14.22942291, 14.44096208, 13.97185104, 13.62435381,
14.03510966, 14.59955301, 13.47886945, 13.22151131, 12.54167423,
12.56106152, 21.47237913, 21.2352932, 19.3441609, 19.21034185,
19.18673868, 18.83190784, 19.104989, 18.55556393, 17.82899414,
17.87359619, 17.72505246, 17.77480216, 18.01779907, 17.92069137,
17.63584256, 17.28177298, 16.64284413, 16.05934545, 15.57317263,
14.91688639, 14.30566861, 14.23179665, 14.08480644, 14.01090492,
13.35644448, 23.67146935, 24.27092447, 24.66145223, 23.25916098,
21.66596321, 20.93682891, 20.02517352, 20.31490543, 20.76857362,
20.4775121, 20.92784725, 20.74948429, 18.85495208, 18.56872189,
18.89998633, 19.15371036, 18.83855149, 18.77330812, 16.98920825,
16.20500619, 16.2722879, 16.27392038, 16.1073115, 15.32576854,
14.19009583, 21.02915371, 20.76630019, 20.57734142, 21.297083,
20.63771253, 20.8538528, 20.88373783, 21.38937743, 20.67432754,
19.91488799, 19.62919845, 18.95740222, 18.97359036, 18.84588988,
18.71355471, 18.77241314, 18.02758125, 18.0489204, 18.17466075,
17.13791005, 16.23901114, 16.307268, 16.53612929, 15.96660918,
15.6898414, 28.39914107, 26.40301866, 24.01401655, 25.22479577,
23.93901732, 23.71024697, 22.84229165, 23.25742773, 24.01002798,
23.99902869, 23.1216598, 23.70982256, 25.86650867, 24.99244484,
24.1638005, 23.96773512, 23.2654575, 21.41582378, 22.31863274,
20.96350912, 20.6974953, 19.59662537, 18.86238246, 17.32520399,
14.95063697, 21.90099212, 21.49094497, 21.39972146, 22.27646047,
22.31234522, 21.79937823, 22.24239439, 22.31843949, 23.55365875,
22.45337304, 20.25195258, 18.20192038, 18.64779833, 17.76541017,
17.8087906, 17.70472325, 17.57267846, 17.89956485, 16.86125843,
16.34162737, 15.00004586, 14.81750654, 14.17101083, 13.70083718,
12.90346573, 25.72546182, 25.23030685, 24.90712058, 25.08004595,
25.33393981, 24.07467369, 21.66817917, 21.66255981, 21.43837171,
20.81289794, 20.16912318, 19.45100486, 18.8622512, 18.6013851,
16.93523007, 16.86343597, 16.63992117, 16.70485644, 16.60422083,
16.37797995, 16.04734456, 15.89012609, 15.79228569, 15.32325057,
15.04418676, 24.84029809, 26.06085214, 25.58049006, 24.75786679,
24.53834102, 24.28393746, 24.42131939, 23.80002436, 23.98836932,
22.85032844, 23.59750615, 23.72713219, 23.80881939, 23.26515337,
22.81203792, 21.67606732, 22.16410561, 21.32521592, 20.66834698,
20.25261789, 19.66014492, 19.43326002, 18.49639131, 16.77585824,
14.90131942, 24.32267933, 24.82449247, 28.27775885, 29.47244439,
30.33475609, 31.08808619, 28.8008456, 28.03225153, 26.87458083,
25.63803249, 24.12599799, 24.55363665, 23.2633233, 23.35618541,
23.20660123, 23.28407697, 23.87883144, 23.16110568, 22.00464588,
21.04409585, 20.02837621, 19.52558449, 18.97580383, 18.96854111,
15.80205275, 26.66843417, 25.50937387, 25.05086362, 24.59554896,
23.21981025, 23.24207299, 23.01997951, 24.38251645, 23.82716977,
23.68900698, 23.44399867, 22.63736828, 24.65528907, 24.5315411,
22.6133646, 20.78412258, 20.20944258, 20.91594955, 19.82270958,
19.86572045, 18.84274886, 17.4597972, 17.56318184, 16.36160486,
15.50435646, 27.48022361, 26.27547623, 26.10496301, 25.1400972,
23.13049443, 21.8297779, 22.51930106, 23.02251554, 22.787372,
23.52147717, 22.37710616, 21.682157, 21.37460646, 21.98436557,
21.57606547, 20.98255495, 21.60536163, 21.83882266, 23.7696165,
22.74394494, 22.88464091, 20.65500179, 20.74284722, 20.725084,
17.78846638, 26.14947046, 24.4251645, 24.62078482, 23.88389491,
23.342859, 21.76424137, 22.31912452, 22.58787399, 22.98303565,
21.56483141, 20.19754452, 20.61223143, 21.91580398, 23.08132686,
21.75417005, 19.44300858, 19.80733373, 20.99273178, 20.3329017,
20.260418, 20.52024952, 18.94783892, 18.28656786, 18.24283542,
16.41599763, 37.56899046, 38.10592674, 38.97924216, 36.3685573,
34.79657793, 33.44933125, 32.05234605, 30.64150877, 30.0150918,
29.02872127, 29.14413623, 28.67295361, 30.67045225, 29.48578611,
29.68656179, 27.02787481, 25.45779042, 24.02828039, 21.69023315,
21.93455608, 20.64491319, 20.65528274, 20.12778183, 19.42370496,
17.06800649, 30.26677171, 28.89095397, 25.71641718, 23.54435106,
23.75195155, 24.15344906, 23.91660531, 25.74227123, 24.83847494,
25.18784806, 27.1921108, 25.71862758, 24.5910891, 24.11634532,
23.35875248, 24.08315449, 23.61379419, 22.71714667, 24.10808384,
23.05163722, 23.48865831, 23.48456264, 22.84170841, 21.31116813,
19.45210594, 39.90512505, 45.05829287, 44.02875581, 41.41182299,
38.02969954, 36.49544717, 38.51046407, 35.03866061, 32.59139536,
29.93426771, 27.03964078, 25.44125261, 23.91656982, 23.11702715,
22.44215914, 21.34977148, 22.17288461, 22.35696787, 24.10821807,
26.03738052, 25.81376868, 25.49361263, 24.93914031, 23.59447506,
21.66134722, 31.82535939, 29.84986086, 30.17458168, 27.34527667,
25.37065953, 24.95318041, 26.47381045, 27.54904842, 28.37338777,
29.57937538, 29.3584292, 30.84581849, 30.3732451, 28.04703903,
28.35502035, 25.75756328, 23.29418855, 24.51496213, 24.19213119,
22.77041004, 22.57927514, 21.30629347, 20.80122429, 18.60703417,
16.21771016, 33.29591918, 33.30609342, 30.24042023, 33.75161701,
33.81096354, 33.59249416, 33.82575759, 33.29774247, 31.84313893,
32.36983772, 31.5683067, 29.58058382, 28.80105874, 27.51697672,
25.63488856, 23.9537687, 23.59156224, 24.73432925, 24.7057589,
25.29659713, 24.08482791, 21.82461724, 20.23435131, 18.86918337,
16.86181653, 44.21603393, 38.79814299, 41.46568178, 40.5757449,
39.24300379, 38.62014886, 38.24654076, 37.70244534, 37.83927778,
35.85396602, 37.07005599, 38.45867575, 37.22688035, 36.13681955,
34.3239804, 32.74187691, 31.11656016, 27.57273246, 26.19711022,
25.18177188, 22.539881, 22.30562166, 22.50219467, 20.13698844,
17.14090448, 33.92656713, 40.69978339, 41.80584778, 42.97891027,
36.96603292, 37.36793388, 35.36845208, 35.5153091, 34.04146182,
33.97083008, 32.8626471, 32.81195849, 33.90392101, 34.56505936,
32.97591948, 30.82829904, 29.7022359, 30.11935378, 27.64578509,
27.84059951, 27.07967397, 28.28600413, 28.21982531, 26.36549518,
22.41389926, 37.06849436, 36.41201746, 36.03565867, 35.63181039,
34.06569345, 37.25172975, 35.50227142, 36.7399646, 31.82821957,
30.73351779, 32.26836741, 30.88129669, 29.48857036, 28.46758703,
28.69140828, 31.78221623, 31.70359431, 31.26545442, 31.64928266,
30.71897143, 29.96019601, 27.27237503, 27.84745068, 25.43005149,
20.14300842, 50.36120334, 52.56760837, 50.57647864, 56.68147362,
50.43194435, 50.27468663, 51.47110435, 49.16346034, 44.69900888,
43.35319229, 41.9028465, 39.36892212, 37.45857347, 34.91677832,
35.7830707, 38.22662915, 38.8071843, 35.50480782, 33.69587622,
32.52104008, 30.21509511, 29.31144567, 27.94356093, 26.6694055,
22.3562109, 41.73932758, 39.83587399, 48.00936055, 48.29100165,
51.42852512, 45.44466115, 45.12462852, 43.7992456, 40.36788466,
38.11820554, 35.31053606, 32.9328031, 30.20146789, 31.57679627,
29.7925605, 29.46725472, 28.16372811, 27.78158751, 29.06637797,
28.30820708, 25.96148743, 25.60649553, 25.13452455, 23.71425256,
19.90271749), .Dim = c(1000, 5), .Dimnames = list(c("1", "2",
"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14",
"15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
"26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36",
"37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47",
"48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58",
"59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69",
"70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80",
"81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91",
"92", "93", "94", "95", "96", "97", "98", "99", "100", "101",
"102", "103", "104", "105", "106", "107", "108", "109", "110",
"111", "112", "113", "114", "115", "116", "117", "118", "119",
"120", "121", "122", "123", "124", "125", "126", "127", "128",
"129", "130", "131", "132", "133", "134", "135", "136", "137",
"138", "139", "140", "141", "142", "143", "144", "145", "146",
"147", "148", "149", "150", "151", "152", "153", "154", "155",
"156", "157", "158", "159", "160", "161", "162", "163", "164",
"165", "166", "167", "168", "169", "170", "171", "172", "173",
"174", "175", "176", "177", "178", "179", "180", "181", "182",
"183", "184", "185", "186", "187", "188", "189", "190", "191",
"192", "193", "194", "195", "196", "197", "198", "199", "200",
"201", "202", "203", "204", "205", "206", "207", "208", "209",
"210", "211", "212", "213", "214", "215", "216", "217", "218",
"219", "220", "221", "222", "223", "224", "225", "226", "227",
"228", "229", "230", "231", "232", "233", "234", "235", "236",
"237", "238", "239", "240", "241", "242", "243", "244", "245",
"246", "247", "248", "249", "250", "251", "252", "253", "254",
"255", "256", "257", "258", "259", "260", "261", "262", "263",
"264", "265", "266", "267", "268", "269", "270", "271", "272",
"273", "274", "275", "276", "277", "278", "279", "280", "281",
"282", "283", "284", "285", "286", "287", "288", "289", "290",
"291", "292", "293", "294", "295", "296", "297", "298", "299",
"300", "301", "302", "303", "304", "305", "306", "307", "308",
"309", "310", "311", "312", "313", "314", "315", "316", "317",
"318", "319", "320", "321", "322", "323", "324", "325", "326",
"327", "328", "329", "330", "331", "332", "333", "334", "335",
"336", "337", "338", "339", "340", "341", "342", "343", "344",
"345", "346", "347", "348", "349", "350", "351", "352", "353",
"354", "355", "356", "357", "358", "359", "360", "361", "362",
"363", "364", "365", "366", "367", "368", "369", "370", "371",
"372", "373", "374", "375", "376", "377", "378", "379", "380",
"381", "382", "383", "384", "385", "386", "387", "388", "389",
"390", "391", "392", "393", "394", "395", "396", "397", "398",
"399", "400", "401", "402", "403", "404", "405", "406", "407",
"408", "409", "410", "411", "412", "413", "414", "415", "416",
"417", "418", "419", "420", "421", "422", "423", "424", "425",
"426", "427", "428", "429", "430", "431", "432", "433", "434",
"435", "436", "437", "438", "439", "440", "441", "442", "443",
"444", "445", "446", "447", "448", "449", "450", "451", "452",
"453", "454", "455", "456", "457", "458", "459", "460", "461",
"462", "463", "464", "465", "466", "467", "468", "469", "470",
"471", "472", "473", "474", "475", "476", "477", "478", "479",
"480", "481", "482", "483", "484", "485", "486", "487", "488",
"489", "490", "491", "492", "493", "494", "495", "496", "497",
"498", "499", "500", "501", "502", "503", "504", "505", "506",
"507", "508", "509", "510", "511", "512", "513", "514", "515",
"516", "517", "518", "519", "520", "521", "522", "523", "524",
"525", "526", "527", "528", "529", "530", "531", "532", "533",
"534", "535", "536", "537", "538", "539", "540", "541", "542",
"543", "544", "545", "546", "547", "548", "549", "550", "551",
"552", "553", "554", "555", "556", "557", "558", "559", "560",
"561", "562", "563", "564", "565", "566", "567", "568", "569",
"570", "571", "572", "573", "574", "575", "576", "577", "578",
"579", "580", "581", "582", "583", "584", "585", "586", "587",
"588", "589", "590", "591", "592", "593", "594", "595", "596",
"597", "598", "599", "600", "601", "602", "603", "604", "605",
"606", "607", "608", "609", "610", "611", "612", "613", "614",
"615", "616", "617", "618", "619", "620", "621", "622", "623",
"624", "625", "626", "627", "628", "629", "630", "631", "632",
"633", "634", "635", "636", "637", "638", "639", "640", "641",
"642", "643", "644", "645", "646", "647", "648", "649", "650",
"651", "652", "653", "654", "655", "656", "657", "658", "659",
"660", "661", "662", "663", "664", "665", "666", "667", "668",
"669", "670", "671", "672", "673", "674", "675", "676", "677",
"678", "679", "680", "681", "682", "683", "684", "685", "686",
"687", "688", "689", "690", "691", "692", "693", "694", "695",
"696", "697", "698", "699", "700", "701", "702", "703", "704",
"705", "706", "707", "708", "709", "710", "711", "712", "713",
"714", "715", "716", "717", "718", "719", "720", "721", "722",
"723", "724", "725", "726", "727", "728", "729", "730", "731",
"732", "733", "734", "735", "736", "737", "738", "739", "740",
"741", "742", "743", "744", "745", "746", "747", "748", "749",
"750", "751", "752", "753", "754", "755", "756", "757", "758",
"759", "760", "761", "762", "763", "764", "765", "766", "767",
"768", "769", "770", "771", "772", "773", "774", "775", "776",
"777", "778", "779", "780", "781", "782", "783", "784", "785",
"786", "787", "788", "789", "790", "791", "792", "793", "794",
"795", "796", "797", "798", "799", "800", "801", "802", "803",
"804", "805", "806", "807", "808", "809", "810", "811", "812",
"813", "814", "815", "816", "817", "818", "819", "820", "821",
"822", "823", "824", "825", "826", "827", "828", "829", "830",
"831", "832", "833", "834", "835", "836", "837", "838", "839",
"840", "841", "842", "843", "844", "845", "846", "847", "848",
"849", "850", "851", "852", "853", "854", "855", "856", "857",
"858", "859", "860", "861", "862", "863", "864", "865", "866",
"867", "868", "869", "870", "871", "872", "873", "874", "875",
"876", "877", "878", "879", "880", "881", "882", "883", "884",
"885", "886", "887", "888", "889", "890", "891", "892", "893",
"894", "895", "896", "897", "898", "899", "900", "901", "902",
"903", "904", "905", "906", "907", "908", "909", "910", "911",
"912", "913", "914", "915", "916", "917", "918", "919", "920",
"921", "922", "923", "924", "925", "926", "927", "928", "929",
"930", "931", "932", "933", "934", "935", "936", "937", "938",
"939", "940", "941", "942", "943", "944", "945", "946", "947",
"948", "949", "950", "951", "952", "953", "954", "955", "956",
"957", "958", "959", "960", "961", "962", "963", "964", "965",
"966", "967", "968", "969", "970", "971", "972", "973", "974",
"975", "976", "977", "978", "979", "980", "981", "982", "983",
"984", "985", "986", "987", "988", "989", "990", "991", "992",
"993", "994", "995", "996", "997", "998", "999", "1000"), c("V1",
"V2", "V3", "V4", "V5")))

