% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit.R
\name{enrich_terminals}
\alias{enrich_terminals}
\title{Enrich flattened parse table}
\usage{
enrich_terminals(flattened_pd, use_raw_indention = FALSE)
}
\arguments{
\item{flattened_pd}{A nested parse table that was turned into a flat parse
table using \code{\link[=extract_terminals]{extract_terminals()}}.}

\item{use_raw_indention}{Boolean indicating whether or not the raw indention
should be used.}
}
\description{
Enriches a flattened parse table with terminals only. In particular, it is
possible to compute the exact position a token will have (line and column)
when it will be serialized.
}
\details{
Since we have only terminal tokens now, the line on which a token starts we
also be the line on which it ends. We call \code{line1} the line on which the
token starts. \code{line1} has the same meaning as \code{line1} that can be found in a
flat parse table (see \code{\link[=tokenize]{tokenize()}}), just that the \code{line1} created by
\code{enrich_terminals()} is the updated version of the former \code{line1}. The same
applies for \code{col1} and \code{col2}. Note that this function does remove the
columns \code{indent} and \code{spaces.} All information of the former is stored in
\code{lag_spaces} now. The later was removed because it is redundant after adding
the column \code{lag_spaces}, which is more convenient to work with, in particular
when serializing the parse table.
}
\keyword{internal}
