% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token-create.R
\name{create_tokens}
\alias{create_tokens}
\title{Create a terminal token}
\usage{
create_tokens(
  tokens,
  texts,
  lag_newlines = 0L,
  spaces = 0L,
  pos_ids,
  token_before = NA,
  token_after = NA,
  indention_ref_pos_ids = NA,
  indents = 0L,
  terminal = TRUE,
  child = NULL,
  stylerignore = FALSE,
  block = NA,
  is_cached = FALSE
)
}
\arguments{
\item{tokens}{Character vector with tokens to create.}

\item{texts}{Character vector with texts of the token to create.}

\item{lag_newlines}{Character vector with lag_newlines corresponding to the
tokens.}

\item{spaces}{Character vector with spaces corresponding to the tokens.}

\item{pos_ids}{Character vector with positional id corresponding to the
tokens.}

\item{token_before}{Character vector corresponding to the columns
\code{token_before}.}

\item{token_after}{Character vector corresponding to the columns
\code{token_after}.}

\item{indention_ref_pos_ids}{Character vector with indention ref ids
corresponding to the tokens.}

\item{indents}{Vector with indents corresponding to the tokens.}

\item{terminal}{Boolean vector indicating whether a token is a terminal or
not.}

\item{child}{The children of the tokens.}

\item{stylerignore}{Boolean to indicate if the line should be ignored by
styler.}

\item{block}{The block (of caching) to which the token belongs. An integer.}

\item{is_cached}{Whether the token is cached already.}
}
\description{
Creates a terminal token represented as (a row of) a parse table.
}
\seealso{
Other token creators: 
\code{\link{create_pos_ids}()},
\code{\link{validate_new_pos_ids}()}
}
\concept{token creators}
\keyword{internal}
