% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui-styling.R
\name{style_text}
\alias{style_text}
\title{Style a string}
\usage{
style_text(
  text,
  ...,
  style = tidyverse_style,
  transformers = style(...),
  include_roxygen_examples = TRUE,
  base_indention = 0
)
}
\arguments{
\item{text}{A character vector with text to style.}

\item{...}{Arguments passed on to the \code{style} function.}

\item{style}{A function that creates a style guide to use, by default
\code{\link[=tidyverse_style]{tidyverse_style()}} (without the parentheses). Not used
further except to construct the argument \code{transformers}. See
\code{\link[=style_guides]{style_guides()}} for details.}

\item{transformers}{A set of transformer functions. This argument is most
conveniently constructed via the \code{style} argument and \code{...}. See
'Examples'.}

\item{include_roxygen_examples}{Whether or not to style code in roxygen
examples.}

\item{base_indention}{Integer scalar indicating by how many spaces the whole
output text should be indented. Note that this is not the same as splitting
by line and add a \code{base_indention} spaces before the code in the case
multi-line strings are present. See 'Examples'.}
}
\description{
Styles a character vector. Each element of the character vector corresponds
to one line of code.
}
\examples{
style_text("call( 1)")
style_text("1    + 1", strict = FALSE)

# the following is identical (because of ... and defaults)
# but the first is most convenient:
style_text("a<-3++1", strict = TRUE)
style_text("a<-3++1", style = tidyverse_style, strict = TRUE)
style_text("a<-3++1", transformers = tidyverse_style(strict = TRUE))

# more invasive scopes include less invasive scopes by default
style_text("a\%>\%b", scope = "spaces")
style_text("a\%>\%b; a", scope = "line_breaks")
style_text("a\%>\%b; a", scope = "tokens")

# opt out with I() to only style specific levels
style_text("a\%>\%b; a", scope = I("tokens"))
}
\seealso{
Other stylers: 
\code{\link{style_dir}()},
\code{\link{style_file}()},
\code{\link{style_pkg}()},
\code{\link{styler_addins}}
}
\concept{stylers}
