% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reindent.R
\name{set_regex_indention}
\alias{set_regex_indention}
\title{Set indention of tokens that match regex}
\usage{
set_regex_indention(
  flattened_pd,
  pattern,
  target_indention = 0L,
  comments_only = TRUE
)
}
\arguments{
\item{flattened_pd}{A flattened parse table.}

\item{pattern}{A character  with regular expressions to match against the
token in \code{flattened_pd}.}

\item{target_indention}{The desired level of indention of the tokens that
match \code{pattern}.}

\item{comments_only}{Boolean indicating whether only comments should be
checked or all tokens.}
}
\value{
A flattened parse table with indention set to \code{target_indention} for
the tokens that match \code{regex.}
}
\description{
Force the level of indention of tokens whose text matches a regular
expression pattern to be a certain amount of spaces. The rule
is only active for the first tokens on a line.
}
\keyword{internal}
