% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_select_vocab.R
\name{stylest_select_vocab}
\alias{stylest_select_vocab}
\title{Select vocabulary using cross-validated out-of-sample prediction}
\usage{
stylest_select_vocab(
  x,
  speaker,
  filter = NULL,
  smooth = 0.5,
  nfold = 5,
  cutoff_pcts = c(50, 60, 70, 80, 90, 99),
  cutoffs_term_weights = NULL,
  fill_method = "value",
  fill_weight = 1,
  weight_varname = "mean_distance"
)
}
\arguments{
\item{x}{Corpus as text vector. May be a \code{corpus_frame} object}

\item{speaker}{Vector of speaker labels. Should be the same length as
\code{x}}

\item{filter}{if not \code{NULL}, a \code{corpus} text_filter}

\item{smooth}{value for smoothing. Defaults to 0.5}

\item{nfold}{Number of folds for cross-validation. Defaults to 5}

\item{cutoff_pcts}{Vector of cutoff percentages to test. Defaults to
\code{c(50, 60, 70, 80, 90, 99)}}

\item{cutoffs_term_weights}{Named list of dataframes of term weights,
where the names correspond to the \code{cutoff_pcts}. Each dataframe 
should have one column $word and a second column $weight_varname 
containing the weight for the word.
See the vignette for details.}

\item{fill_method}{if \code{"value"} (default), \code{fill_weight} is
used to fill any terms with \code{NA} weight. If \code{"mean"}, the
mean term_weight should be used as the fill value}

\item{fill_weight}{numeric value to fill in as weight for any term
which does not have a weight specified in \code{term_weights}, 
default=\code{1.0}}

\item{weight_varname}{Name of the column in each term_weights dataframe containing 
the weights, default=\code{"mean_distance"}}
}
\value{
List of: best cutoff percent with the best speaker classification
  rate; cutoff percentages that were tested; matrix of the mean percentage of
  incorrectly identified speakers for each cutoff percent and fold; and the
  number of folds for cross-validation
}
\description{
Selects optimal vocabulary quantile(s) for model fitting using performance on
predicting out-of-sampletexts.
}
\examples{
\dontrun{
data(novels_excerpts)
stylest_select_vocab(novels_excerpts$text, novels_excerpts$author, cutoff_pcts = c(50, 90))
}
  
}
