#' (ii) Visualization
#'
#' Start the Shiny based interactive visualization tool to show the subgroup results
#' generated by subscreencalc.
#' See and explore all subgroup results at one glance. Pick and chose a specific
#' subgroup, the level of combinations or a certain factor with its combinations.
#' Switch easily between different endpoint/target variables.
#'
#' @param scresults SubScreenResult object with results from a subscreencalc call
#' @param variable_importance add description
#' @param host host name or IP address for Shiny display
#' @param port  port number for Shiny display
#' @param NiceNumbers list of numbers used for a 'nice' scale
#' @keywords subgroup analysis visualization
#' @import shiny
#' @import shinyWidgets
#' @export subscreenshow

subscreenshow <- function (scresults,
                            variable_importance = NULL,
                            host = NULL,
                            port = NULL,
                            NiceNumbers = c(1, 1.5, 2, 4, 5, 6, 8, 10))
  {

  ####.. warnings ####
  if (!requireNamespace("shiny", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package shiny to be installed")
    stop()
  }
  if (!requireNamespace("shinyjs", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package shinyjs to be installed")
    stop()
  }
  if (!requireNamespace("bsplus", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package bsplus to be installed")
    stop()
  }
  if (!requireNamespace("jsonlite", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package jsonlite to be installed")
    stop()
  }
  if (!requireNamespace("colourpicker", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package colourpicker to be installed")
    stop()
  }
  if (!requireNamespace("DT", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package DT to be installed")
    stop()
  }
  if (!requireNamespace("dplyr", quietly = TRUE)) {
    cat("Error: subscreenshow requires the package dplyr to be installed")
    stop()
  }

  appDir <- system.file("shiny-app", "subscreen",  "app.R", package = "subscreen")
  if (appDir == "") {
    stop("Could not find Shiny app directory. Please try to re-install `subscreen`.", call. = FALSE)
  }

  apppars <- list(scresults=scresults, variable_importance=variable_importance, NiceNumbers=NiceNumbers)

  ui <- server <- NULL

  source(appDir, local=TRUE)
  server_env <- environment(server)

  server_env$apppars <- apppars

  app <- shiny::shinyApp(ui, server)

  shiny::runApp(app, display.mode = "normal", host=host, port=port)

}

