% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscreenvi.R
\name{subscreenvi}
\alias{subscreenvi}
\title{(iii) Determine variable importance}
\usage{
subscreenvi(data, y, cens = NULL, x = NULL, trt = NULL, ...)
}
\arguments{
\item{data}{The data frame containing the dependent and independent variables.}

\item{y}{The name of the column in \code{data} that contains the dependent variable.}

\item{cens}{The name of the column in \code{data} that contains the censoring variable, if \code{y} is an event time (default=NULL).}

\item{x}{Vector that contains the names of the columns in \code{data} with the independent variables (default=NULL, i.e. all remaining variables)}

\item{trt}{The name of the column in \code{data} that contains the treatment variable (default=NULL).}

\item{...}{additional arguments to be passed to function \code{rfsrc}}
}
\value{
A list containing ordered data frames with the variable importances
  (one for each treatment level, one with the ranking variability between the
  treatment levels and one with the total results)
}
\description{
Determine variable importance for continuous, categorical or right-censored
survival endpoints (overall and per treatment group) using random forests
}
\examples{
\dontrun{
require(survival)
data(pbc, package="survival")
# generate categorical versions of some of the baseline covariates
pbc$ageg[!is.na(pbc$age)]        <-
  ifelse(pbc$age[!is.na(pbc$age)]          <= median(pbc$age,     na.rm=TRUE), "Low", "High")
pbc$albuming[!is.na(pbc$albumin)]<-
  ifelse(pbc$albumin[!is.na(pbc$albumin)]  <= median(pbc$albumin, na.rm=TRUE), "Low", "High")
pbc$phosg[!is.na(pbc$alk.phos)]  <-
  ifelse(pbc$alk.phos[!is.na(pbc$alk.phos)]<= median(pbc$alk.phos,na.rm=TRUE), "Low", "High")
pbc$astg[!is.na(pbc$ast)]        <-
  ifelse(pbc$ast[!is.na(pbc$ast)]          <= median(pbc$ast,     na.rm=TRUE), "Low", "High")
pbc$bilig[!is.na(pbc$bili)]      <-
  ifelse(pbc$bili[!is.na(pbc$bili)]        <= median(pbc$bili,    na.rm=TRUE), "Low", "High")
pbc$cholg[!is.na(pbc$chol)]      <-
  ifelse(pbc$chol[!is.na(pbc$chol)]        <= median(pbc$chol,    na.rm=TRUE), "Low", "High")
pbc$copperg[!is.na(pbc$copper)]  <-
  ifelse(pbc$copper[!is.na(pbc$copper)]    <= median(pbc$copper,  na.rm=TRUE), "Low", "High")
pbc$ageg[is.na(pbc$age)]         <- "No Data"
pbc$albuming[is.na(pbc$albumin)] <- "No Data"
pbc$phosg[is.na(pbc$alk.phos)]   <- "No Data"
pbc$astg[is.na(pbc$ast)]         <- "No Data"
pbc$bilig[is.na(pbc$bili)]       <- "No Data"
pbc$cholg[is.na(pbc$chol)]       <- "No Data"
pbc$copperg[is.na(pbc$copper)]   <- "No Data"
#eliminate treatment NAs
pbcdat <- pbc[!is.na(pbc$trt), ]
pbcdat$status <- ifelse(pbcdat$status==0,0,1)
importance <- subscreenvi(data=pbcdat, y='time', cens='status',
 trt='trt', x=c("ageg", "sex", "bilig", "cholg", "copperg"))
}
}
\keyword{importance}
\keyword{variable}
