% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_HDDStream.R
\name{DSC_HDDStream}
\alias{DSC_HDDStream}
\title{Density-based Projected Clustering over High-Dimensional Data}
\usage{
DSC_HDDStream(epsilonN = 0.1, beta = 0.5, mu = 10, lambda = 0.5,
  initPoints = 2000, pi = 30, kappa = 10, delta = 0.001, offline = 2,
  speed = 100)
}
\arguments{
\item{epsilonN}{radius of each neighborhood}

\item{beta}{control the effect of mu}

\item{mu}{minimum number of points desired to be in a microcluster}

\item{lambda}{decaying parameter}

\item{initPoints}{number of points to use for initialization}

\item{pi}{number of maximal subspace dimensionality}

\item{kappa}{parameter to define preference weighted vector}

\item{delta}{defines the threshold for the variance}

\item{offline}{offline multiplier for epsilon}

\item{speed}{number of incoming points per time unit}
}
\description{
This function creates a DSC object that represents an instance of the
HDDStream algorithm and can be used for stream clustering.
}
\details{
HDDStream is an algorithm for the density-based projected clustering of
high-dimensional data streams.

The algorithm is initialized by buffering the first \emph{initPoints} points that arrive and then
applying the \emph{PreDeCon} algorithm over these points.

Then, Microclusters are maintained online by adding each new point to its
closest core Microcluster iff doing so does not increase the projected radius of this 
microcluster beyond \emph{epsilonN}. If a point can not be added to a core 
microcluster, an attempt will be made to add it to an outlier microcluster, 
with the same criterion as for core microclusters. If these attempts both 
fail, the point will start its own microcluster. Microclusters are aged
according to the decaying parameter \emph{lambda}.

Macroclustering is performed on-demand, using the \emph{PreDeCon} algorithm.
}
\examples{
dsc <- DSC_HDDStream()
dsd <- DSD_RandomRBFSubspaceGeneratorEvents()
update(dsc,dsd,1000)
}

