/**
 * [SubspaceClusteringSetupTab.java] for Subspace MOA
 * 
 * Subtab "Setup" of "SubspaceClustering" tab.
 * (AlgoPanel + EvalPanel)
 * 
 * @author Yunsu Kim
 * 		   based on the implementation of Timm Jansen
 * Data Management and Data Exploration Group, RWTH Aachen University
 */

package moa.gui.subspaceclusteringtab;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

import moa.clusterers.AbstractClusterer;
import moa.clusterers.AbstractSubspaceClusterer;
import moa.clusterers.macrosubspace.MacroSubspaceClusterer;
import moa.evaluation.SubspaceMeasureCollection;
import moa.gui.FileExtensionFilter;
import moa.gui.TextViewerPanel;
import moa.streams.clustering.SubspaceClusteringStream;

public class SubspaceClusteringSetupTab extends JPanel {
    
	private static final long serialVersionUID = 1L;
	
	private SubspaceClusteringTabPanel subspaceClusteringTab;
    private String lastfile;

    /** Creates new form ClusteringSetupTab */
    public SubspaceClusteringSetupTab() {
        initComponents();
        subspaceClusteringAlgoPanel.renderAlgoPanel();
    }

    /** Getters **/
    
    public AbstractClusterer getMicroClusterer1() {
        return subspaceClusteringAlgoPanel.getMicroClusterer1();
    }
    
    public MacroSubspaceClusterer getMacroClusterer1() {
        return subspaceClusteringAlgoPanel.getMacroClusterer1();
    }
    
    public AbstractSubspaceClusterer getOneStopClusterer1() {
        return subspaceClusteringAlgoPanel.getOneStopClusterer1();
    }

    public AbstractClusterer getMicroClusterer2() {
        return subspaceClusteringAlgoPanel.getMicroClusterer2();
    }
    
    public MacroSubspaceClusterer getMacroClusterer2() {
        return subspaceClusteringAlgoPanel.getMacroClusterer2();
    }
    
    public AbstractSubspaceClusterer getOneStopClusterer2() {
        return subspaceClusteringAlgoPanel.getOneStopClusterer2();
    }

    public SubspaceClusteringStream getStream() {
        return subspaceClusteringAlgoPanel.getStream();
    }

    public SubspaceMeasureCollection[] getMeasures() {
        return subspaceClusteringEvalPanel.getSelectedMeasures();
    }
    
    public boolean getSettingType1() {
    	return subspaceClusteringAlgoPanel.getSettingType1();
    }
    
    public boolean getSettingType2() {
    	return subspaceClusteringAlgoPanel.getSettingType2();
    }
    
    public boolean getSettingChecked1() {
    	return subspaceClusteringAlgoPanel.getSettingChecked1();
    }
    
    public boolean getSettingChecked2() {
    	return subspaceClusteringAlgoPanel.getSettingChecked2();
    }

    public TextViewerPanel getLogPanel() {
        return logPanel;
    }
    
    

    public void addButtonActionListener(ActionListener l) {
        buttonWeka.addActionListener(l);
        buttonWeka.setActionCommand("weka export");
        buttonExport.addActionListener(l);
        buttonExport.setActionCommand("csv export");
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        subspaceClusteringAlgoPanel = new moa.gui.subspaceclusteringtab.SubspaceClusteringAlgoPanel();
        subspaceClusteringEvalPanel = new moa.gui.subspaceclusteringtab.SubspaceClusteringEvalPanel();
        buttonStart = new JButton();
        buttonStop = new JButton();
        buttonExport = new JButton();
        buttonWeka = new JButton();
        buttonExportStream = new JButton();
        buttonImportSettings = new JButton();
        buttonExportSettings = new JButton();
        logPanel = new moa.gui.TextViewerPanel();

        setLayout(new java.awt.GridBagLayout());

        subspaceClusteringAlgoPanel.setMinimumSize(new java.awt.Dimension(520, 300));
        subspaceClusteringAlgoPanel.setPanelTitle("Clustering Algorithm Settings");
        subspaceClusteringAlgoPanel.setPreferredSize(new java.awt.Dimension(560, 300));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(subspaceClusteringAlgoPanel, gridBagConstraints);
        
        subspaceClusteringEvalPanel.setMinimumSize(new java.awt.Dimension(220, 300));
        subspaceClusteringEvalPanel.setPanelTitle("Evaluation Measures");
        subspaceClusteringEvalPanel.setPreferredSize(new java.awt.Dimension(220, 300));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(subspaceClusteringEvalPanel, gridBagConstraints);

        buttonStart.setText("Start");
        buttonStart.setPreferredSize(new java.awt.Dimension(80, 23));
        buttonStart.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                buttonStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(buttonStart, gridBagConstraints);

        buttonStop.setText("Stop");
        buttonStop.setEnabled(false);
        buttonStop.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                buttonStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(buttonStop, gridBagConstraints);
        
        buttonExportStream.setText("Export stream");
        buttonExportStream.setEnabled(true);
        buttonExportStream.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
            	buttonExportStreamActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(buttonExportStream, gridBagConstraints);

        /*buttonExport.setText("Export CSV");
        buttonExport.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(buttonExport, gridBagConstraints);

        buttonWeka.setText("Weka Explorer");
        buttonWeka.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(buttonWeka, gridBagConstraints);

        buttonImportSettings.setText("Import settings");
        buttonImportSettings.setEnabled(false);
        buttonImportSettings.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                buttonImportSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 75, 4, 4);
        add(buttonImportSettings, gridBagConstraints);

        buttonExportSettings.setText("Export settings");
        buttonExportSettings.setEnabled(false);
        buttonExportSettings.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                buttonExportSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(buttonExportSettings, gridBagConstraints);*/
        
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(logPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void buttonImportSettingsActionPerformed(ActionEvent evt) {//GEN-FIRST:event_buttonImportSettingsActionPerformed

        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addChoosableFileFilter(new FileExtensionFilter("txt"));
        if(lastfile!=null)
            fileChooser.setSelectedFile(new File(lastfile));
        if (fileChooser.showOpenDialog(this.buttonImportSettings) == JFileChooser.APPROVE_OPTION) {
            lastfile = fileChooser.getSelectedFile().getPath();
            loadOptionsFromFile(fileChooser.getSelectedFile().getPath());
        }
    }//GEN-LAST:event_buttonImportSettingsActionPerformed

    private void buttonExportSettingsActionPerformed(ActionEvent evt) {//GEN-FIRST:event_buttonExportSettingsActionPerformed
        StringBuffer sb = new StringBuffer();
        sb.append(subspaceClusteringAlgoPanel.getStreamValueAsCLIString()+"\n");
        sb.append(subspaceClusteringAlgoPanel.getMicroAlgorithm1ValueAsCLIString()+"\n");
        sb.append(subspaceClusteringAlgoPanel.getMacroAlgorithm1ValueAsCLIString()+"\n");
        sb.append(subspaceClusteringAlgoPanel.getMicroAlgorithm2ValueAsCLIString()+"\n");
        sb.append(subspaceClusteringAlgoPanel.getMacroAlgorithm2ValueAsCLIString()+"\n");
        
        System.out.println(sb);
        logPanel.addText(sb.toString());
        
    }//GEN-LAST:event_buttonExportSettingsActionPerformed

    private void buttonStartActionPerformed(ActionEvent evt) {//GEN-FIRST:event_buttonStartActionPerformed
        toggle(true);
    }//GEN-LAST:event_buttonStartActionPerformed

    private void buttonStopActionPerformed(ActionEvent evt) {//GEN-FIRST:event_buttonStopActionPerformed
        stop(true);
    }//GEN-LAST:event_buttonStopActionPerformed
    
    private void buttonExportStreamActionPerformed(ActionEvent evt) {//GEN-FIRST:event_buttonStopActionPerformed
        // TODO Export stream
    }


    private void loadOptionsFromFile(String filepath) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filepath));

            String stream0 = in.readLine();
            subspaceClusteringAlgoPanel.setStreamValueAsCLIString(stream0);

            String microAlgo0 = in.readLine();
            subspaceClusteringAlgoPanel.setMicroAlgorithm0ValueAsCLIString(microAlgo0);
            
            String macroAlgo0 = in.readLine();
            subspaceClusteringAlgoPanel.setMacroAlgorithm0ValueAsCLIString(macroAlgo0);

            String microAlgo1 = in.readLine();
            subspaceClusteringAlgoPanel.setMicroAlgorithm1ValueAsCLIString(microAlgo1);

            String macroAlgo1 = in.readLine();
            subspaceClusteringAlgoPanel.setMacroAlgorithm1ValueAsCLIString(macroAlgo1);

            System.out.println("Loading settings from " + filepath);
            logPanel.addText("Loading settings from " + filepath);

        } catch (Exception e) {
            System.out.println("Bad option file:" + e.getMessage());
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JButton buttonExport;
    private JButton buttonExportStream;
    private JButton buttonExportSettings;
    private JButton buttonImportSettings;
    private JButton buttonStart;
    private JButton buttonStop;
    private JButton buttonWeka;
    private moa.gui.subspaceclusteringtab.SubspaceClusteringAlgoPanel subspaceClusteringAlgoPanel;
    private moa.gui.subspaceclusteringtab.SubspaceClusteringEvalPanel subspaceClusteringEvalPanel;
    private moa.gui.TextViewerPanel logPanel;
    // End of variables declaration//GEN-END:variables

    void setClusteringTab(SubspaceClusteringTabPanel subspaceClusteringTab) {
        this.subspaceClusteringTab = subspaceClusteringTab;
    }

    public void toggleRunMode(){
        toggle(false);
    }

    public void stopRun(){
        stop(false);
    }

    private void toggle(boolean internal) {
        setStateConfigButtons(false);
        if (buttonStart.getText().equals("Pause")) {
            buttonStart.setText("Resume");
            buttonWeka.setEnabled(true);
            buttonExport.setEnabled(true);
        } else {
            buttonStart.setText("Pause");
            buttonWeka.setEnabled(false);
            buttonExport.setEnabled(false);
        }

        //push event forward to the cluster tab
        if (internal)
            subspaceClusteringTab.toggle();
    }


    public void stop(boolean internal) {
        buttonStart.setEnabled(true);
        buttonStart.setText("Start");
        buttonStop.setEnabled(false);
        buttonWeka.setEnabled(false);
        buttonExport.setEnabled(false);
        setStateConfigButtons(true);

        //push event forward to the cluster tab
        if(internal)
            subspaceClusteringTab.stop();
    }

    private void setStateConfigButtons(boolean state) {
        buttonStop.setEnabled(!state);
        buttonExportSettings.setEnabled(state);
        buttonImportSettings.setEnabled(state);
    }


}
