% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli_cusum.R
\name{bernoulli_cusum}
\alias{bernoulli_cusum}
\title{Risk-adjusted Bernoulli CUSUM}
\usage{
bernoulli_cusum(data, followup, glmmod, theta, p0, p1, h, stoptime, assist,
  twosided = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} containing the following named columns for each subject:
\describe{
\item{\code{entrytime}:}{time of entry into study (numeric);}
\item{\code{survtime}:}{time from entry until event (numeric);}
\item{\code{censorid}:}{censoring indicator (0 = right censored, 1 = observed)
(integer);}
} and optionally additional covariates used for risk-adjustment.}

\item{followup}{The value of the follow-up time to be used to determine event time.
Event time will be equal to \code{entrytime + followup} for each subject.}

\item{glmmod}{Generalized linear regression model used for risk-adjustment as produced by
the function \code{\link[stats:glm]{glm()}}. Suggested: \cr
\code{glm(as.formula("(survtime <= followup) & (censorid == 1) ~ covariates"), data = data)}. \cr
Alternatively, a list containing the following elements:
\describe{
\item{\code{formula}:}{a \code{\link[stats:formula]{formula()}} in the form \code{~ covariates};}
\item{\code{coefficients}:}{a named vector specifying risk adjustment coefficients
for covariates. Names must be the same as in \code{formula} and colnames of \code{data}.}
}}

\item{theta}{The \eqn{\theta}{\theta} value used to specify the odds ratio
\eqn{e^\theta}{e^\theta} under the alternative hypothesis.
If \eqn{\theta >= 0}{\theta >= 0}, the chart will try to detect an increase
in hazard ratio (upper one-sided). If \eqn{\theta < 0}{\theta < 0},
the chart will look for a decrease in hazard ratio (lower one-sided).
Note that \deqn{p_1 = \frac{p_0 e^\theta}{1-p_0 +p_0 e^\theta}.}{p1 = (p0 * e^\theta)/(1-p0+p0 * e^\theta).}}

\item{p0}{The baseline failure probability at \code{entrytime + followup} for individuals.}

\item{p1}{The alternative hypothesis failure probability at \code{entrytime + followup} for individuals.}

\item{h}{(optional): Control limit to be used for the procedure.}

\item{stoptime}{(optional): Time after which the value of the chart should no longer be determined.}

\item{assist}{(optional): Output of the function \code{\link[success:parameter_assist]{parameter_assist()}}}

\item{twosided}{(optional): Should a two-sided Bernoulli CUSUM be constructed?
Default is \code{FALSE}.}
}
\value{
An object of class \code{bercusum} containing:
\itemize{
\item \code{CUSUM}: A \code{data.frame} containing the following named columns:
\describe{
\item{\code{time}:}{times at which chart is constructed;}
\item{\code{value}:}{value of the chart at corresponding times;}
\item{\code{numobs}:}{number of observations at corresponding times.}
}
\item \code{call}: the call used to obtain output;
\item \code{glmmod}: coefficients of the \code{\link[stats:glm]{glm()}} used
for risk-adjustment, if specified;
\item \code{stopind}: indicator for whether the chart was stopped by the
control limit.
}
}
\description{
This function can be used to construct a risk-adjusted Bernoulli
CUSUM chart for survival data.
It requires the specification of one of the following combinations of parameters
as arguments to the function:
\itemize{
\item \code{glmmod} & \code{theta}
\item \code{p0} & \code{theta}
\item \code{p0} & \code{p1}
}
}
\details{
The Bernoulli CUSUM chart is given by
\deqn{S_n = \max(0, S_{n-1} + W_n),}{S_n = max(0, S_{n-1} + W_n),} where
\deqn{W_n = X_n \ln \left( \frac{p_1 (1-p_0)}{p_0(1-p_1)}  \right) + \ln \left( \frac{1-p_1}{1-p_0} \right)}{W_n = X_n ln((p_1 * (1-p_0))/(p_0 * (1-p_1))) + ln((1-p_1)/(1-p_0))}
and \eqn{X_n}{X_n} is the outcome of the \eqn{n}{n}-th (chronological) subject in the data.
Instead of the standard practice of displaying patient numbering on the
x-axis, the time of outcome is displayed.
}
\examples{
#We consider patient outcomes 100 days after their entry into the study.
followup <- 100
#Determine a risk-adjustment model using a generalized linear model.
#Outcome (failure within 100 days) is regressed on the available covariates:
exprfitber <- as.formula("(survtime <= followup) & (censorid == 1)~ age + sex + BMI")
glmmodber <- glm(exprfitber, data = surgerydat, family = binomial(link = "logit"))
#Construct the Bernoulli CUSUM on the 1st hospital in the data set.
bercus <- bernoulli_cusum(data = subset(surgerydat, unit == 1), glmmod = glmmodber,
 followup = followup, theta = log(2))
#Plot the Bernoulli CUSUM
plot(bercus)
}
\seealso{
\code{\link[success]{plot.bercusum}}, \code{\link[success]{runlength.bercusum}}

Other quality control charts: 
\code{\link{bk_cusum}()},
\code{\link{cgr_cusum}()},
\code{\link{funnel_plot}()}
}
\author{
Daniel Gomon
}
\concept{quality control charts}
