% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weib_hazards.R
\name{weib_hazards}
\alias{weib_hazards}
\alias{haz_weib}
\alias{chaz_weib}
\alias{inv_chaz_weib}
\title{Weibull hazard, cumulative hazard and inverse cumulative hazard}
\usage{
haz_weib(t, lambda, theta, mu = log(1))

chaz_weib(t, lambda, theta, mu = log(1))

inv_chaz_weib(t, lambda, theta, mu = log(1))
}
\arguments{
\item{t}{time of evaluation.}

\item{lambda}{shape parameter \eqn{\lambda}{\lambda}}

\item{theta}{scale parameter \eqn{\theta}{\theta}}

\item{mu}{(optional) true excess hazard rate \eqn{\mu}{\mu}.}
}
\value{
Value of specified function at time \eqn{t}{t}.
}
\description{
Functions which return the hazard, cumulative
hazard and inverse cumulative hazard at time t for a Weibull distribution
with shape parameter \eqn{\lambda}{\lambda}, scale parameter \eqn{\theta}{\theta}
and true hazard ratio \eqn{\mu}{\mu}.
}
\details{
The hazard function of a Weibull distribution is given by:
\deqn{h(t| \lambda, \theta, \mu) = \frac{\lambda}{\theta} \left(\frac{t}{\theta}  \right)^{\lambda -1} e^\mu}{h(t|\lambda, \theta, \mu) = \lambda/\theta (t/\theta)^(\lambda -1) exp(\mu)}
The cumulative hazard (with true hazard ratio \eqn{\mu}{\mu}) is given by:
\deqn{H(t| \lambda, \theta, \mu) = \left( \frac{t}{\theta} \right)^{\lambda} e^\mu}{H(\lambda, \theta, \mu) = ( t/\theta )^{\lambda} exp(\mu)}
The inverse cumulative hazard (with true hazard ratio \eqn{\mu}{\mu}) by:
\deqn{H^{-1}(t| \lambda, \theta, \mu) = \theta \left( \frac{t}{e^\mu}  \right)^{1/\lambda}}{H^(-1)(t| \lambda, \theta, \mu) = \theta (t/e^\mu)^{1/\lambda}}
}
