% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_SuperLearner_regression.R
\name{binarySuperLearner}
\alias{binarySuperLearner}
\title{Function to generate imputations using SuperLearner for data with a binary outcome.}
\usage{
binarySuperLearner(y, x, wy, SL.library, ...)
}
\arguments{
\item{y}{Vector of observed values of the variable to be imputed.}

\item{x}{Numeric matrix of variables to be used as predictors in SuperLearner methods with rows corresponding to values in Y.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value indicates
locations in \code{y} for which imputations are created.}

\item{SL.library}{Either a character vector of prediction algorithms or a list containing character vectors. A list of functions included in the SuperLearner package can be found with SuperLearner::listWrappers().}

\item{...}{Further arguments passed to SuperLearner.}
}
\value{
Binary Vector of randomly drawn imputed values.
}
\description{
Function to generate imputations using SuperLearner for data with a binary outcome.
}
