% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-formula.R
\name{frm_outcome}
\alias{frm_outcome}
\alias{frm_terms}
\alias{frm_interaction_terms}
\alias{frm_fixed_terms}
\alias{frm_random_terms}
\alias{frm_vars}
\alias{frm_random_vars}
\alias{frm_fixed_vars}
\title{Extracting from formulae}
\usage{
frm_outcome(frm)

frm_terms(frm)

frm_interaction_terms(frm)

frm_fixed_terms(frm)

frm_random_terms(frm)

frm_vars(frm)

frm_random_vars(frm)

frm_fixed_vars(frm)
}
\arguments{
\item{frm}{The formula to extract values from}
}
\value{
The function name and parameters should be descriptive enough (see Description above).
The extracted parts are always strings.
}
\description{
These tools extracting parts from formulae. The only function that extracts from the left-hand
side is \code{frm_outcome}. The rest only extract from the right-hand side. The word \code{term} is used to
denote functions that extract full terms from the formula, whereas \code{var} denotes functions that
extract the variables the formula uses. For example, the formula \code{y ~ a * b + (1 | group)} has
terms \code{a}, \code{b}, \code{a:b}, and \code{1 | group}. The same formula has variables \code{a}, \code{b}, and \code{group}.
}
\details{
These tools are ONLY tested against models and formulae that are explicitly supported. See the
README and test cases for more information.
}
\seealso{
formula_building formula_expansion
}
\keyword{internal}
