% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.chain_sim}
\alias{.chain_sim}
\title{Simulate transmission chains using a stochastic branching process}
\usage{
.chain_sim(
  n,
  offspring,
  stat = c("size", "length"),
  stat_threshold = Inf,
  generation_time,
  tf = Inf,
  ...
)
}
\arguments{
\item{n}{Number of simulations to run.}

\item{offspring}{Offspring distribution: a character string corresponding to
the R distribution function (e.g., "pois" for Poisson, where
\code{\link[=rpois]{rpois()}} is the R function to generate Poisson random numbers).}

\item{stat}{String; Statistic to calculate. Can be one of:
\itemize{
\item "size": the total number of offspring.
\item "length": the total number of ancestors.
}}

\item{stat_threshold}{A size or length above which the simulation results
should be set to \code{Inf}. Defaults to \code{Inf}, resulting in no results
ever set to \code{Inf}}

\item{generation_time}{The generation time generator function; the name of a
user-defined named or anonymous function with only one argument \code{n},
representing the number of generation times to generate.}

\item{tf}{End time (if \code{generation_time} interval is given).}

\item{...}{Parameters of the offspring distribution as required by R.}
}
\value{
A \verb{<data.frame>} with columns \code{n} (simulation ID), \code{id} (a unique
ID within each simulation for each individual element of the chain),
\code{ancestor} (the ID of the ancestor of each element), and \code{generation}. A
\code{time} column is also appended if the generation_time interval is supplied to
\code{serial}.
}
\description{
Code modified from the \code{bpmodels::chain_sim()} function.
The function \code{chain_sim()} function from \pkg{bpmodels} is reused with
permission and licensed under MIT as is \pkg{bpmodels}.
\pkg{bpmodels} is not on CRAN and is retired.
}
\author{
Sebastian Funk, James M. Azam, Joshua W. Lambert
}
\keyword{internal}
