% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skew.ratio.R
\name{skew.ratio}
\alias{skew.ratio}
\title{Skewness Ratio}
\usage{
skew.ratio(x)
}
\arguments{
\item{x}{numeric object containing the values for a variable.}
}
\value{
Skewness ratio of \code{x}.
}
\description{
Returns the ratio of a distribution's skewness value to its standard error of skewness.
}
\details{
\code{skew.ratio} relies on the functions \code{\link[sur]{skew}} and \code{\link[sur]{se.skew}} to compute the skewness value and standard error of skewness, respectively.
}
\examples{
# skew ratio computed two ways
skew.ratio(NELS$achmat12)
skew(NELS$achmat12) / se.skew(NELS$achmat12)
}
\seealso{
\code{\link[sur]{skew}}, \code{\link[sur]{se.skew}}
}
