% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.intELtest.R
\name{print.intELtest}
\alias{print.intELtest}
\title{Print an intELtest object}
\usage{
\method{print}{intELtest}(x, digits = max(3L, getOption("digits") - 3L), quiet = FALSE, ...)
}
\arguments{
\item{x}{the result of a call to the \code{intELtest} function}

\item{digits}{significant digits to print, the default value is \code{max(3L, getOption("digits") - 3L)}}

\item{quiet}{a logical indicating whether to reduce the amount of output or not, the default value is \code{FALSE}}

\item{...}{for future method}
}
\description{
Print the integrated EL statistics and the p-value of the test.
}
\examples{
library(survELtest)
result = intELtest(survival::Surv(hepatitis$time, hepatitis$censor) ~ hepatitis$group)
print(result)

## OUTPUT:
## Call:
## intELtest(formula = survival::Surv(hepatitis$time, hepatitis$censor) ~ 
##     hepatitis$group)
## 
## Two-sided integrated EL test statistic = 1.42, p = 0.007
}
\seealso{
\code{\link{hepatitis}}, \code{\link{intELtest}}, \code{\link{summary.intELtest}}
}
