% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillUpStr.R
\name{fillUpStr}
\alias{fillUpStr}
\title{Adds characters to the head or tail of each element of the character vector.}
\usage{
fillUpStr(strVec, howManyToFill, where, fill)
}
\arguments{
\item{strVec}{A vector of character strings.}

\item{howManyToFill}{The target number of characters in each element of \code{strVec}. If \code{howManyToFill} is \code{NULL} or less than the number of characters in the longest element of \code{strVec}, then the number of characters in the longest element is used.}

\item{where}{Where to place the characters: at the beginning of each element (\code{'head'}, the default) or at the end of each element (\code{'tail'})}

\item{fill}{What character to add. The default is a blank space.}
}
\value{
A character string with equal number of characters in each element.
}
\description{
Adds characters to the head or tail of each element of the character vector to make all elements the same length.
}
\details{
The function adds characters to the head or tail of each element of the character vector, \code{strVec}, so that all elements have the same number of characters. \code{NA} values are returned unchanged. If \code{howManyToFill} is \code{NULL} or less than the number of characters in the longest element of \code{strVec}, then the number of characters in the longest element is used.
}
\examples{
fillUpStr(c("A", "aaa", NA, "bb", "4.5"), where="tail", howManyToFill = 4, fill = "_")
fillUpStr(c("A", "aaa", NA, "bb", "4.5"), where="tail", howManyToFill = -3, fill = "_")
fillUpStr(c("A", "aaa", NA, "bb", "4.5"), where="head", howManyToFill = -3, fill = "*")

}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{character}
\keyword{vector}
