% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.survdnn.R
\name{predict.survdnn}
\alias{predict.survdnn}
\title{Predict from a survdnn Model}
\usage{
\method{predict}{survdnn}(object, newdata, times = NULL, type = c("survival", "lp", "risk"), ...)
}
\arguments{
\item{object}{An object of class `"survdnn"` returned by [survdnn()].}

\item{newdata}{A data frame of new observations to predict on.}

\item{times}{Numeric vector of time points at which to compute survival or risk probabilities.
Required if `type = "survival"` or `type = "risk"`.}

\item{type}{Character string specifying the type of prediction to return:
\describe{
  \item{"lp"}{Linear predictor (log-risk score; higher implies worse prognosis).}
  \item{"survival"}{Predicted survival probabilities at each value of `times`.}
  \item{"risk"}{Cumulative risk (1 - survival) at a single time point.}
}}

\item{...}{Currently ignored (for future extensions).}
}
\value{
A numeric vector (if `type = "lp"` or `"risk"`), or a data frame (if `type = "survival"`)
  with one row per observation and one column per `times`.
}
\description{
Generate predictions from a fitted `survdnn` model for new data. Supports linear predictors,
survival probabilities at specified time points, or cumulative risk estimates.
}
\examples{
library(survival)
data(veteran, package = "survival")

# Fit survdnn with Cox loss
mod <- survdnn(Surv(time, status) ~ age + karno + celltype, data = veteran,
               loss = "cox", epochs = 50, verbose = FALSE)

# Linear predictor (log-risk)
predict(mod, newdata = veteran, type = "lp")[1:5]

# Survival probabilities at selected times
predict(mod, newdata = veteran, type = "survival", times = c(30, 90, 180))[1:5, ]

# Cumulative risk at 180 days
predict(mod, newdata = veteran, type = "risk", times = 180)[1:5]
}
