% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix_mean}
\alias{matrix_mean}
\title{Matrix Mean Plot}
\usage{
matrix_mean(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A likert-style ggplot displaying means and standard errors. The plot
is flipped for better readability, and if grouping is specified, different
colors represent distinct subgroups.
}
\description{
This function creates a likert-style plot showing means and standard errors
for a specified numeric variable, \code{question}. Optionally, the plot can be
grouped by another variable, \code{group_by}, and subgroups can be excluded. If
survey weights are provided, the counts are adjusted accordingly. The plot is
flipped for better readability in likert-style format.
}
\examples{
#basic plot
  matrix_mean(berlinbears, dplyr::starts_with('p_'))

 #with grouping and weights
   matrix_mean(berlinbears, dplyr::starts_with('p_'), group_by = species,
   subgroups_to_exclude = 'panda bear', weights = weights, na.rm = TRUE )



}
\seealso{
Other matrix questions: 
\code{\link{matrix_freq}()},
\code{\link{matrix_likert}()},
\code{\link{matrix_table}()}
}
\concept{matrix questions}
