% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/ipf.r
\name{ipf_step}
\alias{ipf_step}
\alias{ipf_step_ref}
\alias{ipf_step_f}
\alias{combine_factors}
\title{Perform one step of iterative proportional updating}
\usage{
ipf_step_ref(w, classes, targets)

ipf_step(w, classes, targets)

ipf_step_f(w, classes, targets)

combine_factors(dat, targets)
}
\arguments{
\item{w}{a numeric vector of weights. All entries should be positive.}

\item{classes}{a factor variable. Must have the same length as \code{w}.}

\item{targets}{key figure to target with the ipu scheme. A numeric verctor of the same length as \code{levels(classes)}.
This can also be a \code{table} produced by \code{xtabs}. See examples.}

\item{dat}{a \code{data.frame} containing the factor variables to be combined.}
}
\description{
C++ routines to invoke a single iteration of the Iterative proportional updating (IPU) scheme. Targets and classes
are assumed to be one dimensional in the \code{ipf_step} functions. \code{combine_factors} aggregates several vectors of
type factor into a single one to allow multidimensional ipu-steps. See examples.
}
\details{
\code{ipf_step} returns the adjusted weights. \code{ipf_step_ref} does the same, but updates \code{w} by reference rather than
returning. \code{ipf_step_f} returns a multiplicator: adjusted weights divided by unadjusted weights. \code{combine_factors} is
designed to make \code{ipf_step} work with contingency tables produced by \link{xtabs}.
}
\examples{

############# one-dimensional ipu ##############

## create random data
nobs <- 10
classLabels <- letters[1:3]
dat = data.frame(
  weight = exp(rnorm(nobs)),
  household = factor(sample(classLabels, nobs, replace = TRUE))
)
dat

## create targets (same lenght as classLabels!)
targets <- 3:5

## calculate weights
new_weight <- ipf_step(dat$weight, dat$household, targets)
cbind(dat, new_weight)

## check solution
xtabs(new_weight ~ dat$household)

## calculate weights "by reference"
ipf_step_ref(dat$weight, dat$household, targets)
dat

############# multidimensional ipu ##############

## load data
factors <- c("time", "sex", "smoker", "day")
tips <- data.frame(sex=c("Female","Male","Male"), day=c("Sun","Mon","Tue"),
time=c("Dinner","Lunch","Lunch"), smoker=c("No","Yes","No"))
tips <- tips[factors]

## combine factors
con <- xtabs(~., tips)
cf <- combine_factors(tips, con)
cbind(tips, cf)[sample(nrow(tips), 10, replace = TRUE),]

## adjust weights
weight <- rnorm(nrow(tips)) + 5
adjusted_weight <- ipf_step(weight, cf, con)

## check outputs
con2 <- xtabs(adjusted_weight ~ ., data = tips)
sum((con - con2)^2)

}
