% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kishFactor.R
\name{kishFactor}
\alias{kishFactor}
\title{Kish Factor}
\usage{
kishFactor(w, na.rm = FALSE)
}
\arguments{
\item{w}{a numeric vector with weights}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}
}
\value{
The function will return the the kish factor
}
\description{
Compute the design effect due to unequal weighting.
}
\details{
The factor is computed acording to 'Weighting for Unequal P_i', Leslie Kish, Journal of Official Statistics, Vol. 8. No. 2, 1992
\deqn{ deff = \sqrt n \sum_j w_j^2 / (\sum_j w_j)^2}
}
\examples{
kishFactor(rep(1,10))
kishFactor(rlnorm(10))
}
\author{
Alexander Kowarik
}
