% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_opts.R
\name{set_opts}
\alias{set_opts}
\alias{show_opts}
\title{Set certain options}
\usage{
set_opts(
  mode = NULL,
  count = NULL,
  lpe = NULL,
  drop_na = NULL,
  max_levels = NULL,
  csv = NULL,
  output = NULL
)

show_opts()
}
\arguments{
\item{mode}{\code{"general"} or \code{"NCHS"}. See below for details.}

\item{count}{round counts to the nearest: integer (\code{"int"}) or one thousand (\code{"1k"})}

\item{lpe}{identify low-precision estimates?}

\item{drop_na}{drop missing values (\code{NA})? Categorical variables only.}

\item{max_levels}{a categorical variable can have at most this many levels. Used to avoid printing huge tables.}

\item{csv}{name of a CSV file or \code{""} to turn off CSV output.}

\item{output}{package to use for printing. One of \code{"huxtable"}, \code{"gt"}, or \code{"kableExtra"}.
For the last two, be sure that this package is installed. \code{"auto"} (default) = automatically
select \code{huxtable} for screen, \code{gt} for HTML, or \code{kableExtra} for PDF (LaTeX).}
}
\value{
(Nothing.)
}
\description{
\code{set_opts()} sets certain options. To view these options, use \code{show_opts()}.
For more advanced control and detailed customization, experienced users can
also employ \code{\link[=options]{options()}} and \code{\link[=show_options]{show_options()}} (refer to \link{surveytable-options}
for further information).
}
\details{
If you are not setting a particular option, leave it as \code{NULL}.

\code{mode} can be either \code{"general"} or \code{"NCHS"} and has the following meaning:
\itemize{
\item \code{"general"}:
\itemize{
\item Round counts to the nearest integer -- same as \code{count = "int"}.
\item Do not look for low-precision estimates -- same as \code{lpe = FALSE}.
\item Percentage CI's: use standard Korn-Graubard CI's.
}
\item \code{"nchs"}:
\itemize{
\item Round counts to the nearest 1,000 -- same as \code{count = "1k"}.
\item Identify low-precision estimates -- same as \code{lpe = TRUE}.
\item Percentage CI's: adjust Korn-Graubard CI's for the number of degrees of
freedom, matching the SUDAAN calculation. NHIS users, be sure to also type
\code{options(surveytable.adjust_svyciprop.df_method = "NHIS")}.
}
}
}
\examples{
# Send output to a CSV file:
file_name = tempfile(fileext = ".csv")
suppressMessages( set_opts(csv = file_name) )
set_survey(namcs2019sv)
tab("AGER")
set_opts(csv = "") # Turn off CSV output

show_opts()
}
\seealso{
Other options: 
\code{\link{set_survey}()},
\code{\link{show_options}()},
\code{\link{surveytable-options}}
}
\concept{options}
