% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survIDM.R
\name{survIDM}
\alias{survIDM}
\title{Create a survIDM object}
\usage{
survIDM(time1, event1, Stime, event, ...)
}
\arguments{
\item{time1}{First time or censoring time.}

\item{event1}{Indicator of the first time; 0 if the first time is censored
and 1 otherwise.}

\item{Stime}{The total time of the process.}

\item{event}{Censoring indicator of the survival time of the process; 0 if
the total time is censored and 1 otherwise.}

\item{...}{Other options.}
}
\value{
An object of class "survIDM". "survIDM" objects are implemented
as a single dataframe.
}
\description{
Creates a "survIDM" object, usually used as a response
variable in a model formula.
}
\details{
Arguments in this function must be introduced in the following
order: \code{time1}, \code{event1}, \code{Stime} and \code{event}, where
\code{time1} and \code{Stime} are the sojourn time in the initial state and
the total time, respectively. \code{event1} and \code{event} denote their
corresponding indicator statuses. This function checks the following
conditions: (i) the arguments \code{time1} and \code{Stime} must be numeric
and nonnegative; \code{event1} and \code{event} must be 0 or 1 if numeric
and TRUE or FALSE if logical. \code{Stime} must be greater or equal to
argument arguments \code{time1}. \code{Stime} and \code{time1} must be
equal when argument \code{event1} equals 0 or FALSE. Argument \code{event}
must be equal to 0 or FALSE when argument \code{event1} equals 0 or FALSE.
When arguments \code{Stime} and \code{time1} are equal and argument
\code{event1} equals 1 or TRUE, argument \code{event} must be equal to
1 or TRUE.
}
\examples{
with(colonIDM, survIDM(time1, event1, Stime, event))
}
\author{
Luis Meira-Machado, Marta Sestelo and Gustavo Soutinho.
}
