% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/akritas.R
\name{akritas}
\alias{akritas}
\title{Akritas Conditional Non-Parametric Survival Estimator}
\usage{
akritas(
  formula = NULL,
  data = NULL,
  reverse = FALSE,
  time_variable = "time",
  status_variable = "status",
  x = NULL,
  y = NULL,
  ...
)
}
\arguments{
\item{formula}{\code{(formula(1))}\cr
Object specifying the model fit, left-hand-side of formula should describe a \code{\link[survival:Surv]{survival::Surv()}}
object.}

\item{data}{\code{(data.frame(1))}\cr
Training data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.}

\item{reverse}{\code{(logical(1))}\cr
If \code{TRUE} fits estimator on censoring distribution, otherwise (default) survival distribution.}

\item{time_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'time' variable, required if \code{formula}.
or \code{x} and \code{Y} not given.}

\item{status_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'status' variable, required if \code{formula}
or \code{x} and \code{Y} not given.}

\item{x}{\code{(data.frame(1))}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Data frame like object of features which is internally
coerced with \code{model.matrix}.}

\item{y}{\verb{([survival::Surv()])}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Survival outcome of right-censored observations.}

\item{...}{\code{ANY} \cr
Additional arguments, currently unused.}
}
\value{
An object inheriting from class \code{akritas}.
}
\description{
The Akritas survival estimator is a conditional nearest-neighbours approach to the
more common Kaplan-Meier estimator. Common usage includes IPCW Survival models and measures,
which do not assume that censoring is independent of the covariates.
}
\details{
This implementation uses a fit/predict interface to allow estimation on unseen data after
fitting on training data. This is achieved by fitting the empirical CDF on the training data
and applying this to the new data.
}
\examples{
if (requireNamespaces(c("distr6",  "survival"))) {
  library(survival)
  akritas(Surv(time, status) ~ ., data = rats[1:10, ])
}
}
\references{
Akritas, M. G. (1994).
Nearest Neighbor Estimation of a Bivariate Distribution Under Random Censoring.
Ann. Statist., 22(3), 1299–1327.
\doi{10.1214/aos/1176325630}
}
