% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_alive}
\alias{filter_alive}
\title{Filter Alive}
\usage{
filter_alive(df, .ep = NULL, .at = "end")
}
\arguments{
\item{df}{Input data frame. Must have \code{version_season}}

\item{.ep}{Episode. This will filter the castaways that are still alive at either the start or end of the episode.}

\item{.at}{Either 'start' or 'end' to filter those who are still alive in the game.}
}
\value{
A data frame filtered to castaways who are alive.
}
\description{
Filters a given dataset to those that are still alive in the game at the start
or end of a user specified episode.
}
\examples{

library(survivoR)
library(dplyr)

confessionals |>
  filter_us(47) |>
  filter_alive(12) |>
  group_by(castaway) |>
  summarise(n = sum(confessional_count))
}
