% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvplot.R
\name{ggsurvplot}
\alias{ggsurvplot}
\alias{print.ggsurvplot}
\title{Drawing Survival Curves Using ggplot2}
\usage{
ggsurvplot(fit, data = NULL, fun = NULL, color = NULL, palette = NULL,
  linetype = 1, break.x.by = NULL, break.y.by = NULL,
  break.time.by = NULL, surv.scale = c("default", "percent"),
  conf.int = FALSE, conf.int.fill = "gray", conf.int.style = "ribbon",
  censor = TRUE, pval = FALSE, pval.size = 5, pval.coord = c(NULL,
  NULL), pval.method = FALSE, pval.method.size = pval.size,
  pval.method.coord = c(NULL, NULL), log.rank.weights = c("survdiff", "1",
  "n", "sqrtN", "S1", "S2", "FH_p=1_q=1"), title = NULL, xlab = "Time",
  ylab = "Survival probability", xlim = NULL, ylim = NULL,
  legend = c("top", "bottom", "left", "right", "none"),
  legend.title = "Strata", legend.labs = NULL, tables.height = 0.25,
  tables.y.text = TRUE, tables.col = "black", risk.table = FALSE,
  risk.table.pos = c("out", "in"), risk.table.title = NULL,
  risk.table.col = tables.col, risk.table.fontsize = 4.5, fontsize = 4.5,
  risk.table.y.text = tables.y.text, risk.table.y.text.col = TRUE,
  risk.table.height = tables.height, surv.plot.height = 0.75,
  ncensor.plot.height = tables.height, cumevents.height = tables.height,
  cumcensor.height = tables.height, ncensor.plot = FALSE,
  ncensor.plot.title = NULL, cumevents = FALSE,
  cumevents.col = tables.col, cumevents.title = NULL,
  cumevents.y.text = tables.y.text, cumevents.y.text.col = TRUE,
  cumcensor = FALSE, cumcensor.col = tables.col, cumcensor.title = NULL,
  cumcensor.y.text = tables.y.text, cumcensor.y.text.col = TRUE,
  surv.median.line = c("none", "hv", "h", "v"), ggtheme = theme_survminer(),
  tables.theme = ggtheme, ...)

\method{print}{ggsurvplot}(x, surv.plot.height = NULL,
  risk.table.height = NULL, ncensor.plot.height = NULL, newpage = TRUE,
  ...)
}
\arguments{
\item{fit}{an object of class survfit.}

\item{data}{a dataset used to fit survival curves. If not supplied then data
will be extracted from 'fit' object.}

\item{fun}{an arbitrary function defining a transformation of the survival
curve.  Often used transformations can be specified with a character
argument: "event" plots cumulative events (f(y) = 1-y), "cumhaz" plots the
cumulative hazard function (f(y) = -log(y)), and "pct" for survival
probability in percentage.}

\item{color}{color to be used for the survival curves. This argument is
ignored when the number of strata (groups > 1). In this case, use the
argument palette.}

\item{palette}{the color palette to be used. Allowed values include "hue" for
the default hue color scale; "grey" for grey color palettes; brewer palettes
e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red").
See details section for more information.}

\item{linetype}{line types. Allowed values includes i) "strata" for changing
linetypes by strata (i.e. groups); ii) a numeric vector (e.g., c(1, 2)) or a
character vector c("solid", "dashed").}

\item{break.x.by}{alias of break.time.by. Numeric value controlling x axis breaks. Default value is NULL.}

\item{break.y.by}{same as break.x.by but for y axis.}

\item{break.time.by}{numeric value controlling time axis breaks. Default value is NULL.}

\item{surv.scale}{scale transformation of survival curves. Allowed values are
"default" or "percent".}

\item{conf.int}{logical value. If TRUE, plots confidence interval.}

\item{conf.int.fill}{fill color to be used for confidence interval.}

\item{conf.int.style}{confidence interval style. Allowed values include
c("ribbon", "step").}

\item{censor}{logical value. If TRUE, censors will be drawn.}

\item{pval}{logical value. If TRUE, the p-value is added on the plot.}

\item{pval.size}{numeric value specifying the p-value text size. Default is 5.}

\item{pval.coord}{numeric vector, of length 2, specifying the x and y
coordinates of the p-value. Default values are NULL.}

\item{pval.method}{whether to add a text with the test name used for
calculating the pvalue, that corresponds to survival curves' comparison -
used only when \code{pval=TRUE}}

\item{pval.method.size}{the same as \code{pval.size} but for displaying
\code{log.rank.weights} name}

\item{pval.method.coord}{the same as \code{pval.coord} but for displaying
\code{log.rank.weights} name}

\item{log.rank.weights}{The name for the type of weights to be used in
computing the p-value for log-rank test. By default \code{survdiff} is used
to calculate regular log-rank test (with weights == 1). A user can specify
\code{"1", "n", "sqrtN", "S1", "S2", "FH"} to use weights specified in
\link[survMisc]{comp}, so that weight correspond to the test as : 1 -
log-rank, n - Gehan-Breslow (generalized Wilcoxon), sqrtN - Tarone-Ware, S1
- Peto-Peto's modified survival estimate, S2 - modified Peto-Peto (by
Andersen), FH - Fleming-Harrington(p=1, q=1).}

\item{title, xlab, ylab}{main title and axis labels}

\item{xlim, ylim}{x and y axis limits e.g. xlim = c(0, 1000), ylim = c(0, 1).}

\item{legend}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). Default is "top" side position.
to remove the legend use legend = "none". Legend position can be also
specified using a numeric vector c(x, y); see details section.}

\item{legend.title}{legend title.}

\item{legend.labs}{character vector specifying legend labels. Used to replace
the names of the strata from the fit. Should be given in the same order as
those strata.}

\item{tables.height}{numeric value (in [0 - 1]) specifying the general height
of all tables under the main survival plot.}

\item{tables.y.text}{logical. Default is TRUE. If FALSE, the y axis tick
labels of tables will be hidden.}

\item{tables.col}{color to be used for all tables under the main plot. Default value is
"black". If you want to color by strata (i.e. groups), use tables.col =
"strata".}

\item{risk.table}{Allowed values include: \itemize{ \item TRUE or FALSE
specifying whether to show or not the risk table. Default is FALSE. \item
"absolute" or "percentage": to show the \bold{absolute number} and the
\bold{percentage} of subjects at risk by time, respectively. Use i)
"abs_pct" to show both absolute number and percentage. ii) "nrisk_cumcensor"
and "nrisk_cumevents" to show the number at risk and, the cumulative number
of censoring and events, respectively. }}

\item{risk.table.pos}{character vector specifying the risk table position.
Allowed options are one of c("out", "in") indicating 'outside' or 'inside'
the main plot, respectively. Default value is "out".}

\item{risk.table.title}{The title to be used for the risk table.}

\item{risk.table.col}{same as tables.col but for risk table only.}

\item{risk.table.fontsize, fontsize}{font size to be used for the risk table
and the cumulative events table.}

\item{risk.table.y.text}{logical. Default is TRUE. If FALSE, risk table y axis
tick labels will be hidden.}

\item{risk.table.y.text.col}{logical. Default value is FALSE. If TRUE, risk
table tick labels will be colored by strata.}

\item{risk.table.height}{the height of the risk table on the grid. Increase
the value when you have many strata. Default is 0.25. Ignored when
risk.table = FALSE.}

\item{surv.plot.height}{the height of the survival plot on the grid. Default
is 0.75. Ignored when risk.table = FALSE. \code{1-risk.table.height -
ncensor.plot.height} when \code{risk.table = TRUE} and \code{ncensor.plot =
TRUE}}

\item{ncensor.plot.height}{The height of the censor plot. Used when
\code{ncensor.plot = TRUE}.}

\item{cumevents.height}{the height of the cumulative events table on the grid.
Default is 0.25. Ignored when cumevents = FALSE.}

\item{cumcensor.height}{the height of the cumcensor table on the grid. Default
is 0.25. Ignored when cumcensor = FALSE.}

\item{ncensor.plot}{logical value. If TRUE, the number of censored subjects at
time t is plotted. Default is FALSE. Ignored when cumcensor = TRUE.}

\item{ncensor.plot.title}{The title to be used for the censor plot. Used when
\code{ncensor.plot = TRUE}.}

\item{cumevents}{logical value specifying whether to show or not the table of
the cumulative number of events. Default is FALSE.}

\item{cumevents.col}{same as tables.col but for the cumulative events table only.}

\item{cumevents.title}{The title to be used for the cumulative events table.}

\item{cumevents.y.text}{logical. Default is TRUE. If FALSE, the y axis tick
labels of the cumulative events table  will be hidden.}

\item{cumevents.y.text.col}{logical. Default value is FALSE. If TRUE, the y
tick labels of the cumulative events will be colored by strata.}

\item{cumcensor}{logical value specifying whether to show or not the table of
the cumulative number of censoring. Default is FALSE.}

\item{cumcensor.col}{same as tables.col but for cumcensor table only.}

\item{cumcensor.title}{The title to be used for the cumcensor table.}

\item{cumcensor.y.text}{logical. Default is TRUE. If FALSE, the y axis tick
labels of the cumcensor table will be hidden.}

\item{cumcensor.y.text.col}{logical. Default value is FALSE. If TRUE, the y
tick labels of the cumcensor will be colored by strata.}

\item{surv.median.line}{character vector for drawing a horizontal/vertical
line at median survival. Allowed values include one of c("none", "hv", "h",
"v"). v: vertical, h:horizontal.}

\item{ggtheme}{function, ggplot2 theme name. Default value is
\link{theme_survminer}. Allowed values include ggplot2 official themes: see
\code{\link[ggplot2]{theme}}.}

\item{tables.theme}{function, ggplot2 theme name. Default value is
\link{theme_survminer}. Allowed values include ggplot2 official themes: see
\code{\link[ggplot2]{theme}}.}

\item{...}{other arguments to be passed i) to ggplot2 geom_*() functions such
as linetype, size, ii) or to the function ggpubr::ggpar() for customizing
the plots. See details section.}

\item{x}{an object of class ggsurvplot}

\item{newpage}{open a new page. See \code{\link{grid.arrange}}}
}
\value{
return an object of class ggsurvplot which is list containing the
 following components: \itemize{ \item plot: the survival plot (ggplot
 object) \item table: the number of subjects at risk table per time (ggplot
 object). \item cumevents: the cumulative number of events table (ggplot
 object). \item ncensor.plot: the number of censoring (ggplot object). \item
 data.survplot: the data used to plot the survival curves (data.frame). \item
 data.survtable: the data used to plot the tables under the main survival
 curves (data.frame). }
}
\description{
Drawing survival curves using ggplot2
}
\details{
\itemize{ \item \strong{legend position}: The argument \strong{legend} can be also a
 numeric vector c(x,y). In this case it is possible to position the legend
 inside the plotting area. x and y are the coordinates of the legend box.
 Their values should be between 0 and 1. c(0,0) corresponds to the "bottom
 left" and c(1,1) corresponds to the "top right" position. For instance use
 legend = c(0.8, 0.2).\cr \item \strong{Color palettes}: The argument
 \strong{palette} can be used to specify the color to be used for each group.
 By default, the first color in the palette is used to color the first level
 of the factor variable. This default behavior can be changed by assigning
 correctly a named vector. That is, the names of colors should match the
 strata names as generated by the \code{ggsurvplot()} function in the
 legend.\cr \item \strong{Customizing the plots}: The plot can be easily
 customized using additional arguments to be passed to the function ggpar().
 Read ?ggpubr::ggpar. These arguments include
 \emph{font.title, font.subtitle, font.caption, font.x, font.y, font.tickslab and font.legend}:
  a vector of length 3 indicating respectively the size (e.g.: 14), the style
 (e.g.: "plain", "bold", "italic", "bold.italic") and the color (e.g.: "red")
 of main title, subtitle, caption, xlab and ylab, axis tick labels and legend,
 respectively. For example \emph{font.x = c(14, "bold", "red")}.  Use font.x
 = 14, to change only font size; or use font.x = "bold", to change only font
 face.}
}
\section{Functions}{
\itemize{
\item \code{ggsurvplot}: Draws survival curves using ggplot2.
}}

\examples{

#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Example 1: Survival curves with two groups
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%

# Fit survival curves
#++++++++++++++++++++++++++++++++++++
require("survival")
fit<- survfit(Surv(time, status) ~ sex, data = lung)

# Basic survival curves
ggsurvplot(fit, data = lung)

# Customized survival curves
ggsurvplot(fit, data = lung,
 surv.median.line = "hv", # Add medians survival

 # Change legends: title & labels
 legend.title = "Sex",
 legend.labs = c("Male", "Female"),
 # Add p-value and confidence intervals
 pval = TRUE,

 conf.int = TRUE,
 # Add risk table
 risk.table = TRUE,
 tables.height = 0.2,
 tables.theme = theme_cleantable(),

 # Color palettes. Use custom color: c("#E7B800", "#2E9FDF"),
 # or brewer color (e.g.: "Dark2"), or ggsci color (e.g.: "jco")
 palette = c("#E7B800", "#2E9FDF"),
 ggtheme = theme_bw() # Change ggplot2 theme
)

# Change font size, style and color
#++++++++++++++++++++++++++++++++++++
\dontrun{
# Change font size, style and color at the same time
ggsurvplot(fit, data = lung,  main = "Survival curve",
   font.main = c(16, "bold", "darkblue"),
   font.x = c(14, "bold.italic", "red"),
   font.y = c(14, "bold.italic", "darkred"),
   font.tickslab = c(12, "plain", "darkgreen"))
}



#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Example 2: Facet ggsurvplot() output by
# a combination of factors
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%

# Fit (complexe) survival curves
#++++++++++++++++++++++++++++++++++++
\dontrun{
require("survival")
fit3 <- survfit( Surv(time, status) ~ sex + rx + adhere,
                data = colon )

# Visualize
#++++++++++++++++++++++++++++++++++++
ggsurv <- ggsurvplot(fit3, data = colon,
  fun = "cumhaz", conf.int = TRUE,
  risk.table = TRUE, risk.table.col="strata",
  ggtheme = theme_bw())

# Faceting survival curves
curv_facet <- ggsurv$plot + facet_grid(rx ~ adhere)
curv_facet

# Faceting risk tables:
# Generate risk table for each facet plot item
ggsurv$table + facet_grid(rx ~ adhere, scales = "free")+
 theme(legend.position = "none")

 # Generate risk table for each facet columns
tbl_facet <- ggsurv$table + facet_grid(.~ adhere, scales = "free")
tbl_facet + theme(legend.position = "none")

# Arrange faceted survival curves and risk tables
g2 <- ggplotGrob(curv_facet)
g3 <- ggplotGrob(tbl_facet)
min_ncol <- min(ncol(g2), ncol(g3))
g <- gridExtra::rbind.gtable(g2[, 1:min_ncol], g3[, 1:min_ncol], size="last")
g$widths <- grid::unit.pmax(g2$widths, g3$widths)
grid::grid.newpage()
grid::grid.draw(g)

}

}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
