## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE,comment = "#",fig.width = 5,
                      fig.height = 3,fig.align = "center",
                      fig.cap = "&nbsp;",dpi = 120)

## -----------------------------------------------------------------------------
library(susieR)
set.seed(1)

## -----------------------------------------------------------------------------
data(N3finemapping)
attach(N3finemapping)

## -----------------------------------------------------------------------------
dim(Y)

## -----------------------------------------------------------------------------
b <- true_coef[,1]
plot(b, pch=16, ylab='effect size')

## -----------------------------------------------------------------------------
which(b != 0)

## -----------------------------------------------------------------------------
sumstats <- univariate_regression(X, Y[,1])
z_scores <- sumstats$betahat / sumstats$sebetahat
susie_plot(z_scores, y = "z", b=b)

## -----------------------------------------------------------------------------
R <- cor(X)

## -----------------------------------------------------------------------------
fitted_rss <- susie_rss(z_scores, R, L = 10)

## -----------------------------------------------------------------------------
summary(fitted_rss)$cs

## -----------------------------------------------------------------------------
susie_plot(fitted_rss, y="PIP", b=b)

## ---- fig.width=6,fig.height=6------------------------------------------------
fitted = susie(X, Y[,1], L = 10)
plot(fitted$pip, fitted_rss$pip, ylim=c(0,1))

## -----------------------------------------------------------------------------
sessionInfo()

