% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_env.R
\name{temp_env}
\alias{temp_env}
\alias{add_items}
\alias{add_temp}
\alias{assign_temp}
\alias{change_temp}
\alias{exists_temp}
\alias{get_temp}
\alias{delete_temp}
\alias{rm_temp}
\alias{TempEnv}
\alias{addItems}
\alias{addTemp}
\alias{assignTemp}
\alias{changeTemp}
\alias{existsTemp}
\alias{getTemp}
\alias{rmTemp}
\title{Get an environment dedicated to temporary variables (and create it if needed)}
\usage{
temp_env()

add_items(x, y, use.names = TRUE, replace = TRUE)

add_temp(x, item, value, use.names = TRUE, replace = TRUE)

assign_temp(x, value, replace.existing = TRUE)

change_temp(x, item, value, replace.existing = TRUE)

exists_temp(x, mode = "any")

get_temp(x, default = NULL, mode = "any", item = NULL)

delete_temp(x)

rm_temp(x)

TempEnv()

addItems(x, y, use.names = TRUE, replace = TRUE)

addTemp(x, item, value, use.names = TRUE, replace = TRUE)

assignTemp(x, value, replace.existing = TRUE)

changeTemp(x, item, value, replace.existing = TRUE)

existsTemp(x, mode = "any")

getTemp(x, default = NULL, mode = "any", item = NULL)

rmTemp(x)
}
\arguments{
\item{x}{The vector to add items to for \code{add_items()} or any object. for
\code{delete_temp()}, it is the name of the variable (character string), or a
vector of characters with the name of all variables to remove from
\code{SciViews:TempEnv}.}

\item{y}{The vector of which we want to inject missing items in 'x'.}

\item{use.names}{Use names of items to determine which one is unique,
otherwise, the selection is done on the items themselves.}

\item{replace}{Do we replace existing items in 'x'?}

\item{item}{The item to add data to in the list.}

\item{value}{The value to add in the item, it must be a named vector and
element matching is done according to name of items.}

\item{replace.existing}{Do we replace an existing variable?}

\item{mode}{The mode of the seeked variable}

\item{default}{The default value to return, in case the variable or the item
does not exist.}
}
\value{
The temporary environment for \code{temp-env()}, the value assigned, added
or changed for \code{assign_temp()}, \code{add_temp()}, \code{change_temp()}, or
\code{get_temp()}. \code{TRUE} or \code{FALSE} for \code{exists_temp()}, \code{delete_temp()} or
\code{rm_temp()}.
}
\description{
Create and manage a temporary environment \code{SciViews:TempEnv}
low enough on the search path so that all loaded packages (except \strong{base})
could easily access objects there.
}
\details{
The temporary environment is attached to the search path for easier
access to its objects.
}
\examples{
ls(temp_env())

# I have a vector v1 with this:
v1 <- c(a = "some v1 text", b = "another v1 text")
# I want to add items whose name is missing in v1 from v2
v2 <- c(a = "v2 text", c = "the missign item")
add_items(v1, v2, replace = FALSE)
# Not the same as
add_items(v1, v2, replace = TRUE)
# This yield different result (names not used and lost!)
add_items(v1, v2, use.names = FALSE)

add_temp("tst", "item1", c(a = 1, b = 2))
# Retrieve this variable
get_temp("tst")
# Add to item1 in this list without replacement
add_temp("tst", "item1", c(a = 45, c = 3), replace = FALSE)
get_temp("tst")
# Same but with replacement of existing items
add_temp("tst", "item1", c(a = 45, c = 3), replace = TRUE)
get_temp("tst")
# Delete the whole variable
delete_temp("tst")

assign_temp("test", 1:10)
# Retrieve this variable
get_temp("test")

change_temp("tst", "item1", 1:10)
# Retrieve this variable
get_temp("tst")
# Create another item in the list
change_temp("tst", "item2", TRUE)
get_temp("tst")
# Change it
change_temp("tst", "item2", FALSE)
get_temp("tst")
# Delete it (= assign NULL to the item)
change_temp("tst", "item2", NULL)
get_temp("tst")
# Delete the whole variable
delete_temp("tst")

assign_temp("test", 1:10)
# Check if this variable exists
exists_temp("test")
# Remove it
delete_temp("test")
# Does it still exists?
exists_temp("test")
}
\seealso{
\code{\link[=assign]{assign()}}, \code{\link[=search]{search()}}, \code{\link[=temp_var]{temp_var()}}
}
\concept{
temporary variables
}
\keyword{utilities}
