% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_socket_clients.R
\name{send_socket_clients}
\alias{send_socket_clients}
\alias{sendSocketClients}
\title{Send data to one or more clients through a socket}
\usage{
send_socket_clients(text, sockets = "all", server_port = 8888)

sendSocketClients(text, sockets = "all", server_port = 8888)
}
\arguments{
\item{text}{the text to send to the client(s).}

\item{sockets}{the Tcl name of the client(s) socket(s) currently connected
(\code{sockXXX}), or \code{"all"} (by default) to send the same text to all connected
clients.}

\item{server_port}{the port of the server considered.}
}
\description{
The text is send to one or more clients of the R socket server currently
connected.
}
\examples{
\dontrun{
# Start an R process (R#1) and make it a server
library(svSocket)
server_port <- 8888  # Port 8888 by default, but you can change it
start_socket_server(port = server_port)


# Start a second R process (R#2) and run this code in it (the R client):
library(svSocket)
# Connect with the R socket server
con <- socketConnection(host = "localhost", port = 8888, blocking = FALSE)


# Now, go back to the server R#1
get_socket_clients() # You should have one client registered
# Send something to all clients from R#1
send_socket_clients("Hi there!")


# Switch back to client R#2
# Since the connection is not blocking, you have to read lines actively
readLines(con)
# Note the final empty string indicating there is no more data
close(con) # Once done...


# Switch to the R#1 server and close the server
stop_socket_server(port = server_port)
}
}
\seealso{
\code{\link[=close_socket_clients]{close_socket_clients()}}, \code{\link[=process_socket_server]{process_socket_server()}}
}
\concept{stateful socket server interprocess communication}
\keyword{IO}
\keyword{utilities}
