% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fev.R
\name{fev}
\alias{fev}
\title{Forecast error variance decomposition for SVAR Models}
\usage{
fev(x, horizon = 10)
}
\arguments{
\item{x}{SVAR object of class "svars"}

\item{horizon}{Time horizon for forecast error variance decomposition}
}
\description{
Calculation of forecast error variance decomposition for an identified SVAR object 'svars' derived by function id.cvm( ),id.cv( ),id.dc( ) or id.ngml( ).
}
\examples{
\donttest{
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)
x2 <- fev(x1, horizon = 30)
plot(x2)
}

}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.dc}}, \code{\link{id.ngml}} or \code{\link{id.cv}}
}
