% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.svars.R
\name{fevd}
\alias{fevd}
\alias{fevd.svars}
\title{Forecast error variance decomposition for SVAR Models}
\usage{
\method{fevd}{svars}(x, n.ahead = 10, ...)
}
\arguments{
\item{x}{SVAR object of class "svars".}

\item{n.ahead}{Integer specifying the steps.}

\item{...}{Currently not used.}
}
\value{
A list with class attribute "svarfevd" holding the forecast error variance decompositions as data frames.
}
\description{
Calculation of forecast error variance decomposition for an identified SVAR object 'svars' derived by function id.st( ), id.cvm( ),id.cv( ),id.dc( ) or id.ngml( ).
}
\examples{
\donttest{
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)
x2 <- fevd(x1, n.ahead = 30)
plot(x2)
}

}
\references{
Kilian, L., Luetkepohl, H., 2017. Structural Vector Autoregressive Analysis, Cambridge University Press.
}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.garch}}, \code{\link{id.dc}}, \code{\link{id.ngml}}, \code{\link{id.cv}} or \code{\link{id.st}}
}
