% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{stackedBar}
\alias{stackedBar}
\title{Adjust (stacked) bar chart to values on a given scale}
\usage{
stackedBar(
  svg,
  frame_name,
  group_name,
  scale_real,
  values,
  alignment = "horizontal",
  has_labels = TRUE,
  label_position = "center",
  decimals = 0,
  display_limits = 0,
  ...
)
}
\arguments{
\item{svg}{XML document with SVG content}

\item{frame_name}{Name (attribute 'id') of frame (XML element 'rect') for positioning bar segments (and value labels).}

\item{group_name}{Name (attribute 'id') of group (XML element 'g') containing either bar segments (and value labels) or further groups, containing bar segments (and value labels) themselves.}

\item{scale_real}{Numeric vector (e.g. \code{c(0,100)}) of arbitrary length. Only minimum and maximum are used for scaling of values.}

\item{values}{Either a numeric vector, a numeric matrix or a dataframe with only numeric columns.\cr
If a vector is given, it corresponds to one bar (group of bar segments and, optionally, value labels).\cr
If a matrix or dataframe is given, rows define the value set for several (stacked) bars grouped together.}

\item{alignment}{Character value. Accepts 'horizontal' (default) or 'vertical'. See details.}

\item{has_labels}{Are there value labels (of XML type 'text') to adjust? (default TRUE)}

\item{label_position}{Character value. Accepts 'start', 'center' (default) and 'end'. This refers to the underlying bar segments.}

\item{decimals}{Integer value defining the number of decimal digits of value labels (default 0).}

\item{display_limits}{Interval for (small) values, that lead to suppression of the corresponding value labels. If only one value x is given, it is turned into the interval c(-x,x). (default 0 = no suppression)}

\item{...}{Further arguments used internally by \code{\link{referenceBar}}, \code{\link{diffBar}} and \code{\link{percentileBar}}.}
}
\value{
XML document with SVG content
}
\description{
Adjusts the horizontal (XML attribute 'x') or vertical (XML attribute 'y') position as well as width/height of bar segments (XML elements of type 'rect') and optionally value labels (XML elements of type 'text'). Positions are calculated relative to a given frame (XML element of type 'rect') and the position of a data value within the minimum and maximum of a given scale. This process is called scaling.\cr
In preparation, it is necessary to name a group (set attribute 'id' of XML element of type 'g') of bar segments (and value labels). Bar segments (and value labels) need to be of the same amount as there are data values for adjustment.\cr
It is possible to group several such groups together. Only the outer group needs to be named in that case, for convenience.
}
\details{
'Horizontal' alignment refers to adjustment of the x-coordinates of elements, 'vertical' alignment to adjustment of the y-coordinates.\cr
Bar segments and, optionally, value labels may be grouped together in any order in the SVG file. The function will automatically use XML elements from left to right (with \code{alignment='horizontal'}) or bottom to top (with \code{alignment='vertical'}) according to their x/y-coordinates.\cr
Furthermore, the SVG file order of several bars grouped together in an outer group is irrelevant. The function will automatically use bars (that is, groups of bar segments and, optionally, value labels) from top to bottom (with \code{alignment='horizontal'}) or left to right (with \code{alignment='vertical'}) according to the lowest x/y-coordinate of any element.\cr
Bar segments and value labels (if any) are automatically hidden (XML attribute 'diplay' is set to 'none'), when a value of 0 or NA is provided. Subsequent calls to the function with non-zero or non-NA values make such elements reappear in the output.
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig3.svg", package="svgtools")
svg <- read_svg(file = fpath)

#adjust bars
svg <- stackedBar(svg = svg, frame_name = "frame", group_name = "overall",
                  scale_real = c(0,160), values = c(9.97,42.42,105.71), 
                  alignment = "vertical", has_labels = TRUE, 
                  label_position = "end", decimals = 0, display_limits = 10)
df.subgroups <- matrix(1:9*8, nrow=3)
svg <- stackedBar(svg = svg, frame_name = "frame", group_name = "subgroups", 
                  scale_real = c(0,160), values = df.subgroups, 
                  alignment = "vertical", display_limits = 10)
}
