% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fast_lsa}
\alias{fast_lsa}
\alias{fast_lsi}
\title{Latent Semantic Analysis}
\usage{
fast_lsa(dat, local_weights = "log", global_weights = "idf")

fast_lsi(dat, local_weights = "log", global_weights = "idf")
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}

\item{local_weights}{Character specification of the local weighting function (without a prefix): see
\link[=weighting_functions]{Weighting functions}.}

\item{global_weights}{Character specification of the global weighting function (without a prefix): see
\link[=weighting_functions]{Weighting functions}.}
}
\value{
A list with components:
\item{\code{val} }{The singular values, indicating how much each latent axis explains.}
\item{\code{pos1} }{The coordinates of the first set of levels (\emph{viz.} the row levels of a frequency table).}
\item{\code{pos2} }{The coordinates of the second set of levels (\emph{viz.} the column levels of a frequency table).}
}
\description{
A fast procedure for computing latent semantic analysis.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
lsa.SndT_Fra <- fast_lsa(SndT_Fra)
lsa.SndT_Fra
}
\references{
Deerwester, S., S. T. Dumais, G. W. Furnas, Th. K. Landauer and R. Harshman (1990) Indexing by latent semantic analysis.
  \emph{Journal of the American society for information science} \strong{41} (6), 391--407.

Landauer, Th. K. and S. T. Dumais (1997) A solution to Plato's problem: the latent semantic analysis theory of the
  acquisition, induction, and representation of knowledge. \emph{Psychological review} \strong{104}, 211--240.
}

