\name{prince.plot}
\alias{prince.plot}
\title{
Heatmap of the associations between principal components and sample annotations
}
\description{
This function uses the calculations performed by prince() and plots the log10 of p-values obtained by the linear models.
}
\usage{
prince.plot(prince, label = colnames(prince$o), smallest = -20, note = F, 
            notecol = "black", notecex = 1, 
            breaks = seq(-20,0,length.out=100), col = heat.colors(99), 
            margins = c(5, 7), key = T, cexRow = 1, cexCol = 1, 
            xlab = "Principal Components (Variation)", colsep = NULL, 
            rowsep = NULL, sepcolor = "black", sepwidth = c(0.05,0.05),
            Rsquared = F, breaksRsquared = seq(0,1,length.out=100) )
}
\arguments{
  \item{prince}{an object generated by the function prince()
}
  \item{label}{vector containing names of the sample annotation.
}
  \item{smallest}{a numeric value. log10(p-values) less than smallest are set to smallest for plotting. default = -20.
                  e.g. a log10 p-value of -37 will be set to -20. Smallest has to be less than 0.  
}
  \item{note}{set to TRUE to print the p-values in the cells of the plot.
}
  \item{notecol}{to determine the color of the notes
}
  \item{notecex}{to determine the font size of the notes
}
  \item{breaks}{either a number (default=100) or a numeric vector (default would be seq(-20,0,length.out=100)) of breaks for the colors
}
  \item{col}{a vector of colors with a length of breaks-1. default=heat.colors(99).
}
  \item{margins}{a vector with the margins for columns and rows. default=c(5,7).
}
  \item{key}{whether the color key should be printed, default=TRUE.
}
  \item{cexRow}{font size of label. default=1.
}
  \item{cexCol}{font size of column labeling. default=1.
}
  \item{xlab}{an additional character vector to print at the bottom.
}
  \item{colsep}{same as in heatmap.2 function.
}
  \item{rowsep}{same as in heatmap.2 function.
}
  \item{sepcolor}{same as in heatmap.2 function.
}
  \item{sepwidth}{same as in heatmap.2 function.
}
  \item{Rsquared}{set to TRUE to print Rsquared values instead of log10 p-values. 
                  Missing values in object o will flaw the comparability of p-values. 
}
  \item{breaksRsquared}{same format as argument breaks. will be used when Rsquared=TRUE
}
}
\details{
This plot indicates batch effects, and shows the influence of the biological annotations on the overall variation. The input has to be an object generated by the prince() function. The plot is based on the heatmap.2 function from the gplots package. Colors, breaks, font size and margins can be changed and cell notes can be added.
The log10 of p-values from linear model are plotted. If Rsquared is TRUE the R-squared values from linear model are plotted instead.
}
\author{Martin Lauss}
\note{requires the package gplots}
\examples{
## data as a matrix
set.seed(100)
g<-matrix(nrow=1000,ncol=50,rnorm(1000*50),dimnames=list(paste("Feature",1:1000),
          paste("Sample",1:50)))
g[1:100,26:50]<-g[1:100,26:50]+1 # the first 100 features show higher values in the samples 26:50
## patient annotations as a data.frame, annotations should be numbers and factors but not characters.
## rownames have to be the same as colnames of the data matrix 
set.seed(200)
o<-data.frame(Factor1=factor(c(rep("A",25),rep("B",25))),
              Factor2=factor(rep(c("A","B"),25)),
              Numeric1=rnorm(50),row.names=colnames(g))
              
## calculate principal components and use linear models to calculate their 
## dependence on sample annotations
res1<-prince(g,o,top=10)
## plot p-values as heatmap
prince.plot(prince=res1)
}

\keyword{ cluster }
\keyword{ regression}
