% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pin_sex}
\alias{pin_sex}
\title{Calculate sex from \code{pin}}
\usage{
pin_sex(pin)
}
\arguments{
\item{pin}{Character vector with swedish personal identity numbers with standard ABS format \code{"YYYYMMDDNNNC"}. See \link{pin_format}.}
}
\value{
Factor with label 'Male' and 'Female'.
}
\description{
Calculates the sex of from the personal identification number.
}
\examples{
# Examples taken from SKV 704 (see references)
ex_pin <- c("196408233234", "186408233224")
pin_sex(ex_pin)
}
\references{
\href{https://www.skatteverket.se/download/18.8dcbbe4142d38302d74be9/1387372677724/717B06.pdf}{Population registration in Sweden}
\href{https://www.skatteverket.se/download/18.1e6d5f87115319ffba380001857/1285595720207/70408.pdf}{SKV 704}
\href{http://www.riksdagen.se/sv/Dokument-Lagar/Utredningar/Statens-offentliga-utredningar/Personnummer-och-samordningsnu_GWB360/}{SOU 2008:60 : Personnummer och samordningsnummer}
}

