% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_birthplace}
\alias{pin_birthplace}
\title{Calculate the birthplace of \code{pin}}
\usage{
pin_birthplace(pin)
}
\arguments{
\item{pin}{A vector of class \code{pin}. See \link{as.pin}.}
}
\value{
Birthplace as factor.
}
\description{
Calculate the birthplace for a given personal identity number born before 1990. See details.
}
\details{
It is possible to calculate where people where born (and/or if a person has immigrated)
through their personal identity number. This is possible for people that was born
before 1990 and after 1945.

For people born before 1946 the birthplace identifier contains information on where
one where registered the 1st of november 1946.

Personal identity numbers for people born after 1989 do not contain any information
on birthplace.

During the period 1946 - 1989 the pin also contains information on whether one has
immigrated to Sweden during the period.
}
\examples{
# Example with someone born today and from SKV 704 (see references)
today_pin <- paste0(format(Sys.Date(),"\%Y\%m\%d"), "0000")
ex_pin <- c("196408233234", today_pin)
pin_birthplace(ex_pin)
}
\references{
\href{http://www.riksdagen.se/sv/Dokument-Lagar/Utredningar/Statens-offentliga-utredningar/Personnummer-och-samordningsnu_GWB360/}{SOU 2008:60 : Personnummer och samordningsnummer}
}

