% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_3d_variance.R
\name{point_3d_variance}
\alias{point_3d_variance}
\title{Calculate sample variance of 3D point distance from centroid}
\usage{
point_3d_variance(point_matrix)
}
\arguments{
\item{point_matrix}{An n-by-3 numerical matrix where each
row corresponds to a single point in 3D space.}
}
\value{
A one-element numeric vector holding calculated variance
}
\description{
Calculates sample variance of points' distances in
3D space from their centroid. This function is normally only used
indirectly through `validate_get_twcv`.
}
\section{Details}{

The variance here is taken to mean
the sum of variances for each dimension/axis:
\deqn{
\frac{\sum_{i=1}^n (x_i-x_m)^2 + (y_i-y_m)^2 + (z-z_m)^2}{n-1}
}{
sum_(i=1)^n ((x - x_m)^2 + (y - y_m)^2 + (z - z_m)^2) / (n - 1)
}
Where \eqn{X/Y/Z} represent one axis each, \eqn{a_m}{a_m} represents the mean
of all points' coordinates on an axis, and \eqn{n} represents the total
number of points.
}

\seealso{
\code{\link{centroid_3d_sq_dist}}
}
