% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchicalModels.R
\name{Model.p.Fitness.Servedio}
\alias{Model.p.Fitness.Servedio}
\title{Multiplicative Fitness Model for Power Law}
\usage{
Model.p.Fitness.Servedio(n, alpha, meandegree, sdprop = 0.1)
}
\arguments{
\item{n}{dimension of matrix.}

\item{alpha}{exponent for power law. Must be <=-1.}

\item{meandegree}{overall mean degree (expected degree divided by number of nodes). Must be in (0,1).}

\item{sdprop}{standard deviation of updated steps.}
}
\description{
This model has a power law of the degree distribution with a
parameter {\eqn{\alpha}{alpha}} and is tuned to a desired link
existence probability. It is based on a fitness model.
}
\details{
Every node \eqn{i} has a fitness \eqn{\theta_i}{theta_i} being an
independent realisation of a U[0,1] distribution.  The probability
of a link between a node with fitness x and a node with fitness y
is g(x)g(y) where g is as follows.  If \eqn{\alpha=-1}{alph=-1a}
then \deqn{g(x)=g0*\exp(-\log(g0)*x)}{g(x)=g0*exp(-log(g0)*x)}
Otherwise,
\deqn{g(x)=(g0^(\alpha+1)+(1-g0^(\alpha+1))*x)^(1/(\alpha+1))}{g(x)=(g0^(\alpha+1)+(1-g0^(\alpha+1))*x)^(1/(\alpha+1))}
where \eqn{g0}{g0} is tuned numerically to achieve the desired
overall mean degree.

Updating of the model parameters in the MCMC setup is done via a
Metropolis-Hastings step, adding independent centered normal random
variables to each node fitness in \eqn{\theta}{theta}.
}
\examples{
n <- 5
mf <- Model.p.Fitness.Servedio(n=n,alpha=-2.5,meandegree=0.5)
m <- Model.Indep.p.lambda(model.p=mf,
                          model.lambda=Model.lambda.GammaPrior(n,scale=1e-1))
x <- genL(m)
l <- rowSums(x$L)
a <- colSums(x$L)
res <- sample_HierarchicalModel(l,a,model=m,nsamples=10,thin=10)


}
\references{
Servedio V. D. P. and Caldarelli G. and Butta P. (2004)
Vertex intrinsic fitness: How to produce arbitrary scale-free networks.
\emph{Physical Review E} 70, 056126.
}

